/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class X509Key
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    @Deprecated
    protected byte[] key = null;
    private int unusedBits = 0;
    private BitArray bitStringKey = null;
    protected byte[] encodedKey;

    public X509Key() {
    }

    private X509Key(AlgorithmId algorithmId, BitArray bitArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.setKey(bitArray);
        this.encode();
    }

    protected void setKey(BitArray bitArray) {
        this.bitStringKey = (BitArray)bitArray.clone();
        this.key = bitArray.toByteArray();
        int n = bitArray.length() % 8;
        this.unusedBits = n == 0 ? 0 : 8 - n;
    }

    protected BitArray getKey() {
        this.bitStringKey = new BitArray(this.key.length * 8 - this.unusedBits, this.key);
        return (BitArray)this.bitStringKey.clone();
    }

    public static PublicKey parse(DerValue derValue) throws IOException {
        PublicKey publicKey;
        if (derValue.getTag() != 48) {
            throw new IOException("corrupt subject key");
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
        try {
            publicKey = X509Key.buildX509Key(algorithmId, derValue.getData().getUnalignedBitString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("subject key, " + invalidKeyException.getMessage());
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("excess subject key");
        }
        return publicKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, BitArray bitArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        X509Key.encode(derOutputStream, algorithmId, bitArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.toString());
        }
        return new X509Key(algorithmId, bitArray);
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        X509Key.encode(derOutputStream, this.algid, this.getKey());
    }

    public synchronized byte[] getEncoded() {
        byte[] byArray = null;
        try {
            byArray = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return byArray;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            this.algid = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
            this.setKey(derValue.getData().getUnalignedBitString());
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("IOException: " + iOException.getMessage());
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            byte[] byArray = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            byte[] byArray2 = key.getEncoded();
            return MessageDigest.isEqual(byArray, byArray2);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        byte[] byArray = this.getEncoded();
        for (int i = 1; i < byArray.length; ++i) {
            n += byArray[i] * i;
        }
        return n;
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, BitArray bitArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putUnalignedBitString(bitArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }
}

