/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import com.ibm.jvm.ClassLoader;
import com.ibm.security.util.PropertyExpander;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.ProviderException;
import sun.security.jca.Providers;
import sun.security.util.Debug;

final class ProviderConfig {
    private static final Debug debug = Debug.getInstance("jca", "ProviderConfig");
    private static final String P11_SOL_NAME = "sun.security.pkcs11.SunPKCS11";
    private static final String P11_SOL_ARG = "${java.home}/lib/security/sunpkcs11-solaris.cfg";
    private static final int MAX_LOAD_TRIES = 30;
    private static final Class[] CL_STRING = new Class[]{String.class};
    private static volatile Object LOCK = new Lock();
    private final String className;
    private final String argument;
    private int tries;
    private volatile Provider provider;
    private boolean isLoading;

    private static Object getLock() {
        Object object = LOCK;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getLastClassLoader();
            }
        });
        if (t != null) {
            object = t;
        }
        return object;
    }

    ProviderConfig(String string, String string2) {
        if (string.equals(P11_SOL_NAME) && string2.equals(P11_SOL_ARG)) {
            this.checkSunPKCS11Solaris();
        }
        this.className = string;
        this.argument = ProviderConfig.expand(string2);
    }

    ProviderConfig(String string) {
        this(string, "");
    }

    ProviderConfig(Provider provider) {
        this.className = provider.getClass().getName();
        this.argument = "";
        this.provider = provider;
    }

    private void checkSunPKCS11Solaris() {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = new File("/usr/lib/libpkcs11.so");
                if (!file.exists()) {
                    return Boolean.FALSE;
                }
                if ("false".equalsIgnoreCase(System.getProperty("sun.security.pkcs11.enable-solaris"))) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        if (t == Boolean.FALSE) {
            this.tries = 30;
        }
    }

    private boolean hasArgument() {
        return this.argument.length() != 0;
    }

    private boolean shouldLoad() {
        return this.tries < 30;
    }

    private void disableLoad() {
        this.tries = 30;
    }

    boolean isLoaded() {
        return this.provider != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProviderConfig)) {
            return false;
        }
        ProviderConfig providerConfig = (ProviderConfig)object;
        return this.className.equals(providerConfig.className) && this.argument.equals(providerConfig.argument);
    }

    public int hashCode() {
        return this.className.hashCode() + this.argument.hashCode();
    }

    public String toString() {
        if (this.hasArgument()) {
            return this.className + "('" + this.argument + "')";
        }
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Provider getProvider() {
        Provider provider = this.provider;
        if (provider != null) {
            return provider;
        }
        if (!this.shouldLoad()) {
            return null;
        }
        Object object = ProviderConfig.getLock();
        synchronized (object) {
            provider = this.provider;
            if (provider != null) {
                return provider;
            }
            if (this.isLoading) {
                if (debug != null) {
                    debug.println("Recursion loading provider: " + this);
                    new Exception("Call trace").printStackTrace();
                }
                return null;
            }
            try {
                this.isLoading = true;
                ++this.tries;
                provider = this.doLoadProvider();
            }
            finally {
                this.isLoading = false;
            }
            this.provider = provider;
        }
        return provider;
    }

    private Provider doLoadProvider() {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object t;
                Serializable serializable;
                if (debug != null) {
                    debug.println("Loading provider: " + ProviderConfig.this);
                }
                Object object = null;
                try {
                    Object object2;
                    object = Providers.startLoadProvider();
                    java.lang.ClassLoader classLoader = ClassLoader.getLastClassLoader();
                    serializable = classLoader != null ? classLoader.loadClass(ProviderConfig.this.className) : Class.forName(ProviderConfig.this.className);
                    if (!ProviderConfig.this.hasArgument()) {
                        t = ((Class)serializable).newInstance();
                    } else {
                        object2 = ((Class)serializable).getConstructor(CL_STRING);
                        t = ((Constructor)object2).newInstance(ProviderConfig.this.argument);
                    }
                    if (t instanceof Provider) {
                        if (debug != null) {
                            debug.println("Loaded provider " + t);
                        }
                        object2 = (Provider)t;
                        return object2;
                    }
                    if (debug != null) {
                        debug.println(ProviderConfig.this.className + " is not a provider");
                    }
                    ProviderConfig.this.disableLoad();
                    object2 = null;
                    return object2;
                }
                catch (Exception exception) {
                    serializable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getCause() : exception;
                    if (debug != null) {
                        debug.println("Error loading provider " + ProviderConfig.this);
                        ((Throwable)serializable).printStackTrace();
                    }
                    if (serializable instanceof ProviderException) {
                        throw (ProviderException)serializable;
                    }
                    if (serializable instanceof UnsupportedOperationException) {
                        ProviderConfig.this.disableLoad();
                    }
                    t = null;
                    return t;
                }
                finally {
                    Providers.stopLoadProvider(object);
                }
            }
        });
        return (Provider)t;
    }

    private static String expand(final String string) {
        if (!string.contains("${")) {
            return string;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return PropertyExpander.expand(string);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException(generalSecurityException);
                }
            }
        });
        return (String)t;
    }

    private static class Lock {
        private Lock() {
        }
    }
}

