/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;

abstract class CramMD5Base {
    protected boolean completed = false;
    protected boolean aborted = false;
    protected byte[] pw;
    private static final int MD5_BLOCKSIZE = 64;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static Logger logger;

    protected CramMD5Base() {
        CramMD5Base.initLogger();
    }

    public String getMechanismName() {
        return "CRAM-MD5";
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("CRAM-MD5 authentication not completed");
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    protected void clearPassword() {
        if (this.pw != null) {
            for (int i = 0; i < this.pw.length; ++i) {
                this.pw[i] = 0;
            }
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    static final String HMAC_MD5(byte[] key, byte[] text) throws NoSuchAlgorithmException {
        int i;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        if (key.length > 64) {
            key = md5.digest(key);
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            while (i < key.length) {
                ipad[i] = key[i];
                opad[i] = key[i];
                ++i;
            }
            ipad[i] = 0;
            opad[i] = 0;
        }
        i = 0;
        while (i < 64) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ 0x36);
            int n2 = i++;
            opad[n2] = (byte)(opad[n2] ^ 0x5C);
        }
        md5.update(ipad);
        md5.update(text);
        byte[] digest = md5.digest();
        md5.update(opad);
        md5.update(digest);
        digest = md5.digest();
        StringBuffer digestString = new StringBuffer();
        for (i = 0; i < digest.length; ++i) {
            if ((digest[i] & 0xFF) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 0xFF));
                continue;
            }
            digestString.append(Integer.toHexString(digest[i] & 0xFF));
        }
        return digestString.toString();
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }
}

