/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.config;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.util.SmudgedBytes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ConfigImpl
extends Config {
    private static final String WINCONFFILE;
    private static final String IXCONFFILE;
    private static KMSDebug debug;
    private static String className;
    private static ConfigImpl configInstance;
    private static Hashtable configInMemory;
    private static Properties p;
    private static FileInputStream fis;
    private static FileOutputStream fos;
    private static String configFile;
    private static String[] z;

    public void init() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[1], className, z[14]);
        String string = System.getProperty(z[19]);
        debug.trace(z[1], className, z[14], string);
        if (string.toUpperCase().indexOf(z[18]) != -1) {
            debug.trace(z[1], className, z[14], z[21]);
            ConfigImpl.load(WINCONFFILE);
        } else if (string.toUpperCase().indexOf("X") != -1) {
            debug.trace(z[1], className, z[14], string + z[20]);
            ConfigImpl.load(IXCONFFILE);
        } else {
            debug.trace(z[1], className, z[14], string + z[20]);
            ConfigImpl.load(IXCONFFILE);
        }
        debug.exit(z[1], className, z[14]);
    }

    public void init(String string) throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[1], className, z[14]);
        if (string != null) {
            ConfigImpl.load(string);
        } else {
            this.init();
        }
        debug.exit(z[1], className, z[14]);
    }

    public static void load(String string) throws KeyManagerException {
        debug.entry(z[1], className, z[22]);
        String string2 = null;
        if (string == null) {
            String string3 = System.getProperty(z[19]);
            if (string3.toUpperCase().indexOf(z[18]) != -1) {
                string2 = WINCONFFILE;
                debug.trace(z[1], className, z[14], z[21]);
            } else if (string3.toUpperCase().indexOf("X") != -1) {
                string2 = IXCONFFILE;
                debug.trace(z[1], className, z[14], string3 + z[20]);
            }
            configFile = string2;
        } else {
            configFile = string;
        }
        try {
            debug.trace(z[1], className, z[22], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        ConfigImpl.buildConfig(p);
        debug.exit(z[1], className, z[22]);
    }

    public void add(String string, Object object) throws KeyManagerException {
        debug.entry(z[1], className, z[32]);
        try {
            if (string.toLowerCase().indexOf(z[6]) == 0) {
                debug.trace(z[1], className, z[32], string + z[5] + object);
            }
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[1], className, z[32]);
    }

    public void delete(String string) throws KeyManagerException {
        debug.entry(z[1], className, z[33]);
        try {
            if (string.toLowerCase().indexOf(z[6]) == 0) {
                debug.trace(z[1], className, z[33], string);
            }
            configInMemory.remove(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[1], className, z[33]);
    }

    public void replace(String string, Object object) throws KeyManagerException {
        debug.entry(z[1], className, z[16]);
        try {
            if (string.toLowerCase().indexOf(z[6]) == 0) {
                debug.trace(z[1], className, z[16], string + z[5] + object);
                debug.trace(z[1], className, z[16], string + z[15] + configInMemory.get(string));
            }
            configInMemory.remove(string);
            configInMemory.put(string, object);
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[1], className, z[16]);
    }

    public void reload() throws KeyManagerException {
        debug.entry(z[1], className, z[30]);
        try {
            debug.trace(z[1], className, z[30], configFile);
            fis = new FileInputStream(configFile);
            p.clear();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        configInMemory.clear();
        ConfigImpl.buildConfig(p);
        debug.exit(z[1], className, z[30]);
    }

    public Hashtable get() {
        debug.entry(z[1], className, z[27]);
        Hashtable hashtable = new Hashtable(configInMemory.size());
        Enumeration enumeration = configInMemory.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable.put(k2, configInMemory.get(k2));
        }
        debug.exit(z[1], className, z[27]);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String string) throws KeyManagerException {
        debug.entry(z[1], className, z[27]);
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            if (string.equals(z[25])) {
                String string2 = (String)configInMemory.get(z[23]);
                if (string2 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string2);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[28])) {
                String string3 = (String)configInMemory.get(z[26]);
                if (string3 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string3);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            if (string.equals(z[24])) {
                String string4 = (String)configInMemory.get(z[29]);
                if (string4 == null) {
                    return null;
                }
                byte[] byArray = Logic.hexStringToByteArray(string4);
                return SmudgedBytes.getClearTextPWstring(byArray);
            }
            var2_2 = configInMemory.get(string);
            if (string.toLowerCase().indexOf(z[6]) == -1) {
                debug.trace(z[1], className, z[27], string + z[5] + var2_2);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new KeyManagerException(nullPointerException);
        }
        debug.exit(z[1], className, z[27]);
        if (!(var2_2 instanceof String)) return var2_2;
        return ((String)var2_2).trim();
    }

    public void shutdown() throws KeyManagerException {
        debug.entry(z[1], className, z[31]);
        this.sync();
        debug.exit(z[1], className, z[31]);
    }

    public void sync() throws KeyManagerException {
        debug = KMSDebug.getInstance();
        debug.entry(z[1], className, z[0]);
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[1], className, z[0]);
    }

    public void sync(Hashtable hashtable) throws KeyManagerException {
        debug.entry(z[1], className, z[0]);
        configInMemory.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            configInMemory.put(k2, hashtable.get(k2));
        }
        try {
            ConfigImpl.write();
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception.getMessage());
        }
        debug.exit(z[1], className, z[0]);
    }

    private static void buildConfig(Properties properties) {
        debug.entry(z[1], className, z[17]);
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = p.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                if (string.toLowerCase().indexOf(z[6]) == 0) {
                    debug.trace(z[1], className, z[17], z[11] + string + z[10] + string2);
                }
                configInMemory.put(string, string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            if (string.toLowerCase().indexOf(z[6]) == 0) {
                debug.trace(z[1], className, z[17], z[13] + string);
            }
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[1], className, z[17]);
    }

    private static void mergeConfig(Properties properties) {
        debug.entry(z[1], className, z[12]);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            string2 = properties.getProperty(string);
            int n2 = string2.toString().length();
            if (n2 >= 1) {
                configInMemory.put(string, string2);
                if (string.toLowerCase().indexOf(z[6]) != 0) continue;
                debug.trace(z[1], className, z[12], z[11] + string + z[10] + string2);
                continue;
            }
            if (configInMemory.get(string) != null) continue;
            debug.trace(z[1], className, z[12], z[13] + string);
            configInMemory.put(string, p.getProperty(string));
        }
        debug.exit(z[1], className, z[12]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void write() throws Exception {
        String string = configFile;
        debug.entry(z[1], className, z[3]);
        String string2 = configFile;
        synchronized (string2) {
            File file;
            debug.trace(z[1], className, z[3], string);
            File file2 = new File(string);
            File file3 = new File(string + z[4]);
            if (!file3.exists()) {
                try {
                    file3.createNewFile();
                }
                catch (IOException iOException) {
                    file = file3.getAbsoluteFile().getParentFile();
                    if (!file.exists()) {
                        if (!file.mkdirs()) {
                            throw new KeyManagerException(z[8] + string + z[7]);
                        }
                    } else {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException);
                    }
                    try {
                        file3.createNewFile();
                    }
                    catch (IOException iOException2) {
                        throw (KeyManagerException)new KeyManagerException().initCause(iOException2);
                    }
                }
            }
            fos = new FileOutputStream(file3);
            Enumeration enumeration = configInMemory.keys();
            file = null;
            while (enumeration.hasMoreElements()) {
                file = enumeration.nextElement();
                String string3 = file + z[5] + configInMemory.get(file) + "\n";
                if (string3.toLowerCase().indexOf(z[6]) == 0) {
                    debug.trace(z[1], className, z[3], "" + string3);
                }
                if (configInMemory.get(file) == null) continue;
                fos.write(string3.getBytes());
                fos.flush();
            }
            fos.close();
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
        }
        debug.exit(z[1], className, z[3]);
    }

    public void write(String string) throws KeyManagerException {
        debug.entry(z[1], className, z[3]);
        try {
            String string2 = configFile;
            configFile = string;
            ConfigImpl.write();
            configFile = string2;
        }
        catch (Exception exception) {
            throw new KeyManagerException(exception);
        }
        debug.exit(z[1], className, z[3]);
    }

    public void merge(File file) throws KeyManagerException {
        Hashtable hashtable = new Hashtable(25);
        debug.entry(z[1], className, z[2]);
        if (file == null) {
            return;
        }
        try {
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.mergeConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[1], className, z[2]);
    }

    public void load(File file) throws KeyManagerException {
        debug.entry(z[1], className, z[22]);
        if (file == null) {
            return;
        }
        try {
            debug.trace(z[1], className, z[22], file.getName());
            p = new Properties();
            fis = new FileInputStream(file);
            p.load(fis);
            ConfigImpl.buildConfig(p);
            fis.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(iOException);
        }
        debug.exit(z[1], className, z[22]);
    }

    public Enumeration list() {
        debug.entry(z[1], className, z[9]);
        debug.exit(z[1], className, z[9]);
        return configInMemory.keys();
    }

    static {
        String[] stringArray = new String[34];
        Object var0 = null;
        IXCONFFILE = ConfigImpl.z(ConfigImpl.z("-.wMbk#j\u0016\u0006g8JX#c&bK\u001eg3q\\?-\nb@\u0000c/f^(p\u0002hW+k&)I?m1bK9k$t"));
        var0 = null;
        WINCONFFILE = ConfigImpl.z(ConfigImpl.z("A{(i?m&uX \"\u0007nU(qnN{\u0000-\nb@\u0000c/f^(p\u0012bK;g3(r({\ffW,e$uz\"l'n^cr3hI(p5n\\>"));
        var0 = null;
        stringArray[0] = ConfigImpl.z(ConfigImpl.z("q8iZ"));
        var0 = null;
        stringArray[1] = ConfigImpl.z(ConfigImpl.z("a.i_$e"));
        var0 = null;
        stringArray[2] = ConfigImpl.z(ConfigImpl.z("o$u^("));
        var0 = null;
        stringArray[3] = ConfigImpl.z(ConfigImpl.z("u3nM("));
        var0 = null;
        stringArray[4] = ConfigImpl.z(ConfigImpl.z(",#fZ&w1"));
        var0 = null;
        stringArray[5] = ConfigImpl.z(ConfigImpl.z("\"|'"));
        var0 = null;
        stringArray[6] = ConfigImpl.z(ConfigImpl.z("r tJ:m3c"));
        var0 = null;
        stringArray[7] = ConfigImpl.z(ConfigImpl.z("\"\"fWml.s\u0019/gadK(c5b]"));
        var0 = null;
        stringArray[8] = ConfigImpl.z(ConfigImpl.z("A.i_$e4uX9k.i\u0019\u000bk-b\u0019"));
        var0 = null;
        stringArray[9] = ConfigImpl.z(ConfigImpl.z("n(tM"));
        var0 = null;
        stringArray[10] = ConfigImpl.z(ConfigImpl.z("\"5h\u0019"));
        var0 = null;
        stringArray[11] = ConfigImpl.z(ConfigImpl.z("w1cX9k/`\u0019"));
        var0 = null;
        stringArray[12] = ConfigImpl.z(ConfigImpl.z("o$u^(A.i_$e"));
        var0 = null;
        stringArray[13] = ConfigImpl.z(ConfigImpl.z("T\u0000Kl\b\"\u000fRu\u00018a"));
        var0 = null;
        stringArray[14] = ConfigImpl.z(ConfigImpl.z("k/nM"));
        var0 = null;
        stringArray[15] = ConfigImpl.z(ConfigImpl.z("\"\u0016Fjm"));
        var0 = null;
        stringArray[16] = ConfigImpl.z(ConfigImpl.z("p$wU,a$"));
        var0 = null;
        stringArray[17] = ConfigImpl.z(ConfigImpl.z("`4nU)A.i_$e"));
        var0 = null;
        stringArray[18] = ConfigImpl.z(ConfigImpl.z("U\bI"));
        var0 = null;
        stringArray[19] = ConfigImpl.z(ConfigImpl.z("m2)W,o$"));
        var0 = null;
        stringArray[20] = ConfigImpl.z(ConfigImpl.z("\"\bS\u0019\u0004Q`"));
        var0 = null;
        stringArray[21] = ConfigImpl.z(ConfigImpl.z("U\bI}\u0002U\u0012'p\u0019\"\bT\u0018"));
        var0 = null;
        stringArray[22] = ConfigImpl.z(ConfigImpl.z("n.f]"));
        var0 = null;
        stringArray[23] = ConfigImpl.z(ConfigImpl.z("a.i_$eol\\4q5hK(,1fJ>u.u]cm#aL>a s\\)"));
        var0 = null;
        stringArray[24] = ConfigImpl.z(ConfigImpl.z("V3fW>r.uM\u0001k2s\\#g3)J>nol\\4q5hK(,1fJ>u.u]"));
        var0 = null;
        stringArray[25] = ConfigImpl.z(ConfigImpl.z("a.i_$eol\\4q5hK(,1fJ>u.u]"));
        var0 = null;
        stringArray[26] = ConfigImpl.z(ConfigImpl.z("C%jP#,2tUci$~J9m3b\u0017=c2tN\"p%)V/d4tZ,v$c"));
        var0 = null;
        stringArray[27] = ConfigImpl.z(ConfigImpl.z("e$s"));
        var0 = null;
        stringArray[28] = ConfigImpl.z(ConfigImpl.z("C%jP#,2tUci$~J9m3b\u0017=c2tN\"p%"));
        var0 = null;
        stringArray[29] = ConfigImpl.z(ConfigImpl.z("V3fW>r.uM\u0001k2s\\#g3)J>nol\\4q5hK(,1fJ>u.u]cm#aL>a s\\)"));
        var0 = null;
        stringArray[30] = ConfigImpl.z(ConfigImpl.z("p$kV,f"));
        var0 = null;
        stringArray[31] = ConfigImpl.z(ConfigImpl.z("q)rM)m6i"));
        var0 = null;
        stringArray[32] = ConfigImpl.z(ConfigImpl.z("c%c"));
        var0 = null;
        stringArray[33] = ConfigImpl.z(ConfigImpl.z("f$k\\9g"));
        z = stringArray;
        debug = null;
        var0 = null;
        className = ConfigImpl.z(ConfigImpl.z("a.j\u0017$`,)R({,fW*g3)Z\"l'n^cA.i_$e\bjI!"));
        configInstance = new ConfigImpl();
        configInMemory = new Hashtable(25);
        p = new Properties();
        fis = null;
        fos = null;
        configFile = null;
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x4D);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 2;
                            break;
                        }
                        case 1: {
                            n7 = 65;
                            break;
                        }
                        case 2: {
                            n7 = 7;
                            break;
                        }
                        case 3: {
                            n7 = 57;
                            break;
                        }
                        default: {
                            n7 = 77;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

