/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DeprecatedCoreAPI;
import com.ibm.dtfj.corereaders.Dump;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.jvm.j9.dump.extract.JExtractFatalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private String _dumpName = null;
    private File _virtualRootDirectory = null;
    private boolean _verbose;
    private static boolean _throwExceptions;
    private ICoreFileReader _dump = null;
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private static int JEXTRACT_SUCCESS;
    private static int JEXTRACT_SYNTAX_ERROR;
    private static int JEXTRACT_FILE_ERROR;
    private static int JEXTRACT_NOJVM_ERROR;
    private static int JEXTRACT_ADDRESS_ERROR;
    private static int JEXTRACT_VERSION_ERROR;
    private static int JEXTRACT_INTERNAL_ERROR;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        if (stringArray.length == 0) {
            Main.usageMessage(null, JEXTRACT_SUCCESS);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!bl && stringArray[i].startsWith("-")) {
                File file2;
                if ("--".equals(stringArray[i])) {
                    bl = true;
                    continue;
                }
                if ("-interactive".equals(stringArray[i])) {
                    bl2 = true;
                    continue;
                }
                if ("-help".equals(stringArray[i])) {
                    Main.usageMessage(null, JEXTRACT_SUCCESS);
                    continue;
                }
                if ("-nozip".equals(stringArray[i]) || "-nojar".equals(stringArray[i])) {
                    bl5 = false;
                    continue;
                }
                if ("-f".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -f option specified but no file following");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead(), "File specified using -f option (\"" + stringArray[i] + "\") not found.");
                    continue;
                }
                if ("-p".equals(stringArray[i])) {
                    Main.ensure(++i < stringArray.length && !stringArray[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    file2 = new File(stringArray[i]);
                    Main.ensure(file2.exists() && file2.canRead() && file2.isDirectory(), "Virtual directory specified using -p option (\"" + stringArray[i] + "\") does not exist as a readable directory.");
                    file = new File(stringArray[i]);
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-e")) {
                    bl4 = true;
                    continue;
                }
                Main.usageMessage("Unrecognized option: " + stringArray[i], JEXTRACT_SYNTAX_ERROR);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            Main.usageMessage("Too many file arguments: " + stringArray[i], JEXTRACT_SYNTAX_ERROR);
        }
        Main.ensure(null != string, "No dump file specified");
        Main main = new Main(string, file, bl3, bl4);
        if (bl2) {
            main.runInteractive();
        } else {
            main.runJextract(string2, bl5);
        }
    }

    private static void ensure(boolean bl, String string) {
        if (!bl) {
            Main.usageMessage(string, JEXTRACT_SYNTAX_ERROR);
        }
    }

    private static void usageMessage(String string, int n) {
        Main.report("Usage: jextract dump_name [output_filename] [options]");
        Main.report(" output filename defaults to dump_name.zip");
        Main.report("    or dump_name.xml if -nozip option specified");
        Main.report(" options:");
        Main.report("   -help         print this usage message");
        Main.report("   -nozip        don't create a zip");
        Main.report("   -v            enable verbose output");
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private static void errorMessage(String string, int n) {
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private static void errorMessage(String string, int n, Throwable throwable) {
        throwable.printStackTrace();
        if (_throwExceptions) {
            throw new JExtractFatalException(string, n);
        }
        if (string != null) {
            Main.report(string);
        }
        System.exit(n);
    }

    private Main(String string, File file, boolean bl, boolean bl2) {
        this._dumpName = string;
        this._virtualRootDirectory = file;
        this._verbose = bl;
        _throwExceptions = bl2;
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException securityException) {
            Main.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Main.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (Exception exception) {
            Main.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JEXTRACT_INTERNAL_ERROR, exception);
        }
        Main.report("Loading dump file...");
        File file2 = new File(string);
        try {
            ClosingFileReader closingFileReader = new ClosingFileReader(file2);
            this._dump = DumpFactory.createDumpForCore(closingFileReader, this._verbose);
            if (this._dump.isTruncated()) {
                Main.report("Warning: dump file is truncated. Extracted information may be incomplete.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!file2.exists()) {
                Main.errorMessage("Error. Could not find dump file: " + string, JEXTRACT_FILE_ERROR);
            } else if (!file2.canRead()) {
                Main.errorMessage("Error. Unable to read dump file (check permission): " + string, JEXTRACT_FILE_ERROR);
            } else {
                Main.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + string, JEXTRACT_FILE_ERROR, fileNotFoundException);
            }
        }
        catch (Exception exception) {
            Main.errorMessage("Error. Unexpected Exception occurred opening: " + string, JEXTRACT_FILE_ERROR, exception);
        }
        if (null == this._dump) {
            Main.errorMessage("Error. Dump type not recognised for dump: " + string, JEXTRACT_FILE_ERROR);
        }
        Main.report("Read memory image from " + this._dumpName);
    }

    private void runJextract(String string, boolean bl) {
        String string2;
        String string3;
        Object object;
        Object object2;
        String string4 = null;
        string4 = null != string && false == bl ? string : this._dumpName.concat(".xml");
        File file = new File(string4);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!file.canWrite()) {
            Main.errorMessage("Error. Unable to write to \"" + string4 + "\" (check permission)", JEXTRACT_FILE_ERROR);
        }
        DummyBuilder dummyBuilder = new DummyBuilder(this._virtualRootDirectory);
        this._dump.extract(dummyBuilder);
        try {
            object2 = this._dump.getAddressSpace();
            if (object2 == null) {
                file.delete();
                Main.errorMessage("Error. Address space not found in dump: " + this._dumpName + ". Dump is truncated, corrupted or does not contain a supported JVM.", JEXTRACT_NOJVM_ERROR);
            } else {
                this.doJextract((DeprecatedCoreAPI)object2, string4);
            }
        }
        catch (Throwable throwable) {
            object = throwable.getMessage();
            if (object != null) {
                if (this._verbose) {
                    Main.report((String)object);
                }
                if (((String)object).indexOf("JVM anchor block (J9VMRAS) not found in dump") >= 0) {
                    Main.errorMessage("Error. No known JVM found in dump", JEXTRACT_NOJVM_ERROR);
                } else if (((String)object).indexOf("J9RAS is out of range for a 32-bit pointer") >= 0) {
                    Main.errorMessage("Error. JVM out of address range, needs 64-bit jextract", JEXTRACT_ADDRESS_ERROR);
                } else if (((String)object).indexOf("J9RAS.version is incorrect") >= 0 || ((String)object).indexOf("J9RAS.length is incorrect") >= 0 || ((String)object).indexOf("J9RAS.buildID is incorrect") >= 0) {
                    string3 = System.getProperty("java.version");
                    string2 = System.getProperty("com.ibm.vm.bitmode");
                    if (string3 != null && string3.indexOf("1.6.0") >= 0 && string2 != null && string2.indexOf("64") >= 0) {
                        Main.errorMessage("Error. Incompatible JVM version found in dump\nnote: for 64-bit compressed reference JVMs use 'jextract -J-Xcompressedrefs <corefile>'", JEXTRACT_VERSION_ERROR);
                    } else {
                        Main.errorMessage("Error. Incompatible JVM version found in dump", JEXTRACT_VERSION_ERROR);
                    }
                } else {
                    Main.errorMessage("Error. Internal failure detected during jextract", JEXTRACT_INTERNAL_ERROR);
                }
            }
            Main.errorMessage("Error. Internal failure detected during jextract", JEXTRACT_INTERNAL_ERROR);
        }
        if (bl) {
            object2 = new ArrayList();
            object2.add(this._dumpName);
            object2.add(string4);
            object = this._dump.getAdditionalFileNames();
            while (object.hasNext()) {
                object2.add(object.next());
            }
            try {
                object = System.getProperty("java.home") + File.separator + "lib" + File.separator;
                string3 = (String)object + "TraceFormat.dat";
                if (new File(string3).exists()) {
                    object2.add(string3);
                }
                if (new File(string2 = (String)object + "J9TraceFormat.dat").exists()) {
                    object2.add(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Main.createZipFromFileNames(null != string ? string : this._dumpName.concat(".zip"), object2.iterator(), dummyBuilder);
            }
            catch (Exception exception) {
                Main.errorMessage(exception.getMessage(), JEXTRACT_INTERNAL_ERROR, exception);
            }
            file.deleteOnExit();
        }
        Main.report("jextract complete.");
    }

    private void runInteractive() {
        Main.report("Jextract interactive mode.");
        Main.report("Type '!j9help' for help.");
        Main.report("Type 'quit' to quit.");
        Main.report("(Commands must be prefixed with '!')");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block4: while (true) {
            try {
                while (true) {
                    Main.report("> ");
                    String string = bufferedReader.readLine().trim();
                    if ("quit".equalsIgnoreCase(string) || "q".equalsIgnoreCase(string)) break block4;
                    try {
                        this.doCommand(this._dump.getAddressSpace(), string);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        Main.report(throwable.getMessage());
                        Main.report("Failure detected during command execution, see previous message(s).");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Main.report("Error reading input.");
                break;
            }
        }
    }

    private static void report(String string) {
        System.err.println(string);
    }

    private static void createZipFromFileNames(String string, Iterator iterator, Builder builder) throws Exception {
        Main.report("Creating zip file: " + string);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            byte[] byArray = new byte[32768];
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    ClosingFileReader closingFileReader = builder.openFile(string2);
                    boolean bl = closingFileReader.isMVSFile();
                    String string3 = closingFileReader.getAbsolutePath();
                    if (string3.equals(new File(string2).getAbsolutePath()) || bl) {
                        Main.report("Adding \"" + string2 + "\" to zip");
                    } else {
                        Main.report("Adding \"" + string2 + "\" to zip (found at \"" + string3 + "\")");
                    }
                    if (bl) {
                        zipOutputStream.putNextEntry(new ZipEntry(string2));
                        Main.copy(closingFileReader, (OutputStream)zipOutputStream, byArray);
                        continue;
                    }
                    InputStream inputStream = closingFileReader.streamFromFile();
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipEntry.setTime(new File(string3).lastModified());
                    zipOutputStream.putNextEntry(zipEntry);
                    Main.copy(inputStream, (OutputStream)zipOutputStream, byArray);
                    inputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Main.report("Warning:  Could not find file \"" + string2 + "\" for inclusion in zip file.  This will limit the usefulness of the zip file.");
                }
                catch (IOException iOException) {
                    throw new Exception("Failure adding file to zip file (" + string2 + ") : " + iOException.getMessage());
                }
                finally {
                    zipOutputStream.closeEntry();
                }
            }
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                throw new Exception("Failure closing zip file (" + string + ") : " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Could not find zip file to output to: " + fileNotFoundException.getMessage());
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    private static void copy(ClosingFileReader closingFileReader, OutputStream outputStream, byte[] byArray) throws IOException {
        int n = closingFileReader.read(byArray);
        while (n != -1) {
            outputStream.write(byArray, 0, n);
            n = closingFileReader.read(byArray);
        }
    }

    private native void doJextract(DeprecatedCoreAPI var1, String var2) throws Exception;

    private native void doCommand(DeprecatedCoreAPI var1, String var2) throws Exception;

    static {
        JEXTRACT_SUCCESS = 0;
        JEXTRACT_SYNTAX_ERROR = 1;
        JEXTRACT_FILE_ERROR = 2;
        JEXTRACT_NOJVM_ERROR = 3;
        JEXTRACT_ADDRESS_ERROR = 4;
        JEXTRACT_VERSION_ERROR = 5;
        JEXTRACT_INTERNAL_ERROR = 6;
    }

    private static class DummyBuilder
    implements Builder {
        private File _virtualRootDirectory = null;
        private Vector _successfulSearchPaths = new Vector();

        public DummyBuilder(File file) {
            this._virtualRootDirectory = file;
            String string = System.getProperty("java.home") + File.separator + "bin";
            File file2 = new File(string);
            this._successfulSearchPaths.add(file2);
        }

        public Object buildProcess(Object object, String string, String string2, Properties properties, Object object2, Iterator iterator, Object object3, Iterator iterator2, int n) {
            return new Object();
        }

        public Object buildAddressSpace(String string, Dump dump, int n) {
            return new Object();
        }

        public Object buildRegister(String string, Number number) {
            return new Register(string, number.longValue());
        }

        public Object buildStackSection(Object object, long l, long l2) {
            return new Object();
        }

        public Object buildThread(String string, Iterator iterator, Iterator iterator2, Iterator iterator3, Properties properties, int n) {
            return new Object();
        }

        public Object buildModuleSection(Object object, String string, long l, long l2) {
            return new Object();
        }

        public Object buildModule(String string, Properties properties, Iterator iterator, Iterator iterator2, long l) {
            return new Object();
        }

        public long getEnvironmentAddress() {
            return 0L;
        }

        public long getValueOfNamedRegister(List list, String string) {
            for (Register register : list) {
                if (!string.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        public Object buildStackFrame(Object object, long l, long l2) {
            return new Object();
        }

        public ClosingFileReader openFile(String string) throws FileNotFoundException {
            File file;
            Object object;
            Object object2;
            File file2 = new File(string);
            if (null != this._virtualRootDirectory && file2.isAbsolute()) {
                file2 = this.sysFileRelative(this._virtualRootDirectory, file2);
            } else if (!file2.isAbsolute() && !file2.exists()) {
                object2 = this._successfulSearchPaths.iterator();
                object = file2.getName();
                while (object2.hasNext()) {
                    file = (File)object2.next();
                    File file3 = new File(file, (String)object);
                    if (!file3.exists()) continue;
                    ClosingFileReader closingFileReader = new ClosingFileReader(file3);
                    return closingFileReader;
                }
            }
            if (file2.exists()) {
                object2 = new ClosingFileReader(file2);
                object = file2.getParentFile();
                if (null != object && !this._successfulSearchPaths.contains(file = ((File)object).getAbsoluteFile())) {
                    this._successfulSearchPaths.add(file);
                }
                return object2;
            }
            object2 = new ClosingFileReader(file2);
            return object2;
        }

        private File sysFileRelative(File file, File file2) {
            File file3 = file2;
            while (null != file3.getParentFile()) {
                file3 = file3.getParentFile();
            }
            File file4 = file2;
            if (file2.isAbsolute()) {
                String string = file2.getAbsolutePath().substring(file3.getAbsolutePath().length());
                file4 = new File(file, string);
            }
            return file4;
        }

        public Object buildSymbol(Object object, String string, long l) {
            return new Object();
        }

        public void setExecutableUnavailable(String string) {
        }

        public Object buildAddressSpace(String string, int n) {
            return new Object();
        }

        public void setOSType(String string) {
        }

        public void setCPUType(String string) {
        }

        public void setCPUSubType(String string) {
        }

        public void setCreationTime(long l) {
        }

        public Object buildCorruptData(Object object, String string, long l) {
            return new Object();
        }

        private static class Register {
            final String name;
            final long value;

            Register(String string, long l) {
                this.name = string;
                this.value = l;
            }
        }
    }
}

