/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaHeap
implements com.ibm.dtfj.java.JavaHeap {
    private JavaRuntime _javaVM;
    private String _name;
    private ImagePointer _id;
    private long _size;
    private HeapSubRegionSection[] _allSortedRegionSections;
    private List _heapRegions;
    private int _arrayletIdOffset;
    private int _arrayletIdWidth;
    private long _arrayletIdMask;
    private long _arrayletIdResult;
    private int _fobjectSize;
    private int _fobjectPointerScale;
    private long _fobjectPointerDisplacement;
    private int _classOffset;
    private int _classSize;
    private static RegionMatcher _matcher = new RegionMatcher();

    public JavaHeap(JavaRuntime javaRuntime, String string, ImagePointer imagePointer, ImagePointer imagePointer2, long l, int n, int n2, long l2, long l3, int n3, int n4, long l4, int n5, int n6) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a heap cannot be null");
        }
        if (null == string) {
            throw new IllegalArgumentException("JavaHeap name cannot be null");
        }
        this._javaVM = javaRuntime;
        this._id = imagePointer;
        this._name = string;
        this._size = l;
        this._arrayletIdOffset = n;
        this._arrayletIdWidth = n2;
        this._arrayletIdMask = l2;
        this._arrayletIdResult = l3;
        this._fobjectSize = n3;
        this._fobjectPointerScale = n4;
        this._fobjectPointerDisplacement = l4;
        this._classOffset = n5;
        this._classSize = n6;
    }

    public Iterator getSections() {
        return new MultiLevelSectionIterator(this._heapRegions);
    }

    public String getName() {
        return this._name + "@" + this._id;
    }

    public Iterator getObjects() {
        return new MultiLevelExtentWalker(this._heapRegions);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (null != this._name && object instanceof JavaHeap) {
            JavaHeap javaHeap = (JavaHeap)object;
            bl = this._javaVM.equals(javaHeap._javaVM) && this._name.equals(javaHeap._name) && this._id.equals(javaHeap._id) && this._size == javaHeap._size;
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._name.hashCode() ^ this._id.hashCode() ^ (int)this._size;
    }

    public JavaHeapRegion regionForPointer(ImagePointer imagePointer) {
        JavaHeapRegion javaHeapRegion = null;
        int n = Arrays.binarySearch(this._allSortedRegionSections, imagePointer, _matcher);
        if (n >= 0 && n < this._allSortedRegionSections.length) {
            javaHeapRegion = this._allSortedRegionSections[n].getRegion();
        }
        return javaHeapRegion;
    }

    public int getArrayletIdentificationWidth() {
        return this._arrayletIdWidth;
    }

    public int getArrayletIdentificationOffset() {
        return this._arrayletIdOffset;
    }

    public long getArrayletIdentificationBitmask() {
        return this._arrayletIdMask;
    }

    public long getArrayletIdentificationResult() {
        return this._arrayletIdResult;
    }

    public void setRegions(Vector vector) {
        this._heapRegions = vector;
        Iterator iterator = vector.iterator();
        Vector<HeapSubRegionSection> vector2 = new Vector<HeapSubRegionSection>();
        while (iterator.hasNext()) {
            JavaHeapRegion javaHeapRegion = (JavaHeapRegion)iterator.next();
            Iterator iterator2 = javaHeapRegion.getSections();
            while (iterator2.hasNext()) {
                ImageSection imageSection = (ImageSection)iterator2.next();
                vector2.add(new HeapSubRegionSection(javaHeapRegion, imageSection));
            }
        }
        this._allSortedRegionSections = vector2.toArray(new HeapSubRegionSection[vector2.size()]);
        Arrays.sort(this._allSortedRegionSections, new Comparator(){

            public int compare(Object object, Object object2) {
                HeapSubRegionSection heapSubRegionSection = (HeapSubRegionSection)object;
                HeapSubRegionSection heapSubRegionSection2 = (HeapSubRegionSection)object2;
                long l = heapSubRegionSection.base() - heapSubRegionSection2.base();
                int n = 0;
                if (l < 0L) {
                    n = -1;
                } else if (l > 0L) {
                    n = 1;
                }
                return n;
            }
        });
    }

    public int getFObjectSize() {
        return this._fobjectSize;
    }

    public long tokenToPointer(long l) {
        return l * (long)this._fobjectPointerScale + this._fobjectPointerDisplacement;
    }

    public ImagePointer readClassPointerRelativeTo(ImagePointer imagePointer) throws MemoryAccessException, CorruptDataException {
        long l;
        if (8 == this._classSize) {
            l = imagePointer.getLongAt((long)this._classOffset);
        } else if (4 == this._classSize) {
            l = 0xFFFFFFFFL & (long)imagePointer.getIntAt((long)this._classOffset);
        } else {
            throw new IllegalArgumentException("Heap has unexpected class pointer size: " + this._classSize);
        }
        return this._id.getAddressSpace().getPointer(l);
    }

    public ImagePointer readFObjectAt(ImagePointer imagePointer, long l) throws MemoryAccessException, CorruptDataException {
        long l2;
        if (8 == this._fobjectSize) {
            l2 = this.tokenToPointer(imagePointer.getLongAt(l));
        } else if (4 == this._fobjectSize) {
            l2 = this.tokenToPointer(0xFFFFFFFFL & (long)imagePointer.getIntAt(l));
        } else {
            throw new IllegalArgumentException("Heap has unexpected size reference fields: " + this._fobjectSize);
        }
        return this._id.getAddressSpace().getPointer(l2);
    }

    private class HeapSubRegionSection {
        private JavaHeapRegion _region;
        private ImageSection _section;

        private HeapSubRegionSection(JavaHeapRegion javaHeapRegion, ImageSection imageSection) {
            this._region = javaHeapRegion;
            this._section = imageSection;
        }

        public ImageSection getSection() {
            return this._section;
        }

        public JavaHeapRegion getRegion() {
            return this._region;
        }

        private long base() {
            return this._section.getBaseAddress().getAddress();
        }
    }

    private static class RegionMatcher
    implements Comparator {
        private RegionMatcher() {
        }

        public int compare(Object object, Object object2) {
            HeapSubRegionSection heapSubRegionSection = (HeapSubRegionSection)object;
            ImagePointer imagePointer = (ImagePointer)object2;
            int n = -1;
            ImageSection imageSection = heapSubRegionSection.getSection();
            long l = imageSection.getBaseAddress().getAddress();
            long l2 = imagePointer.getAddress() - l;
            n = l2 < 0L ? 1 : (l2 < imageSection.getSize() ? 0 : -1);
            return n;
        }
    }

    private class MultiLevelExtentWalker
    implements Iterator {
        private Iterator _outer;
        private Iterator _inner;

        public MultiLevelExtentWalker(List list) {
            this._outer = list.iterator();
        }

        public boolean hasNext() {
            this._refreshInner();
            return this._inner.hasNext();
        }

        public Object next() {
            this._refreshInner();
            return this._inner.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("The core-resident Java heap is immutable");
        }

        private void _refreshInner() {
            if (null == this._inner || !this._inner.hasNext()) {
                if (this._outer.hasNext()) {
                    do {
                        this._inner = ((JavaHeapRegion)this._outer.next()).getObjects();
                    } while (!this._inner.hasNext() && this._outer.hasNext());
                } else {
                    this._inner = this._outer;
                }
            }
        }
    }

    private class MultiLevelSectionIterator
    implements Iterator {
        private Iterator _outer;
        private Iterator _inner;

        public MultiLevelSectionIterator(List list) {
            this._outer = list.iterator();
        }

        public boolean hasNext() {
            this._refreshInner();
            return this._inner.hasNext();
        }

        public Object next() {
            this._refreshInner();
            return this._inner.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("The core-resident Java heap is immutable");
        }

        private void _refreshInner() {
            if (null == this._inner || !this._inner.hasNext()) {
                this._inner = this._outer.hasNext() ? ((JavaHeapRegion)this._outer.next()).getSections() : this._outer;
            }
        }
    }
}

