/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaClassLoader
implements com.ibm.dtfj.java.JavaClassLoader {
    private JavaRuntime _javaVM;
    private ImagePointer _id;
    private ImagePointer _objectID;
    private List _classIDs = new ArrayList();
    private JavaObject _object = null;
    private List _defined = null;
    private List _cached = null;

    public JavaClassLoader(JavaRuntime javaRuntime, ImagePointer imagePointer, ImagePointer imagePointer2) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for class loader must not be null");
        }
        if (null == imagePointer) {
            throw new IllegalArgumentException("Class loader id must not be null");
        }
        this._javaVM = javaRuntime;
        this._id = imagePointer;
        this._objectID = imagePointer2;
    }

    public Iterator getDefinedClasses() {
        if (null == this._defined) {
            Iterator iterator = this._javaVM.getClasses();
            long l = this._id.getAddress();
            this._defined = new ArrayList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) continue;
                JavaClass javaClass = (JavaClass)e;
                try {
                    JavaClassLoader javaClassLoader = (JavaClassLoader)javaClass.getClassLoader();
                    if (javaClassLoader == null || javaClassLoader._id.getAddress() != l) continue;
                    this._defined.add(javaClass);
                }
                catch (CorruptDataException corruptDataException) {}
            }
        }
        return this._defined.iterator();
    }

    public Iterator getCachedClasses() {
        if (null == this._cached) {
            Iterator iterator = this._classIDs.iterator();
            this._cached = new ArrayList();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                JavaClass javaClass = this._javaVM.getClassForID(l);
                if (null == javaClass) {
                    this._cached.add(new CorruptData("Cache reference to unknown class " + l, null));
                    continue;
                }
                this._cached.add(javaClass);
            }
        }
        return this._cached.iterator();
    }

    public JavaClass findClass(String string) throws CorruptDataException {
        Iterator iterator = this.getDefinedClasses();
        JavaClass javaClass = null;
        while (iterator.hasNext() && null == javaClass) {
            JavaClass javaClass2 = (JavaClass)iterator.next();
            if (!javaClass2.getName().equals(string)) continue;
            javaClass = javaClass2;
        }
        return javaClass;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (null == this._object) {
            this._object = this._javaVM.getObjectAtAddress(this._objectID);
        }
        return this._object;
    }

    public long getID() {
        return this._id.getAddress();
    }

    public void addClassID(long l) {
        this._classIDs.add(new Long(l));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaClassLoader) {
            JavaClassLoader javaClassLoader = (JavaClassLoader)object;
            bl = this._javaVM.equals(javaClassLoader._javaVM) && this._id.equals(javaClassLoader._id);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._id.hashCode();
    }
}

