/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageSymbol;
import java.util.Iterator;

public class ImageStackFrame
implements com.ibm.dtfj.image.ImageStackFrame {
    private ImageAddressSpace _space;
    private String _procedureName = null;
    private ImagePointer _procedureAddress;
    private ImagePointer _basePointer;

    public ImageStackFrame(ImageAddressSpace imageAddressSpace, ImagePointer imagePointer, ImagePointer imagePointer2) {
        this._space = imageAddressSpace;
        this._procedureAddress = imagePointer;
        this._basePointer = imagePointer2;
    }

    public ImagePointer getProcedureAddress() throws CorruptDataException {
        return this._procedureAddress;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public String getProcedureName() throws CorruptDataException {
        if (null == this._procedureName) {
            Object object;
            Object e;
            Object object2 = null;
            Object object3 = null;
            long l = Long.MAX_VALUE;
            Iterator iterator = this._space.getProcesses();
            while (iterator.hasNext()) {
                Object object4;
                e = iterator.next();
                if (e instanceof CorruptData) continue;
                ImageProcess imageProcess = (ImageProcess)e;
                if (this._procedureAddress.getAddress() == (1L << imageProcess.getPointerSize()) - 1L) continue;
                try {
                    object4 = imageProcess.getExecutable();
                    object = this.getClosestSymbolFrom((ImageModule)object4);
                    long l2 = this.getDelta((ImageModule)object4, (ImageSymbol)object);
                    if (l2 >= 0L && l2 < l) {
                        object2 = object4;
                        object3 = object;
                        l = l2;
                    }
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                try {
                    object4 = imageProcess.getLibraries();
                    while (object4.hasNext()) {
                        ImageSymbol imageSymbol;
                        ImageModule imageModule;
                        long l3;
                        object = object4.next();
                        if (object instanceof CorruptData || (l3 = this.getDelta(imageModule = (ImageModule)object, imageSymbol = this.getClosestSymbolFrom(imageModule))) < 0L || l3 >= l) continue;
                        object2 = imageModule;
                        object3 = imageSymbol;
                        l = l3;
                    }
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (CorruptDataException corruptDataException) {
                }
            }
            iterator = object3;
            e = object2;
            long l4 = l;
            if (null != e) {
                object = "";
                object = l4 == Long.MAX_VALUE ? "<offset not available>" : (l4 >= 0L ? "+0x" + Long.toHexString(l4) : "-0x" + Long.toHexString(l4));
                this._procedureName = null != iterator ? e.getName() + "::" + ((ImageSymbol)((Object)iterator)).getName() + (String)object : e.getName() + (String)object;
            }
        }
        if (null == this._procedureName) {
            this._procedureName = "<unknown location>";
        }
        return this._procedureName;
    }

    private long getDelta(ImageModule imageModule, ImageSymbol imageSymbol) throws CorruptDataException {
        long l = 0L;
        if (imageSymbol != null) {
            l = this.getProcedureAddress().getAddress() - imageSymbol.getAddress().getAddress();
        } else {
            try {
                l = this.getProcedureAddress().getAddress() - ((com.ibm.dtfj.image.j9.ImageModule)imageModule).getLoadAddress();
            }
            catch (DataUnavailable dataUnavailable) {
                l = Long.MAX_VALUE;
            }
        }
        return l;
    }

    private ImageSymbol getClosestSymbolFrom(ImageModule imageModule) {
        long l = this._procedureAddress.getAddress();
        long l2 = Long.MAX_VALUE;
        ImageSymbol imageSymbol = null;
        Iterator iterator = imageModule.getSymbols();
        while (iterator.hasNext()) {
            ImageSymbol imageSymbol2;
            long l3;
            Object e = iterator.next();
            if (e instanceof CorruptData || (l3 = (imageSymbol2 = (ImageSymbol)e).getAddress().getAddress()) > l || l - l3 >= l2) continue;
            l2 = l - l3;
            imageSymbol = imageSymbol2;
        }
        return imageSymbol;
    }
}

