/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.j9.DefaultFileLocationResolver;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.ZipExtractionResolver;
import com.ibm.jvm.j9.dump.indexsupport.XMLIndexReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    public Image getImage(File file) throws IOException {
        Image image = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipExtractionResolver zipExtractionResolver = new ZipExtractionResolver(zipFile);
            File file2 = zipExtractionResolver.decompressCoreFile();
            InputStream inputStream = zipExtractionResolver.decompressMetaDataStream();
            image = this.getImage(file2, inputStream, zipExtractionResolver);
        }
        catch (ZipException zipException) {
            image = this.getImage(file, new File(file.toString() + ".xml"));
        }
        return image;
    }

    public Image getImage(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file2);
        Image image = this.getImage(file, fileInputStream, new DefaultFileLocationResolver(file.getParentFile()));
        fileInputStream.close();
        return image;
    }

    private Image getImage(File file, InputStream inputStream, IFileLocationResolver iFileLocationResolver) throws IOException {
        ClosingFileReader closingFileReader = new ClosingFileReader(file);
        ICoreFileReader iCoreFileReader = DumpFactory.createDumpForCore(closingFileReader);
        XMLIndexReader xMLIndexReader = new XMLIndexReader();
        return xMLIndexReader.parseIndexWithDump(inputStream, iCoreFileReader, closingFileReader, iFileLocationResolver);
    }

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 3;
    }

    public int getDTFJModificationLevel() {
        int n = 0;
        try {
            n = Integer.parseInt(com.ibm.dtfj.image.ImageFactory.class.getPackage().getImplementationVersion());
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }
}

