/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.dumpreader;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.SearchListener;
import com.ibm.dtfj.corereaders.zos.util.CharConversion;
import com.ibm.dtfj.corereaders.zos.util.Clib;
import com.ibm.dtfj.corereaders.zos.util.CompressedRecordArray;
import com.ibm.dtfj.corereaders.zos.util.ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class Dump
extends ImageInputStreamImpl {
    private String filename;
    private long fp;
    private boolean isMvsDataset;
    private ImageInputStream raf;
    private AddressSpace[] spaces;
    private String title;
    private Date creationDate;
    AddressSpace rootSpace;
    private CompressedRecordArray fposArray;
    private int[] fpos = new int[8];
    static final int HEADERSIZE = 64;
    static final int DATABLOCKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static Logger log = Logger.getLogger(Dump.class.getName());

    public static boolean isValid(String string) {
        try {
            new Dump(string, null, false, null, true);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public Dump(String string) throws FileNotFoundException {
        this(string, null, true, null, false);
    }

    public Dump(String string, ImageInputStream imageInputStream, boolean bl) throws FileNotFoundException {
        this(string, null, true, imageInputStream, bl);
    }

    public Dump(String string, SearchListener[] searchListenerArray) throws FileNotFoundException {
        this(string, searchListenerArray, true, null, true);
    }

    private Dump(String string, SearchListener[] searchListenerArray, boolean bl, ImageInputStream imageInputStream, boolean bl2) throws FileNotFoundException {
        log.fine("opening dump " + string + " stream " + imageInputStream);
        this.filename = string;
        if (searchListenerArray != null) {
            throw new Error("tbc");
        }
        try {
            this.raf = imageInputStream != null ? imageInputStream : new FileImageInputStream(new RandomAccessFile(string, "r"));
            if (bl) {
                this.buildAddressSpaces(bl2);
                log.fine("finished building address spaces");
            }
            return;
        }
        catch (Exception exception) {
            if (!System.getProperty("os.arch").equals("390")) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException("Could not find: " + string + " stream " + imageInputStream);
                fileNotFoundException.initCause(exception);
                throw fileNotFoundException;
            }
            this.openMvsDataset();
            if (bl) {
                this.buildAddressSpaces(bl2);
                log.fine("finished building address spaces");
            }
            return;
        }
    }

    private void openMvsDataset() throws FileNotFoundException {
        try {
            log.fine("trying to open dump as an MVS dataset");
            String string = System.getProperty("java.version");
            InputStream inputStream = this.getClass().getResourceAsStream("libzebedee" + string.charAt(2) + ".so");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            File file = File.createTempFile("lib", ".so");
            Process process = Runtime.getRuntime().exec("chmod +x " + file.getPath());
            process.waitFor();
            int n = process.exitValue();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[10000];
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.close();
            file.deleteOnExit();
            System.load(file.getPath());
            log.fine("lib loaded ok");
            this.fp = Clib.fopen("//'" + this.filename + "'", "rb");
            if (this.fp == 0L) {
                throw new FileNotFoundException("Could not find either " + this.filename + " or //" + this.filename);
            }
            this.isMvsDataset = true;
            log.fine("MVS dataset opened ok");
        }
        catch (Exception exception) {
            throw new FileNotFoundException("Could not find: " + this.filename);
        }
    }

    private void buildAddressSpaces(boolean bl) {
        try {
            try {
                if (this.filename == null) {
                    throw new FileNotFoundException("No filename supplied so no cache available");
                }
                File file = new File(this.filename + ".zcache");
                this.readCacheFile(file);
            }
            catch (Exception exception) {
                log.log(Level.FINE, "cache read failed: ", exception);
                log.fine("no cache file, scanning file");
                byte[] byArray = null;
                this.fposArray = new CompressedRecordArray(5, this.fpos.length);
                ObjectMap objectMap = new ObjectMap();
                long l = 0L;
                while (true) {
                    int n;
                    if (this.isMvsDataset) {
                        if (l > 0L) {
                            n = Clib.fseek(this.fp, 4096L, 1);
                            assert (n == 0) : n;
                        }
                    } else {
                        this.raf.seek(l);
                    }
                    if (l == 0L) {
                        byArray = new byte[512];
                    } else if (l == 4160L) {
                        byArray = new byte[64];
                    }
                    try {
                        this.readFully(byArray);
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    if (this.isMvsDataset) {
                        n = Clib.fgetpos(this.fp, this.fpos);
                        assert (n == 0) : n;
                        this.fposArray.add(this.fpos);
                    }
                    n = Dump.readInt(byArray, 0);
                    boolean bl2 = false;
                    if (n == -992349888) {
                        bl2 = true;
                    } else if (n != -992349632) {
                        throw new Error("bad eyecatcher " + Dump.hex(n) + " at offset " + l);
                    }
                    int n2 = Dump.readInt(byArray, 12);
                    if (n2 >= 0) {
                        AddressSpace addressSpace;
                        long l2;
                        long l3 = l2 = bl2 ? (long)Dump.readInt(byArray, 20) : Dump.readLong(byArray, 20);
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("read block, asid = " + Dump.hex(n2) + " address = " + Dump.hex(l2));
                        }
                        if ((addressSpace = (AddressSpace)objectMap.get(n2)) == null) {
                            addressSpace = new AddressSpace(this, n2);
                            objectMap.put(n2, addressSpace);
                        }
                        addressSpace.mapAddressToFileOffset(l2, l + 64L);
                        if (n2 == 1) {
                            this.rootSpace = addressSpace;
                        }
                        if (l == 0L) {
                            byte[] byArray2 = new byte[100];
                            System.arraycopy(byArray, 88, byArray2, 0, 100);
                            this.title = CharConversion.getEbcdicString(byArray2);
                            long l4 = Dump.readInt(byArray, 72);
                            long l5 = Dump.readInt(byArray, 76);
                            this.creationDate = Dump.mvsClockToDate(l4 << 32 | l5 & 0xFFFFFFFFL);
                        }
                    }
                    l += 4160L;
                }
                this.fposArray.close();
                if (this.isMvsDataset) {
                    log.fine("fposArray used " + this.fposArray.memoryUsage());
                }
                this.spaces = (AddressSpace[])objectMap.toArray(new AddressSpace[0]);
                Arrays.sort(this.spaces, new Comparator(){

                    public int compare(Object object, Object object2) {
                        AddressSpace addressSpace = (AddressSpace)object;
                        AddressSpace addressSpace2 = (AddressSpace)object2;
                        return addressSpace.getAsid() - addressSpace2.getAsid();
                    }
                });
                this.seek(0L);
                log.fine("scan complete");
                if (bl && this.filename != null) {
                    File file = new File(this.filename + ".zcache");
                    this.createCacheFile(file);
                }
            }
        }
        catch (IOException iOException) {
            throw new Error("Unexpected exception reading address spaces", iOException);
        }
    }

    private void readCacheFile(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        log.fine("cache file exists, reading contents");
        this.spaces = (AddressSpace[])objectInputStream.readObject();
        for (int i = 0; i < this.spaces.length; ++i) {
            this.spaces[i].setDump(this);
            if (this.spaces[i].getAsid() != 1) continue;
            this.rootSpace = this.spaces[i];
        }
        this.fposArray = (CompressedRecordArray)objectInputStream.readObject();
        this.title = (String)objectInputStream.readObject();
        this.creationDate = (Date)objectInputStream.readObject();
        objectInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCacheFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                try {
                    objectOutputStream.writeObject(this.spaces);
                    objectOutputStream.writeObject(this.fposArray);
                    objectOutputStream.writeObject(this.title);
                    objectOutputStream.writeObject(this.creationDate);
                    log.fine("created cache file " + file);
                }
                finally {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "Unable to create cache file " + file, iOException);
                file.delete();
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "Unable to create cache file " + file, iOException);
        }
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("read int 0x" + Dump.hex(n2) + " at offset 0x" + Dump.hex(n));
        }
        return n2;
    }

    static long readLong(byte[] byArray, int n) {
        long l = Dump.readInt(byArray, n);
        long l2 = Dump.readInt(byArray, n + 4);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public void seek(long l) throws IOException {
        super.seek(l);
        if (this.isMvsDataset) {
            long l2 = l / 4160L;
            this.fposArray.get((int)l2, this.fpos);
            int n = Clib.fsetpos(this.fp, this.fpos);
            if (n != 0) {
                throw new IOException("fsetpos failed");
            }
            long l3 = l - (l2 * 4160L + 64L);
            if (l3 != 0L) {
                throw new Error("TEMP!");
            }
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer("raf seek to offset 0x" + Dump.hex(l));
            }
            this.raf.seek(l);
        }
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + byArray + " " + Dump.hex(n) + " " + Dump.hex(n2));
        }
        if (this.isMvsDataset) {
            if (n == 0) {
                n3 = Clib.fread(byArray, 1, n2, this.fp);
            } else {
                byte[] byArray2 = new byte[n2];
                n3 = Clib.fread(byArray2, 1, n2, this.fp);
                if (n3 > 0) {
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                }
            }
        } else {
            n3 = this.raf.read(byArray, n, n2);
        }
        if (n3 > 0) {
            this.streamPos += (long)n3;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n3) + " bytes");
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + byArray + " " + Dump.hex(byArray.length));
        }
        if ((n = this.isMvsDataset ? Clib.fread(byArray, 1, byArray.length, this.fp) : this.raf.read(byArray)) > 0) {
            this.streamPos += (long)n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n) + " bytes");
        }
        return n;
    }

    public long length() {
        if (this.isMvsDataset) {
            return -1L;
        }
        try {
            return this.raf.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public AddressSpace[] getAddressSpaces() {
        return this.spaces;
    }

    public boolean is64bit() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public static Date mvsClockToDate(long l) {
        l >>>= 12;
        l /= 1000L;
        long l2 = 613608L;
        l2 *= 3600L;
        return new Date(l -= (l2 *= 1000L));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static String hex(long l) {
        return Long.toHexString(l);
    }
}

