/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.IPAddressName;
import java.io.IOException;

public final class URIName
implements GeneralNameInterface {
    private String name;
    private String scheme;
    private String host;
    private String remainder;
    private IPAddressName hostIP;
    private DNSName hostDNS;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.URIName";

    public URIName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "URIName", derValue);
        }
        this.name = derValue.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "URIName");
        }
    }

    public URIName(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "URIName", name);
            debug.exit(16384L, className, "URIName");
        }
        if (name == null || name.length() == 0) {
            throw new IOException("URI name must not be null");
        }
        this.name = name;
        this.parseName();
    }

    private void parseName() throws IOException {
        int startHostNameNdx;
        int endSchemeSpecificNdx;
        int colonAfterSchemeNdx = this.name.indexOf(58);
        if (colonAfterSchemeNdx < 0) {
            throw new IOException("Name " + this.name + " does not include a <scheme>");
        }
        int slashSlashNdx = this.name.indexOf("//", colonAfterSchemeNdx);
        if (slashSlashNdx != colonAfterSchemeNdx + 1) {
            throw new IOException("name does not include scheme-specific portion starting with host");
        }
        int startSlashSearchNdx = slashSlashNdx + 2;
        if (startSlashSearchNdx == this.name.length()) {
            throw new IOException("Name " + this.name + " doesn't include a <host>");
        }
        int rightSquareBracketNdx = this.name.indexOf(93, startSlashSearchNdx);
        if (rightSquareBracketNdx >= 0) {
            startSlashSearchNdx = rightSquareBracketNdx;
        }
        if ((endSchemeSpecificNdx = this.name.indexOf(47, startSlashSearchNdx)) < 0) {
            endSchemeSpecificNdx = this.name.length();
        }
        if ((startHostNameNdx = this.name.indexOf(64, slashSlashNdx + 2) + 1) <= 0 || startHostNameNdx >= endSchemeSpecificNdx) {
            startHostNameNdx = slashSlashNdx + 2;
        }
        int endHostNameNdx = -1;
        if (this.name.charAt(startHostNameNdx) == '[') {
            endHostNameNdx = this.name.indexOf(93, startHostNameNdx);
            if (endHostNameNdx < 0) {
                throw new IOException("Invalid IPv6 address as host: missing ]");
            }
            if (endHostNameNdx < this.name.length() - 1) {
                char nextChar = this.name.charAt(endHostNameNdx + 1);
                if (nextChar != ':' && nextChar != '/') {
                    throw new IOException("Invalid host[:port][/] boundary");
                }
                ++endHostNameNdx;
            } else {
                endHostNameNdx = endSchemeSpecificNdx;
            }
        } else {
            endHostNameNdx = this.name.indexOf(58, startHostNameNdx);
            if (endHostNameNdx < 0 || endHostNameNdx >= endSchemeSpecificNdx) {
                endHostNameNdx = endSchemeSpecificNdx;
            }
        }
        this.scheme = this.name.substring(0, colonAfterSchemeNdx);
        this.host = this.name.substring(startHostNameNdx, endHostNameNdx);
        if (this.host.length() != 0) {
            if (this.host.charAt(0) == '[') {
                String ipV6Host = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(ipV6Host);
                }
                catch (IOException ioe) {
                    throw new IOException("Host portion is not a valid IPv6 address: " + ioe.getMessage());
                }
            }
            try {
                this.hostDNS = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
            }
            catch (Exception ioe) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (Exception ioe2) {
                    throw new IOException("Host portion is not a valid DNS name, IPv4 address, or IPv6 address");
                }
            }
        }
        this.remainder = this.name.substring(colonAfterSchemeNdx, startHostNameNdx);
        if (endHostNameNdx < this.name.length()) {
            this.remainder = this.remainder + this.name.substring(endHostNameNdx);
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 6);
        }
        return 6;
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        out.putIA5String(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "URIName: " + this.name);
        }
        return "URIName: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 6) {
            constraintType = -1;
        } else {
            String otherScheme = ((URIName)inputName).getScheme();
            String otherHost = ((URIName)inputName).getHost();
            if (!this.scheme.equalsIgnoreCase(otherScheme)) {
                constraintType = 3;
            } else if (otherHost.equals(this.host)) {
                constraintType = 0;
            } else {
                if (((URIName)inputName).getHostObject() instanceof IPAddressName && this.hostIP != null) {
                    return this.hostIP.constrains((IPAddressName)((URIName)inputName).getHostObject());
                }
                if (otherHost.charAt(0) == '.' || this.host.charAt(0) == '.') {
                    try {
                        DNSName hostDNS = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
                        DNSName otherDNS = otherHost.charAt(0) == '.' ? new DNSName(otherHost.substring(1)) : new DNSName(otherHost);
                        constraintType = hostDNS.constrains(otherDNS);
                    }
                    catch (IOException ioe2) {
                        constraintType = 3;
                    }
                    catch (UnsupportedOperationException uoe) {
                        constraintType = 3;
                    }
                } else {
                    constraintType = 3;
                }
            }
        }
        return constraintType;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dnsName = null;
        try {
            dnsName = new DNSName(this.host);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException(ioe.getMessage());
        }
        int i = dnsName.subtreeDepth();
        return i;
    }
}

