/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;
    private boolean hasMin;
    private boolean hasMax;
    private boolean minMaxValid = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.X509.NameConstraintsExtension";

    private void calcMinMax() throws IOException {
        GeneralSubtree subtree;
        int i;
        this.hasMin = false;
        this.hasMax = false;
        if (this.excluded != null) {
            for (i = 0; i < this.excluded.size(); ++i) {
                subtree = this.excluded.get(i);
                if (subtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (subtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        if (this.permitted != null) {
            for (i = 0; i < this.permitted.size(); ++i) {
                subtree = this.permitted.get(i);
                if (subtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (subtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        this.minMaxValid = true;
    }

    private void encodeThis() throws IOException {
        DerOutputStream tmp;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream tagged = new DerOutputStream();
        if (this.permitted != null) {
            tmp = new DerOutputStream();
            this.permitted.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.excluded != null) {
            tmp = new DerOutputStream();
            this.excluded.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public NameConstraintsExtension(GeneralSubtrees permitted, GeneralSubtrees excluded) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NameConstraintsExtension", permitted, excluded);
        }
        if (permitted == null && excluded == null) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "NameConstraints: Invalid arguments");
            }
            throw new IOException("NameConstraints: Invalid arguments");
        }
        if (permitted != null) {
            this.permitted = (GeneralSubtrees)permitted.clone();
        }
        if (excluded != null) {
            this.excluded = (GeneralSubtrees)excluded.clone();
        }
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "NameConstraintsExtension");
        }
    }

    public NameConstraintsExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NameConstraintsExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Invalid encoding for NameConstraintsExtension.");
            }
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        while (val.getData() != null && val.getData().available() != 0) {
            DerValue opt = val.getData().getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                if (this.permitted != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "NameConstraintsExtension", "Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                    }
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.excluded != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "NameConstraintsExtension", "Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                    }
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                opt.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(opt);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "NameConstraintsExtension", "Invalid encoding of NameConstraintsExtension.");
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "NameConstraintsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n");
        }
        return super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralSubtrees.");
                }
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)obj;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(obj instanceof GeneralSubtrees)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralSubtrees.");
                }
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.permitted);
            }
            return this.permitted;
        }
        if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.excluded);
            }
            return this.excluded;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (name.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(PERMITTED_SUBTREES);
        elements.addElement(EXCLUDED_SUBTREES);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public void merge(NameConstraintsExtension newConstraints) throws IOException {
        if (newConstraints == null) {
            return;
        }
        GeneralSubtrees newExcluded = (GeneralSubtrees)newConstraints.get(EXCLUDED_SUBTREES);
        if (this.excluded == null) {
            this.excluded = newExcluded != null ? (GeneralSubtrees)newExcluded.clone() : null;
        } else if (newExcluded != null) {
            this.excluded.union(newExcluded);
        }
        GeneralSubtrees newPermitted = (GeneralSubtrees)newConstraints.get(PERMITTED_SUBTREES);
        if (this.permitted == null) {
            this.permitted = newPermitted != null ? (GeneralSubtrees)newPermitted.clone() : null;
        } else if (newPermitted != null && (newExcluded = this.permitted.intersect(newPermitted)) != null) {
            if (this.excluded != null) {
                this.excluded.union(newExcluded);
            } else {
                this.excluded = (GeneralSubtrees)newExcluded.clone();
            }
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
        }
        this.encodeThis();
    }

    public boolean verify(GeneralNameInterface name) throws IOException {
        if (name == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            block9: for (int i = 0; i < this.excluded.size(); ++i) {
                GeneralNameInterface exName;
                GeneralName gn;
                GeneralSubtree gs = this.excluded.get(i);
                if (gs == null || (gn = gs.getBase()) == null || (exName = gn.getName()) == null) continue;
                switch (exName.constrains(name)) {
                    case -1: 
                    case 2: 
                    case 3: {
                        continue block9;
                    }
                    case 0: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            boolean sameType = false;
            block10: for (int i = 0; i < this.permitted.size(); ++i) {
                GeneralNameInterface perName;
                GeneralName gn;
                GeneralSubtree gs = this.permitted.get(i);
                if (gs == null || (gn = gs.getBase()) == null || (perName = gn.getName()) == null) continue;
                switch (perName.constrains(name)) {
                    case -1: {
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        sameType = true;
                        continue block10;
                    }
                    case 0: 
                    case 1: {
                        return true;
                    }
                }
            }
            if (sameType) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyRFC822SpecialCase(X500Name subject) throws IOException {
        for (AVA ava : subject.allAvas()) {
            RFC822Name emailName;
            String attrValue;
            ObjectIdentifier attrOID = ava.getObjectIdentifier();
            if (!attrOID.equals(X500Name.emailAddress_oid) || (attrValue = ava.getValueString()) == null) continue;
            try {
                emailName = new RFC822Name(attrValue);
            }
            catch (IOException ioe) {
                continue;
            }
            if (this.verify(emailName)) continue;
            return false;
        }
        return true;
    }
}

