/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvalidityDateExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.InvalidityDate";
    public static final String NAME = "InvalidityDate";
    public static final String NUMBER = "value";
    private Date invalidityDate;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.InvalidityDateExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.invalidityDate == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        os.putGeneralizedTime(this.invalidityDate);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public InvalidityDateExtension(Date invalidityDate) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InvalidityDateExtension", invalidityDate);
        }
        this.setInvalidityDate(invalidityDate);
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InvalidityDateExtension");
        }
    }

    public InvalidityDateExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "InvalidityDateExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.setInvalidityDate(val.getGeneralizedTime());
        if (debug != null) {
            debug.exit(16384L, className, "InvalidityDateExtension");
        }
    }

    private void setInvalidityDate(Date invalidityDate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setInvalidityDate", invalidityDate);
        }
        if (invalidityDate == null) {
            if (debug != null) {
                debug.text(8192L, className, "setInvalidityDate", "invalidityDate not specified.");
            }
            throw new IllegalArgumentException("invalidityDate not specified.");
        }
        this.invalidityDate = invalidityDate;
        if (debug != null) {
            debug.exit(8192L, className, "setInvalidityDate");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof Date)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type Date.");
                }
                throw new IOException("Attribute must be of type Date.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.setInvalidityDate((Date)obj);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.invalidityDate == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Date(this.invalidityDate.getTime()));
            }
            return new Date(this.invalidityDate.getTime());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "get", "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "get", "delete", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.invalidityDate = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "Invalidity Date: ";
        s = this.invalidityDate == null ? s + "null" : s + this.invalidityDate.toString();
        s = s + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

