/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorityInfoAccessExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.AuthorityInfoAccess";
    public static final String AUTHORITY_INFO_ACCESS = "authority_info_access";
    public static final String NAME = "AuthorityInfoAccess";
    private Vector<AccessDescription> descriptions = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AuthorityInfoAccessExtension";

    public AuthorityInfoAccessExtension(Vector descriptions) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "AuthorityInfoAccessExtension", descriptions);
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = false;
        if (descriptions == null || descriptions.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityInfoAccessExtension", "descriptions is null or empty.");
            }
            throw new IllegalArgumentException("descriptions is null or empty.");
        }
        this.descriptions = (Vector)descriptions.clone();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    public AuthorityInfoAccessExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityInfoAccessExtension");
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = false;
        this.descriptions = new Vector(1, 1);
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    public AuthorityInfoAccessExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityInfoAccessExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityInfoAccessExtension", "Invalid encoding for AuthorityInfoAccessExtension.");
            }
            throw new IOException("Invalid encoding for AuthorityInfoAccessExtension.");
        }
        this.descriptions = new Vector(1, 1);
        while (val.getData().available() != 0) {
            DerValue seq = val.getData().getDerValue();
            AccessDescription description = new AccessDescription(seq.toByteArray());
            this.descriptions.addElement(description);
        }
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityInfoAccessExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.descriptions == null) {
            if (debug != null) {
                debug.exit(16384L, className, "toString_1");
            }
            return "";
        }
        String s = super.toString() + "AuthorityInfoAccess [\r\n" + this.descriptions.toString() + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityInfoAccess_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (!(obj instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
            this.descriptions = obj != null ? (Vector)((Vector)obj).clone() : null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (this.descriptions != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.descriptions.clone());
                }
                return this.descriptions.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.descriptions);
            }
            return this.descriptions;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(AUTHORITY_INFO_ACCESS)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityInfoAccessExtension.");
        }
        this.descriptions = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(AUTHORITY_INFO_ACCESS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.descriptions == null || this.descriptions.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.descriptions.size(); ++i) {
            this.descriptions.elementAt(i).encode(tmp);
        }
        os.write((byte)48, tmp);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }
}

