/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.validator.Validator;
import com.ibm.security.validator.ValidatorException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class PKIXValidator
extends Validator {
    private static final boolean TRY_VALIDATOR = true;
    private final Set trustedCerts;
    private final PKIXBuilderParameters parameterTemplate;
    private Set trustedSubjects;
    private CertificateFactory factory;

    PKIXValidator(String variant, Collection trustedCerts) {
        super("PKIX", variant);
        this.trustedCerts = trustedCerts instanceof Set ? (Set)trustedCerts : new HashSet(trustedCerts);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustedCerts) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        try {
            this.parameterTemplate = new PKIXBuilderParameters(trustAnchors, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Unexpected error: " + e.toString(), e);
        }
        this.setDefaultParameters(variant);
        this.initCommon();
    }

    PKIXValidator(String variant, PKIXBuilderParameters params) {
        super("PKIX", variant);
        this.trustedCerts = new HashSet();
        for (TrustAnchor anchor : params.getTrustAnchors()) {
            X509Certificate cert = anchor.getTrustedCert();
            if (cert == null) continue;
            this.trustedCerts.add(cert);
        }
        this.parameterTemplate = params;
        this.initCommon();
    }

    private void initCommon() {
        this.trustedSubjects = new HashSet();
        for (X509Certificate cert : this.trustedCerts) {
            this.trustedSubjects.add(cert.getSubjectX500Principal());
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    private void setDefaultParameters(String variant) {
        this.parameterTemplate.setRevocationEnabled(false);
    }

    public PKIXBuilderParameters getParameters() {
        return this.parameterTemplate;
    }

    X509Certificate[] engineValidate(X509Certificate[] chain, Collection otherCerts, Object parameter) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        for (int i = 0; i < chain.length; ++i) {
            if (!this.trustedCerts.contains(chain[i])) continue;
            if (i == 0) {
                return new X509Certificate[]{chain[0]};
            }
            X509Certificate[] newChain = new X509Certificate[i];
            System.arraycopy(chain, 0, newChain, 0, i);
            return this.doValidate(newChain);
        }
        X509Certificate last = chain[chain.length - 1];
        X500Principal issuer = last.getIssuerX500Principal();
        X500Principal subject = last.getSubjectX500Principal();
        if (this.trustedSubjects.contains(issuer) && !issuer.equals(subject)) {
            return this.doValidate(chain);
        }
        return this.doBuild(chain, otherCerts);
    }

    private static X509Certificate[] toArray(CertPath path, TrustAnchor anchor) throws CertificateException {
        List<? extends Certificate> list = path.getCertificates();
        X509Certificate[] chain = new X509Certificate[list.size() + 1];
        list.toArray(chain);
        X509Certificate trustedCert = anchor.getTrustedCert();
        if (trustedCert == null) {
            throw new ValidatorException("TrustAnchor must be specified as certificate");
        }
        chain[chain.length - 1] = trustedCert;
        return chain;
    }

    private void setDate(PKIXBuilderParameters params) {
        Date date = this.validationDate;
        if (date != null) {
            params.setDate(date);
        }
    }

    private X509Certificate[] doValidate(X509Certificate[] chain) throws CertificateException {
        try {
            PKIXBuilderParameters params = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(params);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertPath path = this.factory.generateCertPath(Arrays.asList(chain));
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(path, params);
            return PKIXValidator.toArray(path, result.getTrustAnchor());
        }
        catch (GeneralSecurityException e) {
            throw new ValidatorException("PKIX path validation failed: " + e.toString(), e);
        }
    }

    private X509Certificate[] doBuild(X509Certificate[] chain, Collection otherCerts) throws CertificateException {
        try {
            PKIXBuilderParameters params = (PKIXBuilderParameters)this.parameterTemplate.clone();
            this.setDate(params);
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(chain[0]);
            params.setTargetCertConstraints(selector);
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.addAll(Arrays.asList(chain));
            if (otherCerts != null) {
                certs.addAll(otherCerts);
            }
            CertStore store = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
            params.addCertStore(store);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(params);
            return PKIXValidator.toArray(result.getCertPath(), result.getTrustAnchor());
        }
        catch (GeneralSecurityException e) {
            throw new ValidatorException("PKIX path building failed: " + e.toString(), e);
        }
    }
}

