/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerIndefLenConverter;
import com.ibm.security.util.DerInputBuffer;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import com.ibm.security.util.calendar.CalendarDate;
import com.ibm.security.util.calendar.CalendarSystem;
import com.ibm.security.util.calendar.Gregorian;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;

public final class DerInputStream {
    DerInputBuffer buffer;

    public DerInputStream(byte[] data) throws IOException {
        this.init(data, 0, data.length);
    }

    public DerInputStream(byte[] data, int offset, int len) throws IOException {
        this.init(data, offset, len);
    }

    private void init(byte[] data, int offset, int len) throws IOException {
        if (offset + 2 > data.length || offset + len > data.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(data[offset + 1])) {
            try {
                byte[] inData = new byte[len];
                System.arraycopy(data, offset, inData, 0, len);
                byte[] bytes = DerIndefLenConverter.convertIndefToDef(inData);
                this.buffer = new DerInputBuffer(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(new IOException("DerIndefLenConverter.convertIndefToDef failed"));
            }
        } else {
            this.buffer = new DerInputBuffer(data, offset, len);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int len, boolean do_skip) throws IOException {
        DerInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (do_skip) {
            this.buffer.skip(len);
        }
        return new DerInputStream(newbuf);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInteger getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public int getSignedInt() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getSigned(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        byte[] retval;
        byte tag = (byte)this.buffer.read();
        if (tag != 3 && tag != 35) {
            throw new IOException("DER input not an bit string");
        }
        int length = DerInputStream.getLength(this.buffer);
        int numOfPadBits = this.buffer.read();
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        if (this.buffer.read(retval = new byte[--length]) != length) {
            throw new IOException("short read of DER bit string");
        }
        if (numOfPadBits != 0) {
            int n = length - 1;
            retval[n] = (byte)(retval[n] & 255 << numOfPadBits);
        }
        return retval;
    }

    public BitArray getUnalignedBitString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 3 && tag != 35) {
            throw new IOException("DER input not a bit string");
        }
        int length = DerInputStream.getLength(this.buffer);
        int validBits = --length * 8 - this.buffer.read();
        byte[] repn = new byte[length];
        if (this.buffer.read(repn) != length) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(validBits, repn);
    }

    public byte[] getOctetString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 4 && tag != 36) {
            throw new IOException("DER input not an octet string");
        }
        int length = DerInputStream.getLength(this.buffer);
        if (length == 0) {
            return null;
        }
        byte[] retval = new byte[length];
        int x = 0;
        x = this.buffer.read(retval);
        if (x != length) {
            throw new IOException("short read of DER octet string");
        }
        return retval;
    }

    public byte[] getBMPString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 30 && tag != 62) {
            throw new IOException("DER input not a BMP string; invalid tag");
        }
        int length = DerInputStream.getLength(this.buffer);
        if (length % 2 != 0) {
            throw new IOException("DER input not a BMP string; invalid length");
        }
        byte[] retval = new byte[length];
        if (this.buffer.read(retval) != length) {
            throw new IOException("short read of DER BMPString");
        }
        return retval;
    }

    public void getBytes(byte[] val) throws IOException {
        if (val.length != 0 && this.buffer.read(val) != val.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int startLen) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen) throws IOException {
        int tag = this.buffer.read();
        if (tag != 49) {
            throw new IOException("Set tag error.  Found tag " + tag);
        }
        return this.readVector(startLen);
    }

    public DerValue[] getSet(int startLen, boolean implicit) throws IOException {
        int tag = this.buffer.read();
        if (!implicit && tag != 49) {
            throw new IOException("Set tag error.  Found tag " + tag);
        }
        return this.readVector(startLen);
    }

    protected DerValue[] readVector(int startLen) throws IOException {
        int len = DerInputStream.getLength(this.buffer);
        if (len == 0) {
            return new DerValue[0];
        }
        DerInputStream newstr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DerValue> vec = new Vector<DerValue>(startLen, 5);
        do {
            DerValue value = new DerValue(newstr.buffer);
            vec.addElement(value);
        } while (newstr.available() > 0);
        if (newstr.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int max = vec.size();
        DerValue[] retval = new DerValue[max];
        for (int i = 0; i < max; ++i) {
            retval[i] = (DerValue)vec.elementAt(i);
        }
        return retval;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    private String simpleGetString(int tag) throws IOException {
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER Printable string");
        }
        String s = null;
        try {
            s = new String(retval, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            s = new String(retval);
        }
        return s;
    }

    public String getPrintableString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 19 && tag != 51) {
            throw new IOException("DER input not a Printable string");
        }
        return this.simpleGetString(tag);
    }

    public String getT61String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 20 && tag != 52) {
            throw new IOException("DER input not a T61 string");
        }
        return this.simpleGetString(tag);
    }

    public String getIA5String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 22 && tag != 54) {
            throw new IOException("DER input not an IA5 string");
        }
        return this.simpleGetString(tag);
    }

    public String getUTF8String() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 12 && tag != 44) {
            throw new IOException("DER input not a UTF8 string");
        }
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER UTF8 string");
        }
        StringBuilder s = UTFUtils.fromUTF(retval);
        return new String(s);
    }

    public String getUniversalString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 28 && tag != 60) {
            throw new IOException("DER input not a Universal string");
        }
        int length = DerInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (length != 0 && this.buffer.read(retval) != length) {
            throw new IOException("short read of DER Universal string");
        }
        StringBuilder s = UTFUtils.fromUniv(retval);
        return new String(s);
    }

    public Date getUTCTime() throws IOException {
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        int len = DerInputStream.getLength(this.buffer);
        if (len > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (len < 11 || len > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        return this.getTime(len, false);
    }

    public Date getGeneralizedTime() throws IOException {
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        int len = DerInputStream.getLength(this.buffer);
        if (len > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (len < 13 || len > 19) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(len, true);
    }

    public String getGeneralString() throws IOException {
        byte tag = (byte)this.buffer.read();
        if (tag != 27) {
            throw new IOException("DER input not a General string");
        }
        return this.simpleGetString(tag);
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream in) throws IOException {
        return DerInputStream.getLength(in.read(), in);
    }

    static int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        return value;
    }

    public void mark(int value) {
        this.buffer.mark(value);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }

    private Date getTime(int len, boolean generalized) throws IOException {
        int second;
        int year;
        String type = null;
        if (generalized) {
            type = "Generalized";
            year = 1000 * Character.digit((char)this.buffer.read(), 10);
            year += 100 * Character.digit((char)this.buffer.read(), 10);
            year += 10 * Character.digit((char)this.buffer.read(), 10);
            year += Character.digit((char)this.buffer.read(), 10);
            len -= 2;
        } else {
            type = "UTC";
            year = 10 * Character.digit((char)this.buffer.read(), 10);
            year = (year += Character.digit((char)this.buffer.read(), 10)) < 50 ? (year += 2000) : (year += 1900);
        }
        int month = 10 * Character.digit((char)this.buffer.read(), 10);
        month += Character.digit((char)this.buffer.read(), 10);
        int day = 10 * Character.digit((char)this.buffer.read(), 10);
        day += Character.digit((char)this.buffer.read(), 10);
        int hour = 10 * Character.digit((char)this.buffer.read(), 10);
        hour += Character.digit((char)this.buffer.read(), 10);
        int minute = 10 * Character.digit((char)this.buffer.read(), 10);
        minute += Character.digit((char)this.buffer.read(), 10);
        char peek = (char)this.buffer.read();
        int millis = 0;
        if ((len -= 10) > 2 && len < 12) {
            second = 10 * Character.digit(peek, 10);
            second += Character.digit((char)this.buffer.read(), 10);
            peek = (char)this.buffer.read();
            len -= 2;
            if (peek == '.' || peek == ',') {
                --len;
                int precision = 0;
                char peek1 = ' ';
                char peek2 = ' ';
                char peek3 = ' ';
                peek = (char)this.buffer.read();
                if (peek != 'Z' && peek != '+' && peek != '-') {
                    peek1 = peek;
                    ++precision;
                    peek = (char)this.buffer.read();
                    if (peek != 'Z' && peek != '+' && peek != '-') {
                        peek2 = peek;
                        ++precision;
                        peek = (char)this.buffer.read();
                        if (peek != 'Z' && peek != '+' && peek != '-') {
                            peek3 = peek;
                            peek = (char)this.buffer.read();
                            ++precision;
                        }
                    }
                }
                switch (precision) {
                    case 3: {
                        millis += 100 * Character.digit(peek1, 10);
                        millis += 10 * Character.digit(peek2, 10);
                        millis += Character.digit(peek3, 10);
                        break;
                    }
                    case 2: {
                        millis += 100 * Character.digit(peek1, 10);
                        millis += 10 * Character.digit(peek2, 10);
                        break;
                    }
                    case 1: {
                        millis += 100 * Character.digit(peek1, 10);
                        break;
                    }
                    default: {
                        throw new IOException("Parse " + type + " time, unsupported precision for seconds value");
                    }
                }
                len -= precision;
            }
        } else {
            second = 0;
        }
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        CalendarDate date = ((CalendarSystem)gcal).newCalendarDate(null);
        date.setDate(year, month, day);
        date.setTimeOfDay(hour, minute, second, 0);
        long time = ((CalendarSystem)gcal).getTime(date);
        if (len != 1 && len != 5) {
            throw new IOException("Parse " + type + " time, invalid offset");
        }
        switch (peek) {
            case '+': {
                int hr = 10 * Character.digit((char)this.buffer.read(), 10);
                int min = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((hr += Character.digit((char)this.buffer.read(), 10)) >= 24 || (min += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse " + type + " time, +hhmm");
                }
                time -= (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case '-': {
                int hr = 10 * Character.digit((char)this.buffer.read(), 10);
                int min = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((hr += Character.digit((char)this.buffer.read(), 10)) >= 24 || (min += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse " + type + " time, -hhmm");
                }
                time += (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 'Z': {
                break;
            }
            default: {
                throw new IOException("Parse " + type + " time, garbage offset");
            }
        }
        return new Date(time);
    }
}

