/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class PKCSAttributes
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private Hashtable map;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSAttributes";
    private DerValue orig_derValue;

    public PKCSAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes");
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.map = new Hashtable(3);
    }

    public PKCSAttributes(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", provider);
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.map = new Hashtable(3);
    }

    public PKCSAttributes(DerInputStream in) throws IOException {
        this(in, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", in);
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(DerInputStream in, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", in, provider);
        }
        this.map = new Hashtable(3);
        byte[] data = in.toByteArray();
        DerValue[] attrs = in.peekByte() == 49 ? in.getSet(3) : in.getSet(3, true);
        if (attrs == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCSAttributes", "Illegal encoding of attributes");
            }
            throw new IOException("Illegal encoding of attributes");
        }
        for (int i = 0; i < attrs.length; ++i) {
            PKCSAttribute attr = new PKCSAttribute(attrs[i].toByteArray(), this.provider);
            this.map.put(attr.getAttributeId().toString(), attr);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.orig_derValue = new DerValue(data);
    }

    public PKCSAttributes(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", (Object)der);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", der, provider);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(PKCSAttribute[] attrs) {
        this.map = new Hashtable(3);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", attrs);
        }
        if (attrs != null && attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                this.map.put(attrs[i].getAttributeId().toString(), attrs[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(PKCSAttribute[] attrs, String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", attrs, provider);
        }
        this.map = new Hashtable(3);
        if (attrs != null && attrs.length > 0) {
            for (int i = 0; i < attrs.length; ++i) {
                this.map.put(attrs[i].getAttributeId().toString(), attrs[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "PKCSAttributes", parms);
            debug.entry(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCSAttributes", parms);
            debug.entry(16384L, className, "PKCSAttributes");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCSAttributes attribs = new PKCSAttributes(this.provider);
            Enumeration enumCount = this.getElements();
            while (enumCount.hasMoreElements()) {
                PKCSAttribute attrib = (PKCSAttribute)enumCount.nextElement();
                attribs = attribs.addAttribute(attrib);
            }
            if (this.orig_derValue != null) {
                attribs.orig_derValue = new DerValue(this.orig_derValue.toByteArray());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", attribs);
            }
            return attribs;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public byte[] generateDerEncoding() throws IOException {
        DerOutputStream out = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "generateDerEncoding");
        }
        Object[] attribVals = this.map.values().toArray();
        out.putOrderedSetOf((byte)49, PKCSAttributes.castToDerEncoder(attribVals));
        byte[] retval = out.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateDerEncoding", retval);
        }
        return retval;
    }

    static DerEncoder[] castToDerEncoder(Object[] objs) {
        DerEncoder[] encoders = new DerEncoder[objs.length];
        if (debug != null) {
            debug.entry(49152L, (Object)className, "castToDerEncoder", objs);
        }
        for (int i = 0; i < encoders.length; ++i) {
            encoders[i] = (DerEncoder)objs[i];
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "castToDerEncoder", encoders);
        }
        return encoders;
    }

    public void derEncode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        PKCSAttribute[] attribs = this.getAttributes();
        DerOutputStream attrOut = new DerOutputStream();
        DerEncoder[] temps = new DerOutputStream[attribs.length];
        for (int i = 0; i < attribs.length; ++i) {
            temps[i] = new DerOutputStream();
            attribs[i].encode((OutputStream)((Object)temps[i]));
        }
        attrOut.putOrderedSetOf((byte)49, temps);
        out.write(attrOut.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public PKCSAttributes addAttribute(PKCSAttribute attr) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttribute", attr);
        }
        if (attr == null || attr.getAttributeId() == null || attr.getAttributeId().toString().length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addAttribute", "Invalid input attribute");
            }
            throw new IllegalArgumentException("Invalid input attribute");
        }
        PKCSAttributes newAttrs = (PKCSAttributes)this.clone();
        newAttrs.map.put(attr.getAttributeId().toString(), attr);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttribute", newAttrs);
        }
        return newAttrs;
    }

    public PKCSAttributes addAttributes(PKCSAttributes attrs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", attrs);
        }
        if (attrs == null || attrs.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addAttributes", "Invalid input attribute.");
            }
            throw new IllegalArgumentException("Invalid input attribute.");
        }
        PKCSAttributes newAttrs = (PKCSAttributes)this.clone();
        Enumeration enumCount = newAttrs.getElements();
        while (enumCount.hasMoreElements()) {
            PKCSAttribute attr = (PKCSAttribute)enumCount.nextElement();
            newAttrs = newAttrs.addAttribute(attr);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes", newAttrs);
        }
        return newAttrs;
    }

    public Object getAttribute(String name) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", name);
        }
        PKCSAttribute attr = (PKCSAttribute)this.map.get(name);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute", attr.clone());
        }
        return attr.clone();
    }

    public Object getAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", oid);
        }
        if (oid == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute attr = (PKCSAttribute)this.map.get(oid.toString());
        if (attr == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute_3", attr.clone());
        }
        return attr.clone();
    }

    public PKCSAttributes deleteAttribute(String name) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", name);
        }
        PKCSAttributes newAttrs = (PKCSAttributes)this.clone();
        newAttrs.map.remove(name);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute", newAttrs);
        }
        return newAttrs;
    }

    public PKCSAttributes deleteAttribute(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", oid);
        }
        if (oid == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteAttribute_1", this);
            }
            return this;
        }
        PKCSAttributes newAttrs = (PKCSAttributes)this.clone();
        newAttrs.map.remove(oid.toString());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute_2", newAttrs);
        }
        return newAttrs;
    }

    public PKCSAttributes deleteAttribute(PKCSAttribute attr) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", attr);
        }
        if (attr == null || attr.getAttributeId() == null || attr.getAttributeId().toString().length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "deleteAttribute", "Invalid input attribute");
            }
            throw new IllegalArgumentException("Invalid input attribute");
        }
        PKCSAttributes newAttrs = (PKCSAttributes)this.clone();
        newAttrs = newAttrs.deleteAttribute(attr.getAttributeId().toString());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute", newAttrs);
        }
        return newAttrs;
    }

    public PKCSAttribute[] getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
        }
        PKCSAttribute[] attrs = new PKCSAttribute[this.size()];
        Enumeration enumCount = this.getElements();
        int i = 0;
        while (enumCount.hasMoreElements()) {
            attrs[i] = (PKCSAttribute)enumCount.nextElement();
            ++i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributes", attrs);
        }
        return attrs;
    }

    public int size() {
        if (debug != null) {
            debug.entry(16384L, className, "size");
            debug.exit(16384L, (Object)className, "size", this.map.size());
        }
        return this.map.size();
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof PKCSAttributes)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        PKCSAttribute[] otherAttribs = ((PKCSAttributes)other).getAttributes();
        int len = otherAttribs.length;
        if (len != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String key = null;
        for (int i = 0; i < len; ++i) {
            PKCSAttribute otherAttr = otherAttribs[i];
            key = otherAttr.getAttributeId().toString();
            if (key == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            PKCSAttribute thisAttr = (PKCSAttribute)this.map.get(key);
            if (thisAttr == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_5", false);
                }
                return false;
            }
            if (thisAttr.equals((Object)otherAttr)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_6", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_7", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.map.hashCode());
        }
        return this.map.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String s = new String();
        int i = 0;
        s = s + "PKCSAttributes.length = " + this.map.size() + "\r\n";
        Enumeration enumCount = this.getElements();
        while (enumCount.hasMoreElements()) {
            String encodeout;
            block7: {
                Object value;
                PKCSAttribute attr = (PKCSAttribute)enumCount.nextElement();
                ObjectIdentifier oid = attr.getAttributeId();
                String oidname = PKCS9.getName(oid);
                String pszoid = null;
                pszoid = oidname == null ? oid.toString() : oidname;
                try {
                    value = attr.getAttributeValue();
                }
                catch (IOException e) {
                    value = null;
                }
                s = s + "\t[" + i + "]:\t" + pszoid + "\t" + value + "\r\n";
                encodeout = "\r\n";
                try {
                    DerOutputStream tmpout = new DerOutputStream();
                    attr.encode(tmpout);
                    encodeout = hexDump.encodeBuffer(tmpout.toByteArray());
                }
                catch (IOException e) {
                    if (debug == null) break block7;
                    debug.exception(16384L, className, "toString", e);
                }
            }
            s = s + encodeout;
            ++i;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        DerInputStream derIn = new DerInputStream(encoding.toByteArray());
        DerValue[] elems = derIn.getSet(1);
        for (int i = elems.length - 1; i >= 0; --i) {
            PKCSAttribute attrib;
            try {
                PKCS9DerObject pkcs9attr = PKCS9.getPKCS9Attribute(elems[i].toByteArray());
                attrib = new PKCSAttribute(pkcs9attr, this.provider);
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", e);
                }
                DerOutputStream out = new DerOutputStream();
                elems[i].encode(out);
                UnresolvedAttribute unattrib = new UnresolvedAttribute(out.toByteArray(), this.provider);
                attrib = new PKCSAttribute(unattrib, this.provider);
            }
            this.map.put(attrib.getAttributeId().toString(), attrib);
        }
        this.orig_derValue = encoding;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private Enumeration getElements() {
        if (debug != null) {
            debug.entry(8192L, className, "getElements");
            debug.exit(8192L, (Object)className, "getElements", this.map.elements());
        }
        return this.map.elements();
    }

    public byte[] getOriginalEncoded() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerEncoding");
        }
        DerOutputStream out = new DerOutputStream();
        if (this.orig_derValue != null) {
            DerInputStream dis = this.orig_derValue.getData();
            out.write((byte)49, dis.toByteArray());
            if (debug != null) {
                debug.exit(16384L, className, "getDerEncoding");
            }
            return out.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, className, "getDerEncoding");
        }
        return null;
    }
}

