/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class UnstructuredAddress
extends PKCS9DerObject
implements Cloneable {
    private String[] addresses;
    private byte type;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.UnstructuredAddress";
    private volatile int cachedHashVal = 0;

    public UnstructuredAddress(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnstructuredAddress", (Object)der);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", der, provider);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String[] addresses, byte type) {
        this.addresses = addresses;
        this.type = type;
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", addresses, new Byte(type));
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String[] addresses, byte type, String provider) {
        super(provider);
        this.addresses = addresses;
        this.type = type;
        if (debug != null) {
            Object[] parms = new Object[]{addresses, new Byte(type), provider};
            debug.entry(16384L, (Object)className, "UnstructuredAddress", parms);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "UnstructuredAddress", filename, new Boolean(base64));
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public UnstructuredAddress(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{this.addresses, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "UnstructuredAddress", parms);
            debug.exit(16384L, className, "UnstructuredAddress");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            UnstructuredAddress result = new UnstructuredAddress(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof UnstructuredAddress) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((UnstructuredAddress)obj)));
            }
            return this.equals((UnstructuredAddress)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.UNSTRUCTURED_ADDRESS_OID);
        }
        return PKCSOID.UNSTRUCTURED_ADDRESS_OID;
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.addresses == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Unstructured addresses not specified.");
            }
            throw new IOException("Unstructured addresses not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        DerEncoder[] temps = new DerOutputStream[this.addresses.length];
        for (int i = 0; i < this.addresses.length; ++i) {
            temps[i] = new DerOutputStream();
            if (this.type == 20) {
                ((DerOutputStream)temps[i]).putPrintableString(this.addresses[i]);
                continue;
            }
            ((DerOutputStream)temps[i]).putPrintableString(this.addresses[i]);
        }
        tmpout.putOrderedSetOf((byte)49, temps);
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String[] getUnstructuredAddresses() {
        if (debug != null) {
            debug.entry(16384L, className, "getUnstructuredAddresses");
            debug.exit(16384L, (Object)className, "getUnstructuredAddresses", this.addresses.clone());
        }
        return (String[])this.addresses.clone();
    }

    public byte getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", new Byte(this.type));
        }
        return this.type;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getUnstructuredAddresses());
        }
        return this.getUnstructuredAddresses();
    }

    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, className, "isTagValid");
        }
        if (tag == 19 || tag == 20) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(false));
        }
        return false;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "UnstructuredAddress");
        }
        return "UnstructuredAddress";
    }

    public String toString() {
        int len = this.addresses.length;
        String out = "PKCS9 UnstructuredAddress: ";
        for (int i = 0; i < len; ++i) {
            out = out + " \"" + this.addresses[i] + "\"";
            if (i == len - 1) continue;
            out = out + ",";
        }
        out = out + "\r\n";
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.type = elems[0].getTag() == 20 ? (byte)20 : (byte)19;
        this.addresses = new String[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            this.addresses[i] = elems[i].getAsString();
            if (debug == null) continue;
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(UnstructuredAddress other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", e);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(false));
        }
        return true;
    }
}

