/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.ESSCertID;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SigningCertificate
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SigningCertificate";
    private static final int MAX_SIZE = 5;
    private ArrayList<ESSCertID> certIds;
    private ArrayList<PolicyInformation> policyInfos;
    private volatile int cachedHashVal = 0;

    public SigningCertificate(byte[] der) throws IOException {
        super(der);
    }

    public SigningCertificate(byte[] der, String provider) throws IOException {
        super(der, provider);
    }

    public SigningCertificate(String filename, boolean base64) throws IOException {
        super(filename, base64);
    }

    public SigningCertificate(X509Certificate[] certs, PolicyInformation[] policies, boolean addIssuerSerial) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (certs != null && certs.length > 0) {
            MessageDigest md = MessageDigest.getInstance("SHA");
            for (int i = 0; i < certs.length; ++i) {
                md.update(certs[i].getEncoded());
                byte[] certHash = md.digest();
                md.reset();
                if (addIssuerSerial) {
                    SerialNumber sn = new SerialNumber(certs[i].getSerialNumber());
                    GeneralNames issuerName = new GeneralNames();
                    issuerName.add(new GeneralName((X500Name)certs[i].getIssuerDN()));
                    this.addCertID(certHash, sn, issuerName);
                    continue;
                }
                this.addCertID(certHash, null, null);
            }
        }
        if (policies != null && policies.length > 0) {
            for (int i = 0; i < policies.length; ++i) {
                this.addPolicyInfo(policies[i]);
            }
        }
    }

    public SigningCertificate(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
    }

    @Override
    public boolean isTagValid(byte tag) {
        return tag == 48;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "SigningCertificate";
    }

    @Override
    public Object getValue() {
        return this.clone();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.certIds == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ESSCertID objects not specified.");
            }
            throw new IOException("ESSCertID objects not specified.");
        }
        DerOutputStream signingCertInternal = new DerOutputStream();
        DerOutputStream certsOStream = new DerOutputStream();
        Iterator<Object> it = this.certIds.iterator();
        while (it.hasNext()) {
            it.next().encode(certsOStream);
        }
        signingCertInternal.write((byte)48, certsOStream);
        if (this.policyInfos != null && this.policyInfos.size() > 0) {
            DerOutputStream policiesOStream = new DerOutputStream();
            it = this.policyInfos.iterator();
            while (it.hasNext()) {
                ((PolicyInformation)it.next()).encode(policiesOStream);
            }
            signingCertInternal.write((byte)48, policiesOStream);
        }
        DerEncoder[] signingCertSeq = new DerOutputStream[]{new DerOutputStream()};
        signingCertSeq[0].write((byte)48, signingCertInternal);
        DerOutputStream attribute = new DerOutputStream();
        attribute.putOID(this.getObjectIdentifier());
        attribute.putOrderedSetOf((byte)49, signingCertSeq);
        DerOutputStream attribSeq = new DerOutputStream();
        attribSeq.write((byte)48, attribute);
        os.write(attribSeq.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n");
        Iterator<Object> it = this.certIds.iterator();
        while (it.hasNext()) {
            buffer.append(((Object)it.next()).toString());
        }
        if (this.policyInfos != null && this.policyInfos.size() > 0) {
            it = this.policyInfos.iterator();
            while (it.hasNext()) {
                buffer.append(it.next().toString());
            }
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof SigningCertificate) {
            DerValue otherDer;
            DerValue thisDer;
            try {
                DerOutputStream thisOut = new DerOutputStream();
                DerOutputStream otherOut = new DerOutputStream();
                this.encode(thisOut);
                thisDer = new DerValue(thisOut.toByteArray());
                ((SigningCertificate)obj).encode(otherOut);
                otherDer = new DerValue(otherOut.toByteArray());
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16388L, className, "equals", e);
                }
                return false;
            }
            if (!thisDer.equals(otherDer)) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals", new Boolean(false));
                }
                return false;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    private void addCertID(byte[] certHash, SerialNumber sn, GeneralNames issuername) {
        if (this.certIds == null) {
            this.certIds = new ArrayList(5);
        }
        this.certIds.add(new ESSCertID(certHash, sn, issuername));
    }

    private void addPolicyInfo(PolicyInformation policyinfo) {
        if (this.policyInfos == null) {
            this.policyInfos = new ArrayList(5);
        }
        this.policyInfos.add((PolicyInformation)policyinfo.clone());
    }

    public Iterator<PolicyInformation> getPolicyInfos() {
        if (this.policyInfos != null) {
            return this.policyInfos.iterator();
        }
        if (debug != null) {
            debug.text(16384L, className, "getPolicyInfos", "No Policy Infos exist");
        }
        return null;
    }

    public byte[] getVerificationCertificateHash() {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getCertHash();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateHash", "No CertIDs exist");
        }
        return null;
    }

    public SerialNumber getVerificationCertificateSerialNumber() throws IOException {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getSerialNumber();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateSerialNumber", "No CertIDs exist");
        }
        return null;
    }

    public GeneralNames getVerificationCertificateIssuer() {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getIssuer();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateIssuer", "No CertIDs exist");
        }
        return null;
    }

    public boolean isAuthorizationCertificate(X509Certificate cert) throws IOException, NoSuchAlgorithmException, CertificateEncodingException {
        if (this.certIds == null || this.certIds.size() == 0) {
            return false;
        }
        if (this.certIds.size() == 1) {
            return true;
        }
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(cert.getEncoded());
        byte[] certHash = md.digest();
        SerialNumber sn = new SerialNumber(cert.getSerialNumber());
        GeneralNames issuername = new GeneralNames();
        issuername.add(new GeneralName((X500Name)cert.getIssuerDN()));
        for (int i = 1; i < this.certIds.size(); ++i) {
            ESSCertID certId = this.certIds.get(i);
            byte[] currentCertHash = certId.getCertHash();
            if (certHash.length != currentCertHash.length) continue;
            boolean hashMatch = true;
            for (int j = 0; j < certHash.length; ++j) {
                if (certHash[j] == currentCertHash[j]) continue;
                hashMatch = false;
                break;
            }
            boolean issuerMatch = true;
            if (certId.getIssuer() != null && certId.getSerialNumber() != null) {
                boolean bl = issuerMatch = certId.getIssuer().equals(issuername) && certId.getSerialNumber().getNumber().equals(sn.getNumber());
            }
            if (!hashMatch || !issuerMatch) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SigningCertificate result = new SigningCertificate(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        if (elems[0].getTag() != 48) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode", encoding);
            }
            throw new IOException("Bad encoding for signingCertificate");
        }
        DerValue[] certs = elems[0].getData().getSequence(1);
        this.certIds = new ArrayList(certs.length);
        for (int i = 0; i < certs.length; ++i) {
            this.certIds.add(new ESSCertID(certs[i]));
        }
        if (elems[0].getData().available() > 0) {
            DerValue[] policies = elems[0].getData().getSequence(1);
            this.policyInfos = new ArrayList(policies.length);
            for (int i = 0; i < policies.length; ++i) {
                this.policyInfos.add(new PolicyInformation(policies[i].toByteArray()));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", encoding);
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.SIGNING_CERTIFICATE_OID;
    }
}

