/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class MessageDigest
extends PKCS9DerObject
implements Cloneable {
    private byte[] bytes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.LocalKeyId";
    private volatile int cachedHashVal = 0;

    public MessageDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest");
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MessageDigest", provider);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MessageDigest", (Object)der);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", der, provider);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] digest, int dummy) throws IOException {
        this.bytes = (byte[])digest.clone();
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", digest, new Integer(dummy));
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] digest, int dummy, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{digest, new Integer(dummy), provider};
            debug.entry(16384L, (Object)className, "MessageDigest", parms);
        }
        this.bytes = (byte[])digest.clone();
        if (debug != null) {
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", filename, new Boolean(base64));
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "MessageDigest", parms);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            MessageDigest result = new MessageDigest(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (obj instanceof MessageDigest) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((MessageDigest)obj)));
            }
            return this.equals((MessageDigest)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.MESSAGE_DIGEST_OID);
        }
        return PKCSOID.MESSAGE_DIGEST_OID;
    }

    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.bytes == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Byte array not specified.");
            }
            throw new IOException("Byte array not specified.");
        }
        DerOutputStream tmpout = new DerOutputStream();
        DerOutputStream tmpout2 = new DerOutputStream();
        tmpout.putOID(this.getObjectIdentifier());
        tmpout2.putOctetString(this.bytes);
        tmpout.write((byte)49, tmpout2.toByteArray());
        DerOutputStream tmpout3 = new DerOutputStream();
        tmpout3.write((byte)48, tmpout.toByteArray());
        os.write(tmpout3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public synchronized void setData(byte[] bytes) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setData", (Object)bytes);
        }
        if (this.bytes != null) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Message digest byte array already set.");
            }
            throw new PKCSException("Message digest byte array already set.");
        }
        this.bytes = bytes;
        if (debug != null) {
            debug.exit(16384L, className, "setData");
        }
    }

    public byte[] getBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getBytes");
            debug.exit(16384L, (Object)className, "getBytes", this.bytes.clone());
        }
        return (byte[])this.bytes.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getBytes());
        }
        return this.getBytes();
    }

    public boolean isTagValid(byte tag) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(tag));
        }
        if (tag == 4) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "MessageDigest");
        }
        return "MessageDigest";
    }

    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "PKCS9 MessageDigest:\r\n";
        out = this.bytes != null ? out + "\r\n" + hexDump.encodeBuffer(this.bytes) + "\r\n" : out + "null";
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        super.decode(encoding);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        DerValue[] elems = null;
        if (encoding.getTag() == 48) {
            DerInputStream derIn = new DerInputStream(encoding.toByteArray());
            DerValue[] val = derIn.getSequence(2);
            elems = new DerInputStream(val[1].toByteArray()).getSet(1);
        } else {
            elems = new DerInputStream(encoding.toByteArray()).getSet(1);
        }
        this.bytes = new DerInputStream(elems[0].toByteArray()).getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(MessageDigest other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

