/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

public final class SafeContents
extends PKCSDerObject
implements Cloneable {
    private SafeBag[] bags;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.SafeContents";
    private volatile int cachedHashVal = 0;

    public SafeContents(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContents", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(SafeBag[] bags) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SafeContents", bags);
            debug.exit(16384L, className, "SafeContents");
        }
        this.bags = bags;
    }

    public SafeContents(SafeBag[] bags, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", bags, provider);
            debug.exit(16384L, className, "SafeContents");
        }
        this.bags = bags;
    }

    public SafeContents(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "SafeContents", filename, new Boolean(base64));
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public SafeContents(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "SafeContents", parms);
            debug.exit(16384L, className, "SafeContents");
        }
    }

    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.bags != null && this.bags.length != 0) {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].encode(bytes);
            }
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public SafeContents addBags(SafeBag[] inBags) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addBags", inBags);
        }
        SafeContents sc = (SafeContents)this.clone();
        if (inBags == null || inBags.length == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "addBags_1", sc);
            }
            return sc;
        }
        if (sc.bags == null) {
            sc.bags = inBags;
        } else {
            int i;
            int newLength = sc.bags.length + inBags.length;
            SafeBag[] newBags = new SafeBag[newLength];
            for (i = 0; i < sc.bags.length; ++i) {
                newBags[i] = sc.bags[i];
            }
            int j = i;
            int k = 0;
            while (j < newLength) {
                newBags[j] = inBags[k];
                ++j;
                ++k;
            }
            sc.bags = newBags;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addBags_2", sc);
        }
        return sc;
    }

    public SafeBag[] getSafeBags() {
        if (debug != null) {
            debug.entry(16384L, className, "getSafeBags");
            debug.exit(16384L, (Object)className, "getSafeBags", (SafeBag[])this.bags.clone());
        }
        return (SafeBag[])this.bags.clone();
    }

    public ContentInfo protect(int mode) throws IOException, PKCSException {
        ContentInfo cinfo = null;
        DerOutputStream derout = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "protect", new Integer(mode));
        }
        this.encode(derout);
        byte[] encodedBags = derout.toByteArray();
        switch (mode) {
            case 1: {
                cinfo = new ContentInfo(PKCSOID.DATA_OID, encodedBags, this.provider);
                break;
            }
            case 2: {
                ContentInfo cinfo1 = new ContentInfo(PKCSOID.DATA_OID, encodedBags, this.provider);
                EncryptedContentInfo eci = new EncryptedContentInfo(cinfo1, "DES", 56, this.provider);
                EncryptedData ed = new EncryptedData(eci, null, this.provider);
                DerOutputStream derout2 = new DerOutputStream();
                ed.encode(derout2);
                cinfo = new ContentInfo(PKCSOID.ENCRYPTED_DATA_OID, derout2.toByteArray(), this.provider);
                break;
            }
            case 3: {
                if (debug != null) {
                    debug.text(16384L, className, "protect", "Public-key encryption is not supported.");
                }
                throw new IllegalArgumentException("Public-key encryption is not supported.");
            }
            default: {
                if (debug != null) {
                    debug.text(16384L, className, "protect", "Invalid data protection mode.");
                }
                throw new IllegalArgumentException("Invalid data protection mode.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protect", cinfo);
        }
        return cinfo;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            SafeContents retobj = new SafeContents(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (obj == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (obj instanceof SafeContents) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((SafeContents)obj));
            }
            return this.equals((SafeContents)obj);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public String toString() {
        String out = "";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + "SafeContents:\r\n";
        if (this.bags == null || this.bags.length == 0) {
            out = out + "No safe bags";
        } else {
            for (int i = 0; i < this.bags.length; ++i) {
                out = out + "SafeBag[" + i + "]\r\n";
                out = out + this.bags[i].toString();
                out = out + "\r\n";
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    protected void decode(DerValue encoding) throws IOException {
        Vector<SafeBag> bagV = new Vector<SafeBag>();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "SafeContents parsing error, not a SEQUENCE OF");
            }
            throw new IOException("SafeContents parsing error, not a SEQUENCE OF");
        }
        while (encoding.getData().available() != 0) {
            DerValue der = encoding.getData().getDerValue();
            SafeBag sb = new SafeBag(der.toByteArray(), this.provider);
            bagV.add(sb);
        }
        if (bagV.size() > 0) {
            this.bags = new SafeBag[bagV.size()];
            for (int i = 0; i < bagV.size(); ++i) {
                this.bags[i] = (SafeBag)bagV.elementAt(i);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(SafeContents other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

