/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.Util;
import java.io.File;
import java.util.logging.Logger;

public class DumpDescriptor {
    private static final String ZOS_64BIT_DUMP_SECTION_TOKEN = "&DS";
    private static final String ZOS_64BIT_FIRST_DUMP_SECTION = "001";
    private static final String ZOS_64BIT_SECOND_DUMP_SECTION = "002";
    private DumpType dt;
    private File f;
    private String label;
    private boolean jextractRun = false;
    private int jextractRC;
    private File jextractZip;

    public DumpDescriptor(String filename) {
        this(new File(filename));
    }

    public DumpDescriptor(File f) {
        this(f, DumpDescriptor.inferDumpTypeFromFile(f));
    }

    public DumpDescriptor(String label, DumpType dt) {
        this.label = label;
        this.dt = dt;
    }

    public DumpDescriptor(File f, DumpType dt) {
        this.f = f;
        this.dt = dt;
    }

    private static DumpType inferDumpTypeFromFile(File file) {
        if (file == null) {
            return DumpType.UNKNOWN;
        }
        String basename = file.getName();
        if (basename.startsWith("javacore")) {
            return DumpType.JAVA;
        }
        if (basename.startsWith("heapdump")) {
            return DumpType.HEAP;
        }
        if (basename.startsWith("core")) {
            return DumpType.SYSTEM;
        }
        if (basename.startsWith("Snap")) {
            return DumpType.SNAP;
        }
        return DumpType.UNKNOWN;
    }

    public DumpType getDumpType() {
        return this.dt;
    }

    public void setDt(DumpType dt) {
        this.dt = dt;
    }

    public File getFile() {
        return this.f;
    }

    public void setFile(File f) {
        this.f = f;
    }

    public String getFilePath() {
        if (this.f != null) {
            return this.f.getPath();
        }
        return null;
    }

    public boolean isJextractRun() {
        return this.jextractRun;
    }

    public void setJextractRun(boolean jextractRun) {
        this.jextractRun = jextractRun;
    }

    public void setJextractRC(int rc) {
        this.jextractRC = rc;
    }

    public int getJextractRC() {
        return this.jextractRC;
    }

    public void setJextractZip(File jextractZip) {
        this.jextractZip = jextractZip;
    }

    public File getJextractZip() {
        return this.jextractZip;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        if (this.f != null) {
            return this.f.getAbsolutePath();
        }
        if (this.label != null) {
            return this.label.replace(ZOS_64BIT_DUMP_SECTION_TOKEN, ZOS_64BIT_FIRST_DUMP_SECTION);
        }
        return null;
    }

    public boolean exists(Logger logger) {
        if (this.f != null) {
            return this.f.exists();
        }
        if (this.label != null) {
            String dsn = this.label.replace(ZOS_64BIT_DUMP_SECTION_TOKEN, ZOS_64BIT_FIRST_DUMP_SECTION);
            return Util.datasetExists(logger, dsn);
        }
        return false;
    }

    public boolean isSplit(Logger logger) {
        if (this.label != null && this.label.contains(ZOS_64BIT_DUMP_SECTION_TOKEN)) {
            String dsn = this.label.replace(ZOS_64BIT_DUMP_SECTION_TOKEN, ZOS_64BIT_SECOND_DUMP_SECTION);
            return Util.datasetExists(logger, dsn);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DumpType {
        SYSTEM,
        JAVA,
        HEAP,
        SNAP,
        VERBOSEGC,
        UNKNOWN;

    }
}

