/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.DCBlockingCommandRunner;
import com.ibm.java.diagnostics.collector.DCCommandResult;
import com.ibm.java.diagnostics.collector.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AIXSystemDumpSettingsChecker {
    private Logger logger;
    private boolean isAIX;
    private Level reportPriority = Level.CONFIG;
    private StringBuffer report = new StringBuffer();
    private String lineSep;
    private static final String[] LSATTR_FULLCORE = new String[]{"/usr/sbin/lsattr", "-E", "-l", "sys0", "-a", "fullcore", "-F", "value"};
    private static final String[] LSATTR_PRE430CORE = new String[]{"/usr/sbin/lsattr", "-E", "-l", "sys0", "-a", "pre430core", "-F", "value"};

    public AIXSystemDumpSettingsChecker(Logger logger) {
        this.logger = logger;
        String osName = System.getProperty("os.name");
        if (osName != null) {
            this.isAIX = osName.equals("AIX");
        }
        if (this.isAIX && this.report != null) {
            this.lineSep = System.getProperty("line.separator");
            this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.0") + this.lineSep);
            this.initFullCoreReport();
            this.initPre430CoreReport();
        }
    }

    private void initFullCoreReport() {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(LSATTR_FULLCORE));
        DCBlockingCommandRunner lsattr = new DCBlockingCommandRunner(cmd, "lsattr fullcore", false, this.logger);
        DCCommandResult cr = lsattr.runCommand(60, false);
        String stdOut = null;
        if (cr != null && cr.getRc() == 0) {
            stdOut = cr.getStdOut();
        }
        if (stdOut != null && this.report != null) {
            boolean fullcoreTrue = stdOut.startsWith("true");
            if (fullcoreTrue) {
                this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.1") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.2") + this.lineSep);
            } else {
                this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.3") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.4") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.5") + this.lineSep);
                this.reportPriority = Level.WARNING;
            }
        } else {
            this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.11") + this.lineSep);
        }
    }

    private void initPre430CoreReport() {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(LSATTR_PRE430CORE));
        DCBlockingCommandRunner lsattr = new DCBlockingCommandRunner(cmd, "lsattr pre430core", false, this.logger);
        DCCommandResult cr = lsattr.runCommand(60, false);
        String stdOut = null;
        if (cr != null && cr.getRc() == 0) {
            stdOut = cr.getStdOut();
        }
        if (stdOut != null && this.report != null) {
            boolean pre430coreFalse = stdOut.startsWith("false");
            if (pre430coreFalse) {
                this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.6") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.7") + this.lineSep);
            } else {
                this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.8") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.9") + this.lineSep + Messages.getString("AIXSystemDumpSettingsChecker.10") + this.lineSep);
                this.reportPriority = Level.WARNING;
            }
        } else {
            this.report.append(Messages.getString("AIXSystemDumpSettingsChecker.12") + this.lineSep);
        }
    }

    public boolean appliesToPlatform() {
        return this.isAIX;
    }

    public Level getReportPriority() {
        return this.reportPriority;
    }

    public String getReport() {
        if (this.report != null) {
            return this.report.toString();
        }
        return null;
    }
}

