/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Session;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;

public final class SecureRandom
extends SecureRandomSpi {
    private PKCS11Session session;
    static final long serialVersionUID = 8121567603736529455L;

    public SecureRandom() {
        Provider pkcs11Provider = Security.getProvider("IBMPKCS11Impl");
        this.session = ((IBMPKCS11Impl)pkcs11Provider).getSession();
    }

    public SecureRandom(Provider p) {
        this.session = ((IBMPKCS11Impl)p).getSession();
    }

    protected synchronized void engineSetSeed(byte[] seed) {
        this.session.seedRandom(seed, 0, seed.length);
    }

    protected synchronized void engineNextBytes(byte[] bytes) {
        this.session.generateRandom(bytes, 0, bytes.length);
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] bytes = new byte[numBytes];
        this.session.generateRandom(bytes, 0, bytes.length);
        return bytes;
    }
}

