/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithDSA
extends SignatureSpi {
    private Signature sig;
    private byte[] hashData;
    private int count = 0;

    public PKCS11SSLHashingwithDSA(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(17, provider);
        this.hashData = new byte[128];
    }

    public PKCS11SSLHashingwithDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    protected void engineSetParameter(String key, Object param) {
    }

    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom random) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte b) {
        if (this.count + 1 > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        this.hashData[this.count] = b;
        ++this.count;
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (this.count + len > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128 + len];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        System.arraycopy(data, off, this.hashData, this.count, len);
        this.count += len;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] signature = this.sig.engineSign(this.hashData, this.count);
        this.count = 0;
        try {
            byte[] r = new byte[20];
            byte[] s = new byte[20];
            System.arraycopy(signature, 0, r, 0, 20);
            System.arraycopy(signature, 20, s, 0, 20);
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] signingBytes = new byte[40];
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] integers = in.getSequence(2);
            byte[] rPrime = integers[0].getInteger().toByteArray();
            byte[] sPrime = integers[1].getInteger().toByteArray();
            int length = rPrime.length;
            if (length > 20) {
                System.arraycopy(rPrime, length - 20, signingBytes, 0, 20);
            } else {
                System.arraycopy(rPrime, 0, signingBytes, 20 - length, length);
            }
            length = sPrime.length;
            if (length > 20) {
                System.arraycopy(sPrime, length - 20, signingBytes, 20, 20);
            } else {
                System.arraycopy(sPrime, 0, signingBytes, 40 - length, length);
            }
        }
        catch (IOException e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
        boolean rtn = this.sig.engineVerify(signingBytes, this.hashData, this.count);
        this.count = 0;
        return rtn;
    }
}

