/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.MacSpi;

public final class GeneralPKCS11Hmac
extends MacSpi
implements Cloneable {
    private PKCS11Session session = null;
    private MechanismBuilder mechanismBuilder = null;
    private PKCS11SecretKey pkcs11Key = null;
    private static HashMap<String, Integer> MacOutputSizes = new HashMap();

    public GeneralPKCS11Hmac(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.mechanismBuilder = MechanismBuilderImpl.createMechanismBuilder(algorithm, "Mac");
    }

    protected int engineGetMacLength() {
        Integer len = MacOutputSizes.get(this.mechanismBuilder.getAlgorithm());
        return len != null ? len : 0;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec neverUsed) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || !(key instanceof PKCS11SecretKey)) {
            throw new InvalidKeyException("PKCS11 Secret key expected");
        }
        this.pkcs11Key = (PKCS11SecretKey)key;
        this.session.signInit(this.mechanismBuilder.getMechanism(), null, this.pkcs11Key.getObject());
    }

    protected void engineUpdate(byte input) {
        byte[] tempBuffer = new byte[]{input};
        this.session.signUpdate(tempBuffer, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.session.signUpdate(input, offset, len);
    }

    protected byte[] engineDoFinal() {
        byte[] tempBuffer = new byte[this.engineGetMacLength()];
        int outputLen = 0;
        outputLen = this.session.signFinal(tempBuffer, 0);
        byte[] returnVal = new byte[outputLen];
        System.arraycopy(tempBuffer, 0, returnVal, 0, outputLen);
        return returnVal;
    }

    protected void engineReset() {
        this.session.signInit(this.mechanismBuilder.getMechanism(), null, this.pkcs11Key.getObject());
    }

    static {
        MacOutputSizes.put("HmacMD5", new Integer(16));
        MacOutputSizes.put("HmacSHA1", new Integer(20));
        MacOutputSizes.put("HmacSHA256", new Integer(32));
        MacOutputSizes.put("HmacSHA384", new Integer(48));
        MacOutputSizes.put("HmacSHA512", new Integer(64));
    }
}

