/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class GeneralPKCS11Cipher
extends CipherSpi {
    private byte[] iv = null;
    private PKCS11Cipher cipher = null;
    private CipherMechanismBuilder mechanismBuilder;
    private PKCS11Key hw_key_to_delete = null;
    private PKCS11Session session = null;
    private Provider provider = null;
    private Config config = null;
    private static HashMap<String, Integer> BLOCK_SIZES = new HashMap();
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    public GeneralPKCS11Cipher(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.mechanismBuilder = MechanismBuilderImpl.createCipherMechanismBuilder(algorithm);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.mechanismBuilder.setMode(mode);
    }

    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        this.mechanismBuilder.setPadding(paddingScheme);
    }

    protected int engineGetBlockSize() {
        Integer size = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
        if (size == null) {
            return 0;
        }
        return size;
    }

    protected int engineGetOutputSize(int inputLen) {
        if (this.mechanismBuilder.isPadding()) {
            Integer size = BLOCK_SIZES.get(this.mechanismBuilder.getAlgorithm());
            int s = 0;
            if (size != null) {
                s = size;
            }
            int rem = inputLen % s;
            int ret = inputLen - rem;
            ret = rem != 0 ? (ret += s) : inputLen + s;
            return ret;
        }
        return inputLen;
    }

    protected byte[] engineGetIV() {
        return this.iv;
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.iv == null) {
            return null;
        }
        try {
            params = AlgorithmParameters.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        catch (Exception nspe) {
            throw new RuntimeException("IBMPKCS11Impl called, but not configured");
        }
        try {
            params.init(new IvParameterSpec(this.iv));
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("IvParameterSpec not supported");
        }
        return params;
    }

    private PKCS11SecretKey translateToPKCS11SecretKey(Key key) throws InvalidKeyException {
        PKCS11SecretKey tokenKey = null;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (key instanceof PKCS11SecretKey) {
            tokenKey = (PKCS11SecretKey)key;
        } else if (key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase(this.mechanismBuilder.getAlgorithm()) && key.getFormat().equalsIgnoreCase("RAW")) {
            try {
                SecretKeyFactory kf = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
                tokenKey = (PKCS11SecretKey)kf.translateKey((SecretKey)key);
                this.hw_key_to_delete = tokenKey;
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
            }
        } else {
            throw new InvalidKeyException("Key given is not the correct key.");
        }
        return tokenKey;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (!this.mechanismBuilder.isCompatibleOperationMode(opmode, null)) {
            throw new InvalidKeyException("Parameters missing. IV required.");
        }
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralPKCS11Cipher", "engineInit", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
        }
        PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(key);
        if (this.mechanismBuilder.isIVRequired()) {
            this.iv = new byte[this.engineGetBlockSize()];
            random.nextBytes(this.iv);
        }
        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism(), this.session, this.provider);
        this.cipher.engineInit(opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.mechanismBuilder.isCompatibleOperationMode(opmode, params)) {
            throw new InvalidAlgorithmParameterException("IV parameter missing");
        }
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"GeneralPKCS11Cipher", "engineInit", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
        }
        PKCS11SecretKey tokenKey = this.translateToPKCS11SecretKey(key);
        if (this.mechanismBuilder.isIVRequired()) {
            if (params != null) {
                if (!(params instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                this.iv = ((IvParameterSpec)params).getIV();
            } else {
                this.iv = new byte[this.engineGetBlockSize()];
                random.nextBytes(this.iv);
            }
        }
        this.cipher = new PKCS11Cipher(this.mechanismBuilder.getMechanism(), this.session, this.provider);
        this.cipher.engineInit(opmode, tokenKey.getObject(), this.iv, this.engineGetBlockSize());
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = null;
        if (params != null) {
            try {
                ivSpec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.engineUpdate(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] saved_rc = this.cipher.engineDoFinal(input, inputOffset, inputLen);
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int saved_rc = this.cipher.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        SecretKeyFactory factory;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("SecretKey type expected.");
        }
        if (key instanceof PKCS11SecretKey) {
            int len = ((GeneralPKCS11Key)key).getValueLen();
            if (len == 0) {
                byte[] encode = null;
                encode = key.getEncoded();
                if (encode != null) {
                    len = encode.length;
                }
            }
            return len << 3;
        }
        try {
            factory = SecretKeyFactory.getInstance(this.mechanismBuilder.getAlgorithm(), this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException(e);
        }
        SecretKey translatedKey = factory.translateKey((SecretKey)key);
        this.hw_key_to_delete = (PKCS11Key)((Object)translatedKey);
        if (translatedKey instanceof GeneralPKCS11Key) {
            int len = ((GeneralPKCS11Key)translatedKey).getValueLen();
            if (len == 0) {
                byte[] encode = null;
                encode = translatedKey.getEncoded();
                if (encode != null) {
                    len = encode.length;
                }
            }
            if (this.hw_key_to_delete != null) {
                this.hw_key_to_delete.rm();
                this.hw_key_to_delete = null;
            }
            return len << 3;
        }
        int len = translatedKey.getEncoded().length;
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return len << 3;
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        switch (wrappedKeyType) {
            case 3: {
                attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm, this.provider);
                break;
            }
            case 2: {
                attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm, this.provider);
                break;
            }
            case 1: {
                attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm, this.provider);
            }
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int len = ((PKCS11Key)key).getObject().size() + 7;
        byte[] saved_rc = this.cipher.engineWrap(((PKCS11Key)key).getObject(), len);
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, (Object)"GeneralPKCS11Cipher", "finalize");
        }
        if (this.hw_key_to_delete != null) {
            try {
                if (debug != null) {
                    debug.text(16384L, (Object)"GeneralPKCS11Cipher", "finalize", "delete generated hw key");
                }
                this.hw_key_to_delete.rm();
            }
            catch (Exception ex) {
                debug.exception(16384L, (Object)"GeneralPKCS11Cipher", "finalize", (Throwable)ex);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"GeneralPKCS11Cipher", "finalize");
        }
    }

    static {
        BLOCK_SIZES.put("AES", new Integer(16));
        BLOCK_SIZES.put("DES", new Integer(8));
        BLOCK_SIZES.put("DESede", new Integer(8));
    }
}

