/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;

public final class DSAPrivateKey
extends PrivateKeyInfo
implements PKCS11DSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    static final long serialVersionUID = 5036993835514453788L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey";

    DSAPrivateKey(PKCS11Session session, PKCS11Object object, String label, byte[] ID, byte[] subject, Boolean isToken, Boolean isSensitive, Boolean isExtractable) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPrivateKey(...) 2");
        }
        this.session = session;
        this.object = object;
        this.label = label != null ? label : (String)this.getAttrValue(this.object, 3);
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getAttrValue(this.object, 257);
        }
        this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = (Boolean)this.getAttrValue(this.object, 259);
        this.isExtractable = (Boolean)this.getAttrValue(this.object, 354);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getAttrValue(this.object, 512);
        this.authPinFlags = (Integer)this.getAttrValue(this.object, 513);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isSign = (Boolean)this.getAttrValue(this.object, 264);
        this.isSignRecover = (Boolean)this.getAttrValue(this.object, 265);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPrivateKey(...) 2");
        }
    }

    public DSAPrivateKey(PKCS11Session session, PKCS11Object object, String label, byte[] ID, byte[] subject, Boolean isToken, Boolean isSensitive, Boolean isExtractable, BigInteger prime, BigInteger subprime, BigInteger base, BigInteger value) throws InvalidKeyException {
        this(session, object, label, ID, subject, isToken, isSensitive, isExtractable);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPrivateKey(...) 1");
        }
        if (prime != null) {
            this.prime = new BigInteger(prime.toByteArray());
        }
        if (subprime != null) {
            this.subprime = new BigInteger(subprime.toByteArray());
        }
        if (base != null) {
            this.base = new BigInteger(base.toByteArray());
        }
        if (value != null) {
            this.value = new BigInteger(value.toByteArray());
        }
        if (prime != null && subprime != null && base != null) {
            this.algid = new AlgIdDSA(prime, subprime, base);
        }
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode x: " + e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPrivateKey(...) 1");
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public void rm() {
        if (this.object != null) {
            try {
                this.getObject().destroy();
                this.object = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getSecondaryAuth() {
        return new Boolean(this.isSecondaryAuth);
    }

    public Integer getAuthPinFlags() {
        return this.authPinFlags;
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getSignRecover() {
        return new Boolean(this.isSignRecover);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        if (this.isExtractable == null) {
            return null;
        }
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public BigInteger getBase() {
        return this.base;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getX() {
        return this.value;
    }

    public DSAParams getParams() {
        try {
            if (this.algid == null) {
                return null;
            }
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " DSA Private Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            output = output + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            output = output + "\n Subject: " + new String(this.subject);
        }
        if (this.isSensitive != null) {
            output = output + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isSecondaryAuth != null) {
            output = output + "\n SecondaryAuth: " + this.isSecondaryAuth;
        }
        if (this.authPinFlags != null) {
            output = output + "\n AuthPinFlags: " + Integer.toBinaryString(this.authPinFlags);
        }
        if (this.isDecrypt != null) {
            output = output + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            output = output + "\n sign: " + this.isSign;
        }
        if (this.isSignRecover != null) {
            output = output + "\n SignRecover: " + this.isSignRecover;
        }
        if (this.isExtractable != null) {
            output = output + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            output = output + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            output = output + "\n Never Sensitive: " + this.isNeverExtractable;
        }
        if (this.prime != null) {
            output = output + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            output = output + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            output = output + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            output = output + "\n value: " + this.value.toString();
        }
        return output;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DSA";
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    protected void finalize() {
    }
}

