/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PublicKey
implements PKCS11PublicKey,
DHPublicKey,
Serializable {
    private static final long serialVersionUID = 3258135773294114104L;
    private BigInteger y = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private PKCS11Object p11Object = null;
    private static final int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPKCS11PublicKey(BigInteger y, BigInteger p, BigInteger g, PKCS11Session session, Config config) throws InvalidKeyException {
        this.y = y;
        this.p = p;
        this.g = g;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the public key");
        }
        this.importPublicKeyIntoToken(session, config);
    }

    public DHPKCS11PublicKey(PKCS11Object obj) throws InvalidKeyException {
        this.p11Object = obj;
        try {
            this.y = new BigInteger(1, (byte[])this.getAttrValue(this.p11Object, 17));
            this.p = (BigInteger)this.getAttrValue(this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(this.p11Object, 306);
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPKCS11PublicKey(byte[] encodedKey, PKCS11Session session, Config config) throws InvalidKeyException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedKey);
        try {
            DerValue derKeyVal = new DerValue((InputStream)inStream);
            if (derKeyVal.getTag() != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            DerValue algid = derKeyVal.getData().getDerValue();
            if (algid.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInStream = algid.toDerInputStream();
            ObjectIdentifier oid = derInStream.getOID();
            if (derInStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!oid.equals(ObjectIdentifier.newInternal((int[])DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue params = derInStream.getDerValue();
            if (params.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (params.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            params.getData().reset();
            this.p = params.getData().getInteger();
            this.g = params.getData().getInteger();
            if (params.getData().available() != 0) {
                int l = params.getData().getInteger().intValue();
            }
            if (params.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derKeyVal.getData().getBitString();
            this.parseKeyBits();
            if (derKeyVal.getData().available() != 0) {
                throw new InvalidKeyException("Excess key data");
            }
            this.encodedKey = (byte[])encodedKey.clone();
            this.importPublicKeyIntoToken(session, config);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private void importPublicKeyIntoToken(PKCS11Session session, Config config) {
        HashMap<Integer, Object> attribs = new HashMap<Integer, Object>();
        attribs.put(0, PKCS11Object.PUBLIC_KEY);
        attribs.put(256, PKCS11Object.DH);
        attribs.put(304, this.p);
        attribs.put(306, this.g);
        attribs.put(17, this.y.toByteArray());
        attribs.putAll(config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH));
        int[] pubTypes = new int[attribs.size()];
        Object[] pubValues = new Object[attribs.size()];
        Iterator it = attribs.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pubTypes[i] = (Integer)entry.getKey();
            pubValues[i++] = entry.getValue();
        }
        this.p11Object = session.createObject(pubTypes, pubValues);
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream algid = new DerOutputStream();
                algid.putOID(new ObjectIdentifier(DH_data));
                DerOutputStream params = new DerOutputStream();
                params.putInteger(this.p);
                params.putInteger(this.g);
                DerValue paramSequence = new DerValue(48, params.toByteArray());
                algid.putDerValue(paramSequence);
                DerOutputStream tmpDerKey = new DerOutputStream();
                tmpDerKey.write((byte)48, algid);
                tmpDerKey.putBitString(this.key);
                DerOutputStream derKey = new DerOutputStream();
                derKey.write((byte)48, tmpDerKey);
                this.encodedKey = derKey.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("IBMPKCS11 Diffie-Hellman Public Key:\ny:\n" + this.y.toString() + "\n" + "p:\n" + this.p.toString() + "\n" + "g:\n" + this.g.toString());
        return strbuf.toString();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.y = in.getInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public byte[] getSubject() {
        return null;
    }

    public Boolean getEncrypt() {
        return null;
    }

    public Boolean getVerify() {
        return null;
    }

    public void rm() {
        if (this.p11Object != null) {
            try {
                this.getObject().destroy();
                this.p11Object = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    public Boolean getVerifyRecover() {
        return null;
    }

    public Boolean getWrap() {
        return null;
    }

    public PKCS11Session getSession() {
        return this.p11Object.getSession();
    }

    public PKCS11Object getObject() {
        return this.p11Object;
    }

    public Boolean getToken() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 1);
        return new Boolean(val);
    }

    public Boolean getPrivate() {
        return Boolean.FALSE;
    }

    public String getLabel() {
        return (String)this.getAttrValue(this.p11Object, 3);
    }

    public Boolean getModifiable() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 368);
        return new Boolean(val);
    }

    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    public byte[] getID() {
        return (byte[])((byte[])this.getAttrValue(this.p11Object, 258)).clone();
    }

    public Date getStartDate() {
        return null;
    }

    public Date getEndDate() {
        return null;
    }

    public Boolean getDerive() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 268);
        return new Boolean(val);
    }

    public Boolean getLocal() {
        Boolean val = (Boolean)this.getAttrValue(this.p11Object, 355);
        return new Boolean(val);
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            rtn = null;
        }
        return rtn;
    }

    protected void finalize() {
    }
}

