/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import java.util.EventListener;

public class AccessibilityListenerList {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    public int getListenerCount(Class t) {
        int count = 0;
        Object[] lList = this.listenerList;
        int i = 0;
        while (i < lList.length) {
            if (t == (Class)lList[i]) {
                ++count;
            }
            i += 2;
        }
        return count;
    }

    public synchronized void add(Class t, EventListener l) {
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, l};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = l;
            this.listenerList = tmp;
        }
    }

    public synchronized void remove(Class t, EventListener l) {
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener " + l + " is null");
        }
        int index = -1;
        int i = this.listenerList.length - 2;
        while (i >= 0) {
            if (this.listenerList[i] == t && this.listenerList[i + 1] == l) {
                index = i;
                break;
            }
            i -= 2;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 2, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        String s = "EventListenerList: ";
        s = s + lList.length / 2 + " listeners: ";
        int i = 0;
        while (i <= lList.length - 2) {
            s = s + " type " + ((Class)lList[i]).getName();
            s = s + " listener " + lList[i + 1];
            i += 2;
        }
        return s;
    }
}

