/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.objectpool;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.util.objectpool.ObjectDestroyer;
import com.ibm.ws.util.objectpool.ObjectFactory;
import com.ibm.ws.util.objectpool.ObjectPool;

public class LocalThreadObjectPool
implements ObjectPool {
    private Object[] free;
    private ObjectFactory factory;
    private ObjectDestroyer destroyer;
    private long[] timeFreed;
    private QuickApproxTime timer = QuickApproxTime.getRef();
    private int firstEntry;
    private int lastEntry;
    private int maxPoolSize;
    private int poolSize;
    private int putCount = 0;
    private int getCount = 0;
    private int underflowCount = 0;
    private int overflowCount = 0;
    private int minElements = 0;
    private int adjustThreshold = 1000;
    private int minPoolSize;
    private int batchSize;
    private int adjustSize;
    private boolean cleanUpOld = true;
    private static final TraceComponent tc = Tr.register(LocalThreadObjectPool.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");

    public LocalThreadObjectPool(int n, ObjectFactory objectFactory) {
        this.factory = objectFactory;
        this.maxPoolSize = n;
        if (this.maxPoolSize < this.minPoolSize) {
            this.maxPoolSize = this.minPoolSize;
        }
        this.poolSize = this.maxPoolSize;
        this.minPoolSize = this.maxPoolSize / 5;
        this.batchSize = this.minPoolSize / 2;
        this.adjustSize = this.minPoolSize / 2;
        this.free = new Object[this.poolSize];
        this.timeFreed = new long[this.poolSize];
        this.firstEntry = -1;
        this.lastEntry = -1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Object Pool " + this + " created, max size: " + this.maxPoolSize + ", minPoolSize: " + this.minPoolSize);
        }
    }

    public LocalThreadObjectPool(int n, ObjectFactory objectFactory, ObjectDestroyer objectDestroyer) {
        this.factory = objectFactory;
        this.destroyer = objectDestroyer;
        this.maxPoolSize = n;
        if (this.maxPoolSize < this.minPoolSize) {
            this.maxPoolSize = this.minPoolSize;
        }
        this.poolSize = this.maxPoolSize;
        this.minPoolSize = this.maxPoolSize / 5;
        this.batchSize = this.minPoolSize / 2;
        this.adjustSize = this.minPoolSize / 2;
        this.free = new Object[this.poolSize];
        this.timeFreed = new long[this.poolSize];
        this.firstEntry = -1;
        this.lastEntry = -1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Object Pool " + this + " created, max size: " + this.maxPoolSize + ", minPoolSize: " + this.minPoolSize);
        }
    }

    public LocalThreadObjectPool(int n) {
        this(n, null);
    }

    public Object get() {
        Object object = null;
        ++this.getCount;
        if (this.lastEntry > -1) {
            object = this.free[this.lastEntry];
            this.free[this.lastEntry] = null;
            if (this.lastEntry == this.firstEntry) {
                this.lastEntry = -1;
                this.firstEntry = -1;
            } else {
                this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : this.poolSize - 1;
            }
        }
        if (object == null) {
            ++this.underflowCount;
        }
        if (this.getCurrentNumElements() < this.minElements) {
            this.minElements = this.getCurrentNumElements();
        }
        if (this.getCount + this.putCount > this.adjustThreshold) {
            this.adjustPoolSize();
        }
        if (object == null && this.factory != null) {
            object = this.factory.create();
        }
        return object;
    }

    public Object put(Object object) {
        ++this.putCount;
        long l = this.timer.getApproxTime();
        ++this.lastEntry;
        if (this.lastEntry == this.poolSize) {
            this.lastEntry = 0;
        }
        Object object2 = this.free[this.lastEntry];
        this.free[this.lastEntry] = object;
        this.timeFreed[this.lastEntry] = l;
        if (this.lastEntry == this.firstEntry) {
            ++this.firstEntry;
            if (this.firstEntry == this.poolSize) {
                this.firstEntry = 0;
            }
        }
        if (this.firstEntry == -1) {
            this.firstEntry = this.lastEntry;
        }
        if (object2 != null) {
            ++this.overflowCount;
        }
        if (this.cleanUpOld) {
            while (this.firstEntry != this.lastEntry && l > this.timeFreed[this.firstEntry] + 60000L) {
                if (this.destroyer != null && this.free[this.firstEntry] != null) {
                    this.destroyer.destroy(this.free[this.firstEntry]);
                }
                this.free[this.firstEntry] = null;
                ++this.firstEntry;
                if (this.firstEntry != this.poolSize) continue;
                this.firstEntry = 0;
            }
        }
        if (this.getCount + this.putCount > this.adjustThreshold) {
            this.adjustPoolSize();
        }
        return object2;
    }

    public void setCleanUpOld(boolean bl) {
        this.cleanUpOld = bl;
    }

    protected Object[] getBatch() {
        Object[] objectArray = new Object[this.batchSize];
        objectArray[0] = this.get();
        for (int i = 1; this.getCurrentNumElements() > this.minPoolSize / 2 && i < this.batchSize; ++i) {
            objectArray[i] = this.get();
        }
        return objectArray;
    }

    protected void putBatch(Object[] objectArray) {
        for (int i = 0; i < objectArray.length && objectArray[i] != null; ++i) {
            this.put(objectArray[i]);
        }
    }

    private int getCurrentNumElements() {
        if (this.lastEntry == -1) {
            return 0;
        }
        if (this.lastEntry >= this.firstEntry) {
            return this.lastEntry - this.firstEntry + 1;
        }
        return this.lastEntry + 1 + (this.poolSize - this.firstEntry);
    }

    protected Object[] purge() {
        Object[] objectArray = new Object[this.getCurrentNumElements()];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "LocalPool is purging " + objectArray.length + " items");
        }
        if (0 < objectArray.length) {
            int n = 0;
            for (int i = 0; i < this.poolSize; ++i) {
                if (null == this.free[i]) continue;
                objectArray[n] = this.free[i];
                this.free[i] = null;
                ++n;
            }
            this.lastEntry = -1;
            this.firstEntry = -1;
        }
        return objectArray;
    }

    private void adjustPoolSize() {
        int n = this.poolSize;
        if (this.underflowCount == 0 && this.minElements > this.minPoolSize / 2 && this.poolSize > this.minPoolSize) {
            this.poolSize = this.poolSize - this.minPoolSize > this.adjustSize * 2 ? (this.poolSize - this.minPoolSize) / 2 + this.minPoolSize : (this.poolSize -= this.adjustSize);
            if (this.poolSize < this.minPoolSize) {
                this.poolSize = this.minPoolSize;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Object Pool " + this + " reduced, old size: " + n + " new pool size: " + this.poolSize);
            }
            while (n > this.poolSize) {
                if (this.destroyer != null && this.free[n - 1] != null) {
                    this.destroyer.destroy(this.free[n - 1]);
                }
                this.free[n - 1] = null;
                if (this.lastEntry == n - 1) {
                    --this.lastEntry;
                }
                if (this.firstEntry == n - 1) {
                    --this.firstEntry;
                }
                --n;
            }
        } else if (this.underflowCount > 0 && this.overflowCount > 0 && this.poolSize < this.maxPoolSize) {
            this.poolSize += this.adjustSize;
            if (this.poolSize > this.maxPoolSize) {
                this.poolSize = this.maxPoolSize;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Object Pool " + this + " enlarged, old size: " + n + " new pool size: " + this.poolSize);
            }
            if (this.firstEntry > this.lastEntry) {
                while (n < this.poolSize) {
                    if (this.firstEntry > this.lastEntry) {
                        if (this.destroyer != null && this.free[n - 1] != null) {
                            this.destroyer.destroy(this.free[n - 1]);
                        }
                        this.free[n - 1] = this.free[this.lastEntry];
                        this.free[this.lastEntry] = null;
                        this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : n - 1;
                    }
                    ++n;
                }
            }
        }
        this.minElements = this.getCurrentNumElements();
        this.getCount = 0;
        this.putCount = 0;
        this.underflowCount = 0;
        this.overflowCount = 0;
    }
}

