/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class NBAcceptChannelSelector
extends ChannelSelector
implements TCPConfigConstants,
TCPChannelMessageConstants {
    private static final TraceComponent tc = Tr.register(NBAcceptChannelSelector.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector";
    protected int usageCount = 0;
    private int selectorTimeout = TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
    protected int numExceptions = 0;
    private long firstErrorTime = 0L;
    private int numAcceptIOExceptions = 0;
    private int numAcceptNulls = 0;
    private int numConfigureIOExceptions = 0;
    private int numCancelledKeys = 0;

    public NBAcceptChannelSelector(boolean bl) throws IOException {
        super(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWork(Object object) {
        TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
        synchronized (tCPChannelLinkedList) {
            this.ourWorkQueue.add(object);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelector() {
        boolean bl = true;
        NBAccept.EndPointActionInfo endPointActionInfo = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "updateSelector - processing " + this.ourWorkQueue.size() + " items");
        }
        while (bl) {
            Object object;
            block23: {
                object = this.ourWorkQueue;
                synchronized (object) {
                    if (this.ourWorkQueue.isEmpty()) {
                        break;
                    }
                    endPointActionInfo = (NBAccept.EndPointActionInfo)this.ourWorkQueue.removeFirst();
                }
                if (endPointActionInfo.action == 1) {
                    block22: {
                        try {
                            object = endPointActionInfo.endPoint.getServerSocket();
                            ((ServerSocket)object).getChannel().configureBlocking(false);
                            try {
                                ((ServerSocket)object).getChannel().register(this.selector, 16, endPointActionInfo.endPoint);
                                ++this.usageCount;
                            }
                            catch (ClosedChannelException closedChannelException) {
                                FFDCFilter.processException((Throwable)closedChannelException, CLASS_NAME, "100", this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Caught ClosedChannelException while registering a TCPPort, port number: " + endPointActionInfo.endPoint.getListenPort());
                                }
                            }
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "101", this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block22;
                            Tr.event(tc, "Caught IOException while registering a TCPPort.");
                        }
                    }
                    object = endPointActionInfo.syncObject;
                    synchronized (object) {
                        endPointActionInfo.syncObject.notify();
                        continue;
                    }
                }
                if (endPointActionInfo.action != 0) continue;
                try {
                    object = endPointActionInfo.endPoint.getServerSocket();
                    ((ServerSocket)object).getChannel().keyFor(this.selector).cancel();
                    this.selector.selectNow();
                    --this.usageCount;
                    if (this.usageCount <= 0) {
                        this.shutDown();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "102", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                    Tr.event(tc, "Caught IOException while removing a TCPPort.");
                }
            }
            object = endPointActionInfo.syncObject;
            synchronized (object) {
                endPointActionInfo.syncObject.notify();
            }
        }
        if (endPointActionInfo != null) {
            this.selector.wakeup();
        }
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    protected void channelSelectorClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void incrementExceptions() {
        long l = System.currentTimeMillis();
        if (l - this.firstErrorTime >= 600000L) {
            this.numExceptions = 1;
            this.firstErrorTime = l;
            this.numAcceptIOExceptions = 0;
            this.numAcceptNulls = 0;
            this.numCancelledKeys = 0;
            this.numConfigureIOExceptions = 0;
        } else {
            ++this.numExceptions;
        }
    }

    private void resetExceptions() {
        this.numExceptions = 0;
        this.firstErrorTime = 0L;
        this.numAcceptIOExceptions = 0;
        this.numAcceptNulls = 0;
        this.numCancelledKeys = 0;
        this.numConfigureIOExceptions = 0;
    }

    protected boolean performRequest() {
        SocketChannel socketChannel = null;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "performRequest - processing " + set.size() + " items");
        }
        while (iterator.hasNext()) {
            Object object;
            if (this.numExceptions >= 200) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SelectionKey selectionKey = iterator.next();
            TCPPort tCPPort = (TCPPort)selectionKey.attachment();
            TCPChannel tCPChannel = tCPPort.getTCPChannel();
            if (this.numExceptions == 1500) {
                FFDCFilter.processException((Throwable)new Exception("TCP channel has received 1500 exceptions in a row on the accept selector"), CLASS_NAME, "101", this);
            } else if (this.numExceptions >= 3100) {
                object = new ChannelException("TCP Channel detected continuous exceptions while trying to accept connections and is terminating on thread: " + Thread.currentThread().getName());
                FFDCFilter.processException((Throwable)object, CLASS_NAME, "207", this);
                Tr.audit(tc, "PORT_NOT_ACCEPTING", new Object[]{tCPChannel.getExternalName(), tCPChannel.getDisplayableHostName(), String.valueOf(tCPPort.getListenPort())});
                System.exit(10);
            }
            try {
                block17: {
                    iterator.remove();
                    object = (ServerSocketChannel)selectionKey.channel();
                    try {
                        socketChannel = ((ServerSocketChannel)object).accept();
                        if (socketChannel == null) break block17;
                        socketChannel.configureBlocking(false);
                    }
                    catch (IOException iOException) {
                        this.incrementExceptions();
                        ++this.numAcceptIOExceptions;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                        Tr.event(tc, "TCP Channel: " + tCPChannel.getExternalName() + " caught IOException doing accept: " + iOException + " total=" + this.numExceptions + " count=" + this.numAcceptIOExceptions);
                        continue;
                    }
                }
                if (socketChannel == null) {
                    this.incrementExceptions();
                    ++this.numAcceptNulls;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "TCP Channel: " + tCPChannel.getExternalName() + " serverSocketChannel.accept() returned null, total=" + this.numExceptions + " count=" + this.numAcceptNulls);
                    continue;
                }
                Socket socket = socketChannel.socket();
                if (!this.testSocket(socketChannel)) continue;
                boolean bl = tCPChannel.verifyConnection(socket);
                if (!bl) {
                    this.closeSocketChannel(socketChannel);
                    this.resetExceptions();
                    continue;
                }
                SocketIOChannel socketIOChannel = null;
                try {
                    socketIOChannel = tCPChannel.createInboundSocketIOChannel(socketChannel);
                }
                catch (IOException iOException) {
                    this.incrementExceptions();
                    ++this.numConfigureIOExceptions;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "IOException caught while configuring socket: " + iOException + ", total=" + this.numExceptions + " count=" + this.numConfigureIOExceptions);
                    }
                    this.closeSocketChannel(socketChannel);
                    continue;
                }
                tCPPort.processNewConnection(socketIOChannel);
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.incrementExceptions();
                ++this.numCancelledKeys;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event(tc, "Cancelled key exception found, cke=" + cancelledKeyException + " total=" + this.numExceptions + " count=" + this.numCancelledKeys);
                continue;
            }
            this.resetExceptions();
        }
        return false;
    }

    private void closeSocketChannel(SocketChannel socketChannel) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                try {
                    Tr.event(tc, "Closing connection, local: " + socketChannel.socket().getLocalSocketAddress() + " remote: " + socketChannel.socket().getRemoteSocketAddress());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                Tr.event(tc, "IOException caught while closing connection " + iOException);
            }
        }
    }

    private boolean testSocket(SocketChannel socketChannel) {
        try {
            socketChannel.socket().getLocalPort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "SocketChannel accepted, local: " + socketChannel.socket().getLocalSocketAddress() + " remote: " + socketChannel.socket().getRemoteSocketAddress());
            }
        }
        catch (Throwable throwable) {
            block6: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Closing invalid socket (getLocalPort failure)");
                }
                try {
                    socketChannel.close();
                }
                catch (Throwable throwable2) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event(tc, "Error caught while closing connection " + throwable2);
                }
            }
            this.resetExceptions();
            return false;
        }
        return true;
    }

    protected void checkForTimeouts() {
        this.nextTimeoutTime = this.currentTime + (long)this.selectorTimeout;
    }

    void updateCount() {
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("\n  selectorTimeout: " + this.selectorTimeout);
        stringBuffer.append("\n  usageCount: " + this.usageCount);
        stringBuffer.append("\n  quit: " + this.quit);
        stringBuffer.append("\n  waitingToQuit: " + this.waitingToQuit);
        stringBuffer.append("\n  firstErrorTime: " + this.firstErrorTime + "=" + new Date(this.firstErrorTime));
        stringBuffer.append("\n  Total exceptions: " + this.numExceptions);
        stringBuffer.append("\n\tIOExceptions on accept: " + this.numAcceptIOExceptions);
        stringBuffer.append("\n\tnull sockets on accept: " + this.numAcceptNulls);
        stringBuffer.append("\n\tIOExceptions on configure: " + this.numConfigureIOExceptions);
        stringBuffer.append("\n\tnumber of cancelled keys: " + this.numCancelledKeys);
        stringBuffer.append("\n# of keys=" + this.selector.keys().size());
        try {
            Object[] objectArray = this.selector.keys().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                SelectionKey selectionKey = (SelectionKey)objectArray[i];
                stringBuffer.append("\nkey: " + selectionKey.channel());
            }
        }
        catch (Exception exception) {
            stringBuffer.append("\nException Occurred Gathering Dump Data: " + exception);
        }
        return stringBuffer.toString();
    }
}

