/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.util.Issue;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.ranges.FreeRange;
import com.ibm.rmi.util.ranges.RangeSetHolder;
import com.ibm.rmi.util.ranges.Ranges;
import java.util.ArrayList;

public final class Interop
extends PartnerVersionUtil {
    private static final String CLASS = Interop.class.getName();
    public static final Interop NO_IBM_ORB = new Interop();
    private static final byte PARTNER_IGNORES_ISSUE = 1;
    private static final byte PARTNER_ENABLES_ISSUE = 2;
    private static final byte PARTNER_ADHERES_TO_SPEC = 4;
    private static final byte UNSET = -128;
    private static final byte NEVER = 0;
    private static final byte OFF = 2;
    private static final byte RARELY = 4;
    private static final byte ON = 6;
    private static final byte ALWAYS = 7;
    private final PartnerVersion partnerVersion;
    public final Issue omg4591;
    public final Issue useAlternativeRepIDEncoding;
    ArrayList standardIssues = new ArrayList();
    private final ORB orb;

    public Interop(ORB oRB) {
        this(oRB, false, null);
    }

    private Interop() {
        this(null, true, PartnerVersion.UNKNOWN);
    }

    private Interop(Interop interop, PartnerVersion partnerVersion) {
        this.orb = interop.orb;
        this.partnerVersion = partnerVersion;
        this.omg4591 = this.copyIssue(interop.omg4591);
        this.useAlternativeRepIDEncoding = this.copyIssue(interop.useAlternativeRepIDEncoding);
    }

    private Interop(ORB oRB, boolean bl, PartnerVersion partnerVersion) {
        if (oRB == null && !bl) {
            throw new IllegalArgumentException("orb parameter to Interop constructor must not be null - use Interop.NO_ORB");
        }
        this.orb = oRB;
        this.partnerVersion = partnerVersion;
        this.omg4591 = this.createIssue("com.ibm.CORBA.UseOMG4591", Interop.defaultTo((byte)2), this.ranging().from(5376, 0).onwards());
        this.useAlternativeRepIDEncoding = this.createIssue("com.ibm.CORBA.UseAlternativeRepIDEncoding", Interop.defaultTo((byte)2), Ranges.EMPTY);
    }

    public Interop createPartnerSpecificInterop(PartnerVersion partnerVersion) {
        Interop interop = new Interop(this, partnerVersion);
        return interop;
    }

    public final Issue createIssue(String string, Object object, RangeSetHolder rangeSetHolder) {
        StandardIssue standardIssue = new StandardIssue(string, object, rangeSetHolder);
        this.standardIssues.add(standardIssue);
        return standardIssue;
    }

    public Issue copyIssue(Issue issue) {
        StandardIssue standardIssue = new StandardIssue((StandardIssue)issue);
        return standardIssue;
    }

    public final void readProperties() {
        int n = this.standardIssues.size();
        for (int i = 0; i < n; ++i) {
            ((StandardIssue)this.standardIssues.get(i)).readSetting();
        }
    }

    private final FreeRange ranging() {
        return Ranges.buildRangeSet();
    }

    private static byte getExpectedPartnerBehaviourForIssue(int n, int n2, int[] nArray) {
        if (n == 0) {
            return 4;
        }
        boolean bl = Ranges.contains(nArray, n, n2);
        if (bl) {
            return 2;
        }
        return 1;
    }

    private static byte retrieveSettingFromDefault(Object object) {
        try {
            return (Byte)object;
        }
        catch (Exception exception) {
            return -128;
        }
    }

    private static boolean isValidSetting(byte by) {
        return 0 <= by & by <= 7;
    }

    private static Object defaultTo(byte by) {
        return new Byte(by);
    }

    private static String stringify(byte by) {
        switch (by) {
            case -128: {
                return "UNSET";
            }
            case 0: {
                return "NEVER";
            }
            case 2: {
                return "OFF";
            }
            case 4: {
                return "RARELY";
            }
            case 6: {
                return "ON";
            }
            case 7: {
                return "ALWAYS";
            }
        }
        return Integer.toHexString(0xFF & by);
    }

    private byte getByte(String string) {
        int n;
        String string2 = null;
        if (this.orb != null && (string2 = this.orb.getProperty(string)) != null) {
            string2 = string2.toUpperCase();
        }
        if (string2 == null || string2.length() == 0) {
            n = -128;
        } else if (string2.equals("NEVER")) {
            n = 0;
        } else if (string2.equals("OFF")) {
            n = 2;
        } else if (string2.equals("RARELY")) {
            n = 4;
        } else if (string2.equals("ON")) {
            n = 6;
        } else if (string2.equals("ALWAYS")) {
            n = 7;
        } else {
            try {
                n = Byte.valueOf(string2).byteValue();
            }
            catch (NumberFormatException numberFormatException) {
                Trc.ffdc(numberFormatException, CLASS, "getByte:369");
                Trc.ffdc("Invalid value for ORB property: " + string + "=" + string2, CLASS, "getByte:370");
                n = -128;
            }
        }
        return (byte)n;
    }

    private final class StandardIssue
    implements Issue {
        private int[] versionBoundaries;
        private byte setting;
        private String name;

        StandardIssue(String string, Object object, RangeSetHolder rangeSetHolder) {
            this.name = string;
            if (rangeSetHolder == null) {
                throw new IllegalArgumentException("RangeSetHolder must not be null; use Ranges.EMPTY");
            }
            if (object == null) {
                throw new IllegalArgumentException("default setting must not be null");
            }
            byte by = Interop.retrieveSettingFromDefault(object);
            if (!Interop.isValidSetting(by)) {
                throw new IllegalArgumentException("invalid default setting: " + object);
            }
            this.setting = by;
            this.versionBoundaries = rangeSetHolder.getRangeSet();
        }

        StandardIssue(StandardIssue standardIssue) {
            this.versionBoundaries = standardIssue.versionBoundaries;
            this.setting = standardIssue.setting;
            this.name = standardIssue.name;
        }

        public final boolean inUse() {
            short s;
            short s2 = Interop.this.partnerVersion.getPartnerMajor();
            byte by = Interop.getExpectedPartnerBehaviourForIssue(s2, s = Interop.this.partnerVersion.getPartnerMinor(), this.versionBoundaries);
            return (this.setting & by) != 0;
        }

        private void readSetting() {
            byte by = this.setting;
            byte by2 = Interop.this.getByte(this.name);
            if (!Interop.isValidSetting(by2)) {
                if (by2 != -128) {
                    Trc.ffdc("Invalid ORB prop: " + this.name + "=" + by2, CLASS, "initializeSetting:444");
                }
                by2 = by;
            }
            this.setting = by2;
            if (Trc.enabled()) {
                Trc.info("ORB interop setting: ", this.name, " setting=", Interop.stringify(this.setting), " and rangeset=", Ranges.stringify(this.versionBoundaries), CLASS, "initializeSetting:454");
            }
        }
    }
}

