/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.map.Cache;
import com.ibm.jtc.orb.map.CacheFactories;
import com.ibm.jtc.orb.map.MapFactories;
import com.ibm.jtc.orb.map.ObjectFactory;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ClassCache
implements Cache {
    private static final ClassCache INSTANCE = new ClassCache();
    private static final Object MISS = CacheMiss.INSTANCE;
    private static final String CLASS = ClassCache.class.getName();
    private final Cache nullCache = PlainCacheFactory.INSTANCE.create();
    private final Cache cacheCache = CacheFactories.SOFT.create(MapFactories.WEAK, PlainCacheFactory.INSTANCE);

    public static Class get(String string, ClassLoader classLoader) {
        return INSTANCE.getClass(string, classLoader);
    }

    public static Class get(String string, String string2) {
        return INSTANCE.getClass(string, string2);
    }

    private ClassCache() {
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray[1] instanceof String) {
            return this.getClass((String)objectArray[0], (String)objectArray[1]);
        }
        return this.getClass((String)objectArray[0], (ClassLoader)objectArray[1]);
    }

    public boolean isEmpty() {
        return this.cacheCache.isEmpty() && this.nullCache.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class getClass(String string, ClassLoader classLoader) {
        Cache cache = this.getLoaderCache(classLoader);
        Object object = cache.get(string);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    object = futureEntry.get(this.loadClass(string, classLoader));
                    if (null != classLoader) {
                        if (MISS == object) {
                            this.addMiss(string, classLoader.getParent());
                        } else {
                            ClassLoader classLoader2 = ((Class)object).getClassLoader();
                            if (classLoader2 != classLoader) {
                                this.addHit(string, object, classLoader2, classLoader.getParent());
                            }
                            if (null != classLoader2) {
                                this.addMiss(string, classLoader2.getParent());
                            }
                        }
                    }
                }
            }
        }
        if (MISS == object) {
            object = null;
        }
        return (Class)object;
    }

    final Class getClass(final String string, final String string2) {
        Object var4_3 = null;
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){
            Class cl = null;

            public Object run() {
                block4: {
                    try {
                        this.cl = RMIClassLoader.loadClass(string2, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Trc.ffdc(malformedURLException, CLASS, "getClass:133");
                    }
                    catch (NullPointerException nullPointerException) {
                        Trc.ffdc(nullPointerException, CLASS, "getClass:135");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!Trc.enabled()) break block4;
                        Trc.info(CLASS, "ClassNotFoundException in RMIClassLoader.loadClass");
                    }
                }
                return this.cl;
            }
        });
        return clazz;
    }

    private Object loadClass(String string, ClassLoader classLoader) {
        Class<?> clazz = MISS;
        try {
            clazz = Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {
            if (Trc.enabled()) {
                Trc.info(string, "cannot be found", CLASS, "loadClass:158");
            }
        }
        catch (LinkageError linkageError) {
            String string2 = linkageError.toString();
            Trc.ffdc(string2, CLASS, "loadClass:161");
        }
        return clazz;
    }

    private Cache getLoaderCache(ClassLoader classLoader) {
        return null == classLoader ? this.nullCache : (Cache)this.cacheCache.get(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMiss(String string, ClassLoader classLoader) {
        Cache cache = this.getLoaderCache(classLoader);
        Object object = cache.get(string);
        if (object instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object;
            synchronized (futureEntry2) {
                object = futureEntry.get();
                if (null == object) {
                    object = futureEntry.get(MISS);
                    if (null != classLoader) {
                        this.addMiss(string, classLoader.getParent());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHit(String string, Object object, ClassLoader classLoader, ClassLoader classLoader2) {
        Cache cache = this.getLoaderCache(classLoader2);
        Object object2 = cache.get(string);
        if (object2 instanceof Cache.FutureEntry) {
            Cache.FutureEntry futureEntry;
            Cache.FutureEntry futureEntry2 = futureEntry = (Cache.FutureEntry)object2;
            synchronized (futureEntry2) {
                object2 = futureEntry.get();
                if (null == object2) {
                    object2 = futureEntry.get(object);
                    if (classLoader != classLoader2 && null != classLoader2) {
                        this.addHit(string, object, classLoader, classLoader2.getParent());
                    }
                }
            }
        }
    }

    private static final class PlainCacheFactory
    implements ObjectFactory {
        public static final PlainCacheFactory INSTANCE = new PlainCacheFactory();

        private PlainCacheFactory() {
        }

        public final Cache create() {
            return CacheFactories.PLAIN.create(MapFactories.HASH);
        }
    }

    private static final class CacheMiss {
        static final Object INSTANCE = new CacheMiss();

        private CacheMiss() {
        }
    }
}

