/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ListenerThread
extends com.ibm.CORBA.transport.ListenerThread {
    private static final String CLASS = ListenerThread.class.getName();
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerSocket serverSocket;
    protected int acceptTimeout;
    protected ConnectionTable connectionTable;
    protected boolean bKeepAlive;
    protected TransportBase transportBase = null;
    static int instanceCounter = 0;
    int thisInstanceNumber;

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, String string, TransportBase transportBase) {
        this(connectionTable, serverSocket, 0, false, string, transportBase);
    }

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, int n, boolean bl, String string, TransportBase transportBase) {
        super(string);
        if (Trc.enabled()) {
            Trc.begin1("serverSocket=" + serverSocket + " timeout=" + n, CLASS, "<init>:101");
        }
        this.serverSocket = serverSocket;
        this.acceptTimeout = n;
        this.bKeepAlive = bl;
        this.connectionTable = connectionTable;
        this.thisInstanceNumber = instanceCounter++;
        this.transportBase = transportBase;
        if (Trc.enabled()) {
            Trc.complete(CLASS, "<init>:111");
        }
    }

    public void run() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "run:121");
        }
        final String string = "LT=" + this.thisInstanceNumber + ":" + this.getName();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ListenerThread.this.setName(string);
                return null;
            }
        });
        int n = 0;
        try {
            this.serverSocket.setSoTimeout(this.acceptTimeout);
        }
        catch (SocketException socketException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "run:155", (Exception)socketException);
        }
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    block16: {
                        socket = this.serverSocket.accept();
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:177", Utility.getMessage("ListenerThread.acceptSocket", socket.toString()));
                        }
                        try {
                            socket.setTcpNoDelay(true);
                            if (this.bKeepAlive) {
                                socket.setKeepAlive(true);
                            }
                        }
                        catch (Exception exception) {
                            if (!ORBRas.isTrcLogging) break block16;
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:194", exception.toString());
                        }
                    }
                    this.transportBase.createTransportConnection(socket, this);
                    n = 0;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.isShutdownPending()) continue;
                if (!ORBRas.isTrcLogging) break;
                ORBRas.orbTrcLogger.trace(8208L, this, "run:212", "accept interrupted with shutdown pending");
            }
            catch (SocketException socketException) {
                if (this.isShutdownPending()) {
                    if (!ORBRas.isTrcLogging) break;
                    ORBRas.orbTrcLogger.trace(8208L, this, "run:227", socketException.getMessage() + " with shutdown pending");
                    break;
                }
                ORBRas.orbTrcLogger.exception(4104L, this, "run:234", (Exception)socketException);
                if (n == 5 || !this.connectionTable.cleanUp()) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "run:257", exception);
                continue;
            }
            break;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "run:265", "ListenerThread shutting down");
        }
        this.connectionTable.cleanUp();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "run:277");
        }
    }

    public void setShutdownPending(boolean bl) {
        super.setShutdownPending(bl);
        if (bl) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "setShutdownPending:295", (Exception)iOException);
            }
        }
    }
}

