/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.Profile;
import com.ibm.rmi.channel.IIOPChannelPluginImpl;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportInterface;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class TransportService
implements ORBForTransports,
TransportInterface {
    private static final String CLASS = TransportService.class.getName();
    private static ChannelFramework channelFramework = null;
    private static Object initChainLock = new Object();
    private String chainGroupName = null;
    private ORB theORB;
    private Profile serverProfile = null;
    private IIOPChannelPlugin iiopChannelPlugin = null;
    private GIOPConnectionTable connTable;
    private int inboundORBChannelCount = 0;

    public TransportService(ORB oRB, GIOPImpl gIOPImpl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:115");
        }
        this.theORB = oRB;
        this.iiopChannelPlugin = (IIOPChannelPlugin)oRB.getPlugin(IIOPChannelPlugin.class.getName());
        channelFramework = this.iiopChannelPlugin.getChannelFramework();
        this.connTable = new GIOPConnectionTable(oRB);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:125", (Object)(this.iiopChannelPlugin + " CFW:" + (channelFramework == null ? "null" : "not null")));
        }
    }

    public ChannelFramework getChannelFramework() {
        return this.iiopChannelPlugin.getChannelFramework();
    }

    public int getConnectTimeout() {
        return this.theORB.getConnectTimeout();
    }

    public Connection get(Profile profile, ClientSubcontract clientSubcontract, String string) {
        return null;
    }

    public Connection get(Profile profile, ClientDelegate clientDelegate, String string) {
        return null;
    }

    public Connection getConnection(IOR iOR, ClientDelegate clientDelegate, String string) {
        if (Trc.enabled()) {
            Trc.begin2(iOR, clientDelegate, CLASS, "getConnection:163");
        }
        ConnectionKeyGenerator connectionKeyGenerator = this.iiopChannelPlugin.getConnectionKeyGenerator(iOR, clientDelegate, string);
        if (Trc.enabled()) {
            Trc.info(connectionKeyGenerator, CLASS, "getConnection:172");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4096L, (Object)this, "getConnection:177", "key generator ", (Object)connectionKeyGenerator);
        }
        Connection connection = null;
        GIOPConnectionKey gIOPConnectionKey = connectionKeyGenerator.getNextKey();
        try {
            boolean bl = true;
            while (bl) {
                Object object;
                VirtualConnectionFactory virtualConnectionFactory;
                if (Trc.enabled()) {
                    Trc.info(gIOPConnectionKey, CLASS, "getConnection:191");
                }
                if ((virtualConnectionFactory = gIOPConnectionKey.getVirtualConnectionFactory()) == null) {
                    object = new IOException("Outbound channel chain may not have been initialized");
                    Trc.ffdc((Exception)object, CLASS, "getConnection:200");
                    throw object;
                }
                object = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
                Map map = object.getStateMap();
                map.put("ORB", this.theORB);
                try {
                    object.connect((Object)gIOPConnectionKey);
                    connection = (Connection)map.get("Connection");
                    bl = false;
                }
                catch (Exception exception) {
                    GIOPConnectionKey gIOPConnectionKey2 = connectionKeyGenerator.getNextKey();
                    if (gIOPConnectionKey2 == null) {
                        throw exception;
                    }
                    gIOPConnectionKey = gIOPConnectionKey2;
                }
            }
        }
        catch (Exception exception) {
            if (Trc.enabled()) {
                Trc.warn(exception, CLASS, "getConnection:242");
            }
            if (exception instanceof SystemException) {
                throw (SystemException)((Object)exception);
            }
            TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":host=" + gIOPConnectionKey.getRemoteHost() + ",port=" + gIOPConnectionKey.getRemotePort(), 1229127170, CompletionStatus.COMPLETED_NO);
            tRANSIENT.initCause((Throwable)exception);
            throw tRANSIENT;
        }
        if (Trc.enabled()) {
            Trc.complete(connection, CLASS, "getConnection:259");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTransports() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "initTransports:275");
        }
        String string = this.theORB.getORBServerHost();
        int n = this.theORB.getListenerPort();
        Object object = initChainLock;
        synchronized (object) {
            block16: {
                if (this.serverProfile != null) {
                    return;
                }
                if (this.iiopChannelPlugin instanceof IIOPChannelPluginImpl) {
                    ((IIOPChannelPluginImpl)this.iiopChannelPlugin).initTCPChainGroup(string, n);
                }
                this.chainGroupName = this.iiopChannelPlugin.getChainGroupName();
                if (this.chainGroupName == null) {
                    this.serverProfile = new Profile(this.theORB, string, n, null);
                    if (Trc.enabled()) {
                        Trc.info(this.iiopChannelPlugin, ": null chainGroupName", CLASS, "initTransports:310");
                    }
                    return;
                }
                try {
                    ChainGroupData chainGroupData = channelFramework.getChainGroup(this.chainGroupName);
                    if (chainGroupData == null) {
                        this.serverProfile = new Profile(this.theORB, string, n, null);
                        Trc.ffdc("Chain Group " + this.chainGroupName + " not found in ChannelFramework", CLASS, "initTransports:325");
                        return;
                    }
                    ChainData[] chainDataArray = chainGroupData.getChains();
                    this.setORBConfigForChainGroup(chainDataArray, n);
                    if (n == 0) {
                        ChainEnquirer chainEnquirer;
                        ChainEnquirer chainEnquirer2 = chainEnquirer = new ChainEnquirer(channelFramework, chainDataArray[0].getName());
                        synchronized (chainEnquirer2) {
                            channelFramework.startChainGroup(this.chainGroupName);
                            n = chainEnquirer.getListenerPort();
                            break block16;
                        }
                    }
                    channelFramework.startChainGroup(this.chainGroupName);
                }
                catch (Exception exception) {
                    Trc.ffdc(exception, CLASS, "initTransports:345");
                    INTERNAL iNTERNAL = new INTERNAL(exception.toString(), 1229125000, CompletionStatus.COMPLETED_NO);
                    iNTERNAL.initCause((Throwable)exception);
                    throw iNTERNAL;
                }
            }
            this.serverProfile = new Profile(this.theORB, string, n, null);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "initTransports:361", (Object)("serverHost=" + string + " serverPort=" + n + " listeningPort=" + n));
        }
    }

    public Profile getServerIIOPProfile() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "getServerIIOPProfile:377");
        }
        if (this.serverProfile == null) {
            this.initTransports();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "getServerIIOPProfile:385");
        }
        return this.serverProfile;
    }

    public String getHostIPAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getHostIPAddress:400", (Exception)unknownHostException);
            INTERNAL iNTERNAL = new INTERNAL(unknownHostException.toString(), 1229125046, CompletionStatus.COMPLETED_MAYBE);
            iNTERNAL.initCause((Throwable)unknownHostException);
            throw iNTERNAL;
        }
    }

    private void setORBConfigForChainGroup(ChainData[] chainDataArray, int n) {
        Map map = null;
        Map map2 = null;
        if (Trc.enabled()) {
            Trc.begin(CLASS, "setORBConfigForChainGroup:431");
        }
        for (int i = 0; i < chainDataArray.length; ++i) {
            ORB oRB;
            ChannelData[] channelDataArray = chainDataArray[i].getChannelList();
            for (int j = 0; j < channelDataArray.length; ++j) {
                Class clazz = channelDataArray[j].getFactoryType();
                if (GIOPInboundChannelFactory.class.isAssignableFrom(clazz)) {
                    map2 = channelDataArray[j].getPropertyBag();
                    continue;
                }
                if (!ORBInboundChannelFactory.class.isAssignableFrom(clazz)) continue;
                map = channelDataArray[j].getPropertyBag();
                ++this.inboundORBChannelCount;
            }
            if (map != null) {
                oRB = (ORB)map.get(ORBChannelHelper.ORB);
                if (oRB == null) {
                    map.put(ORBChannelHelper.ORB, this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc("" + this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:463");
                    map.put(ORBChannelHelper.ORB, this.theORB);
                }
            }
            if (map2 != null) {
                oRB = (ORB)map2.get("ORB");
                if (oRB == null) {
                    map2.put("ORB", this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc(this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:480");
                    map2.put("ORB", this.theORB);
                }
            }
            if (!Trc.enabled()) continue;
            for (int j = 0; j < channelDataArray.length; ++j) {
                Map map3 = channelDataArray[j].getPropertyBag();
                Trc.info("Chain=", chainDataArray[i].getName(), " Channel=", channelDataArray[j].getName(), "[", channelDataArray[j].getFactoryType(), "] properties= ", map3, CLASS, "setORBConfigForChainGroup:492");
            }
        }
        if (Trc.enabled()) {
            Trc.complete(CLASS, "setORBConfigForChainGroup:498");
        }
    }

    public GIOPConnectionTable getConnectionTable() {
        return this.connTable;
    }

    public void shutdown() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "shutdown:523");
        }
        this.connTable.shutdown();
        this.iiopChannelPlugin.shutdown();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "shutdown:532");
        }
    }

    public String getUserSpecifiedLocalHost() {
        return this.theORB.getUserSpecifiedLocalHost();
    }

    public String getProperty(String string) {
        return null;
    }

    public void setTransportData(Object object) {
    }

    public Object getTransportData() {
        return null;
    }

    public ORBConnection createORBConnection() {
        return null;
    }

    public ORBConnection createORBConnectionForServer() {
        return null;
    }

    public void createListener(int n) {
        ORBRas.orbTrcLogger.exception(4104L, this, "createListener:572", (Exception)new IOException("You should set up the listener in the ORB chain group"));
    }

    public int getInboundORBChannelCount() {
        return this.inboundORBChannelCount;
    }

    private static class ChainEnquirer
    implements ChainEventListener {
        private final ChannelFramework channelFramework;
        private final String chainName;
        private boolean waitForStart;
        private int listeningPort;

        ChainEnquirer(ChannelFramework channelFramework, String string) {
            block4: {
                this.waitForStart = true;
                this.listeningPort = 0;
                if (Trc.enabled()) {
                    Trc.begin(CLASS, "ChainStartListener:594");
                }
                this.channelFramework = channelFramework;
                this.chainName = string;
                try {
                    channelFramework.addChainEventListener((ChainEventListener)this, string);
                    if (Trc.enabled()) {
                        Trc.complete(CLASS, "ChainStartListener:600");
                    }
                }
                catch (ChainException chainException) {
                    this.endWaiting();
                    if (!Trc.enabled()) break block4;
                    Trc.fail((Object)chainException, CLASS, "ChainStartListener:604");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chainStarted(ChainData chainData) {
            if (Trc.enabled()) {
                Trc.begin(CLASS, "chainStarted:611");
            }
            try {
                this.channelFramework.removeChainEventListener((ChainEventListener)this, this.chainName);
            }
            catch (ChainException chainException) {
                // empty catch block
            }
            ChainEnquirer chainEnquirer = this;
            synchronized (chainEnquirer) {
                if (this.waitForStart) {
                    try {
                        this.listeningPort = this.channelFramework.getListeningPort(this.chainName);
                        if (Trc.enabled()) {
                            Trc.complete(Trc.str(this.listeningPort), CLASS, "chainStarted:624");
                        }
                    }
                    catch (Exception exception) {
                        if (Trc.enabled()) {
                            Trc.fail(CLASS, "chainStarted:627");
                        }
                    }
                    finally {
                        this.endWaiting();
                    }
                }
            }
        }

        int getListenerPort() {
            if (Trc.enabled()) {
                Trc.begin(CLASS, "getListenerPort:638");
            }
            while (this.waitForStart) {
                try {
                    if (Trc.enabled()) {
                        Trc.info("waiting ...", CLASS, "getListenerPort:642");
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Trc.enabled()) {
                Trc.complete(Trc.str(this.listeningPort), CLASS, "getListenerPort:648");
            }
            return this.listeningPort;
        }

        private synchronized void endWaiting() {
            this.waitForStart = false;
            this.notify();
        }

        public void chainInitialized(ChainData chainData) {
        }

        public void chainStopped(ChainData chainData) {
            if (Trc.enabled()) {
                Trc.info(CLASS, "chainStopped:661");
            }
            this.endWaiting();
        }

        public void chainDestroyed(ChainData chainData) {
            if (Trc.enabled()) {
                Trc.info(CLASS, "chainDestroyed:667");
            }
            this.endWaiting();
        }

        public void chainUpdated(ChainData chainData) {
        }
    }
}

