/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.org.omg.CORBA._ObjectStub;
import com.ibm.rmi.IOR;
import com.ibm.rmi.SubcontractRegistry;
import com.ibm.rmi.corba.ClientDelegate;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.IIOPAddrImpl;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.corba.ProtAddrImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.Delegate;

public class Corbaloc
implements ObjectURL {
    private String keyString = "NameService";
    private ObjectKey objectKey;
    private boolean isRir = false;
    private ArrayList protList = null;
    private final String encoding = "ISO-8859-1";

    protected Corbaloc() {
    }

    public Corbaloc(String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "<init>:104", (java.lang.Object)string);
        }
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string is null or empty", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if (!string.toLowerCase().startsWith("corbaloc:")) {
            throw new BAD_PARAM("string does not start with corbaloc:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        this.parseCorbaloc(string.substring("corbaloc:".length()));
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:125", (java.lang.Object)this.toString());
        }
    }

    protected void parseCorbaloc(String string) {
        byte[] byArray;
        int n = string.indexOf(47);
        if (n == -1) {
            this.parseObjAddrList(string);
        } else {
            this.parseObjAddrList(string.substring(0, n));
            if (n + 1 < string.length()) {
                this.keyString = INSUtil.decode2936(string.substring(n + 1));
            }
        }
        try {
            byArray = this.keyString.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "parseCorbaloc:160", (Exception)unsupportedEncodingException);
            byArray = this.keyString.getBytes();
        }
        this.objectKey = new ObjectKey(byArray);
    }

    private void parseObjAddrList(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("string has no address scheme", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        while (string != null) {
            int n = string.indexOf(44);
            if (n == -1) {
                this.parseObjAddr(string);
                string = null;
                continue;
            }
            this.parseObjAddr(string.substring(0, n));
            if (n + 1 <= string.length()) {
                string = string.substring(n + 1);
                continue;
            }
            string = null;
        }
        if (this.isRir && this.protList != null) {
            throw new BAD_PARAM("rir: cannot be used with any other protocol", 1330446344, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parseObjAddr(String string) {
        if (string == null || string.length() == 0) {
            throw new BAD_PARAM("empty obj_addr", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int n = string.indexOf(58);
        if (n == -1) {
            throw new BAD_PARAM("missing prot_addr " + string, 1330446344, CompletionStatus.COMPLETED_NO);
        }
        if (string.startsWith("rir:")) {
            if (n + 1 < string.length()) {
                throw new BAD_PARAM("invalid obj_addr " + string, 1330446345, CompletionStatus.COMPLETED_NO);
            }
            this.isRir = true;
        } else if (n == 0 || string.startsWith("iiop:")) {
            this.addToProtList(new IIOPAddrImpl(string.substring(n + 1)));
        } else {
            this.addToProtList(new ProtAddrImpl(string.substring(0, n), string.substring(n + 1)));
        }
    }

    private void addToProtList(ObjectURL.ProtAddr protAddr) {
        if (protAddr == null) {
            return;
        }
        if (this.protList == null) {
            this.protList = new ArrayList();
        }
        this.protList.add(protAddr);
    }

    public String toString() {
        return "corbaloc:" + this.corbalocToString();
    }

    protected String corbalocToString() {
        String string = "";
        if (this.isRir) {
            string = string + "rir:";
        } else {
            for (int i = 0; i < this.protList.size(); ++i) {
                if (i > 0) {
                    string = string + ',';
                }
                string = string + this.protList.get(i).toString();
            }
        }
        return string + '/' + this.getKeyString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                System.out.println(stringArray[i] + " -> " + new Corbaloc(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                System.out.println(stringArray[i] + " -> " + exception.toString());
            }
        }
    }

    private Object locateUsingINS(ORB oRB, ObjectURL.IIOPAddr iIOPAddr) {
        com.ibm.CORBA.iiop.ORB cfr_ignored_0 = (com.ibm.CORBA.iiop.ORB)oRB;
        IOR iOR = (IOR)com.ibm.CORBA.iiop.ORB.createBootstrapIOR((com.ibm.CORBA.iiop.ORB)oRB, iIOPAddr.getHost(), iIOPAddr.getPort(), this.objectKey);
        iOR.getProfile().setMinor(iIOPAddr.getMinor());
        SubcontractRegistry subcontractRegistry = (SubcontractRegistry)oRB.getSubcontractRegistry();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(iOR);
        _ObjectStub _ObjectStub2 = new _ObjectStub();
        _ObjectStub2._set_delegate((Delegate)clientSubcontract);
        iOR = (IOR)((com.ibm.rmi.iiop.ORB)oRB).getClientGIOP().locate(iOR, (ClientDelegate)clientSubcontract);
        return oRB.IORToObject(iOR);
    }

    private Object locateUsingBootstrap(ORB oRB, ObjectURL.IIOPAddr iIOPAddr) throws InvalidName {
        return oRB.initialReferenceClient.resolve_initial_references(this.keyString, iIOPAddr.getHost(), iIOPAddr.getPort());
    }

    private Object locateUsingRir(ORB oRB) {
        try {
            return oRB.resolve_initial_references(this.keyString);
        }
        catch (InvalidName invalidName) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "locateUsingRir:330", invalidName.toString());
            }
            throw new BAD_PARAM("could not locate rir object " + this.keyString + ": " + invalidName.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }

    protected Object lookupName(Object object) {
        return object;
    }

    public Object resolve(ORB oRB) {
        FirstException firstException = new FirstException();
        if (this.isRir) {
            try {
                return this.lookupName(this.locateUsingRir(oRB));
            }
            catch (Exception exception) {
                firstException.set(exception, null);
            }
        } else {
            ObjectURL.ProtAddr protAddr;
            int n;
            boolean[] blArray = new boolean[this.protList.size()];
            for (n = 0; n < this.protList.size(); ++n) {
                protAddr = (ObjectURL.ProtAddr)this.protList.get(n);
                if (protAddr instanceof ObjectURL.IIOPAddr) {
                    blArray[n] = false;
                    try {
                        return this.lookupName(this.locateUsingINS(oRB, (ObjectURL.IIOPAddr)protAddr));
                    }
                    catch (Exception exception) {
                        firstException.set(exception, protAddr);
                        if (!(exception instanceof COMM_FAILURE) && !(exception instanceof TRANSIENT)) continue;
                        blArray[n] = true;
                        continue;
                    }
                }
                blArray[n] = true;
                firstException.set((Exception)((java.lang.Object)new BAD_PARAM("invalid protocol " + protAddr.getProtToken(), 1330446344, CompletionStatus.COMPLETED_NO)), protAddr);
            }
            if (oRB.isSINOClient()) {
                for (n = 0; n < this.protList.size(); ++n) {
                    if (blArray[n]) continue;
                    protAddr = (ObjectURL.IIOPAddr)this.protList.get(n);
                    try {
                        return this.lookupName(this.locateUsingBootstrap(oRB, (ObjectURL.IIOPAddr)protAddr));
                    }
                    catch (Exception exception) {
                        if (!ORBRas.isTrcLogging) continue;
                        ORBRas.orbTrcLogger.trace(8208L, this, "resolve:419", exception.toString());
                    }
                }
            }
        }
        throw firstException.get();
    }

    public boolean isCorbaloc() {
        return true;
    }

    public boolean isCorbaname() {
        return false;
    }

    public boolean isIOR() {
        return false;
    }

    public boolean isRir() {
        return this.isRir;
    }

    public Iterator getProtList() {
        return this.getIIOPList();
    }

    public Iterator getIIOPList() {
        if (this.protList != null) {
            return this.protList.iterator();
        }
        return null;
    }

    public ObjectKey getObjectKey() {
        return this.objectKey;
    }

    public String getKeyString() {
        return INSUtil.encode2936(this.keyString);
    }

    public String getStringName() {
        return null;
    }

    private class FirstException {
        private Exception e = null;
        private ObjectURL.ProtAddr protAddr = null;

        private FirstException() {
        }

        public void set(Exception exception, ObjectURL.ProtAddr protAddr) {
            if (this.e == null || this.e instanceof SystemException && !(exception instanceof SystemException)) {
                this.e = exception;
                this.protAddr = protAddr;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, this, "set:455", exception.toString());
            }
        }

        public SystemException get() {
            if (this.e == null) {
                return new BAD_PARAM("could not locate object", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            if (this.e instanceof SystemException) {
                return (SystemException)((java.lang.Object)this.e);
            }
            return new BAD_PARAM(this.e.toString() + (this.protAddr == null ? "" : " with " + ((java.lang.Object)this.protAddr).toString()), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }
}

