/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.DSAParameterGenerator;
import com.ibm.crypto.provider.DSAPrivateKey;
import com.ibm.crypto.provider.DSAPublicKey;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private int a = 512;
    private SecureRandom b;
    private DSAParameterSpec c;
    private static final BigInteger d;
    private static String[] z;

    public DSAKeyPairGenerator() {
        super(z[5]);
        this.initialize(1024, null);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.c = (DSAParameterSpec)algorithmParameterSpec;
        this.b = secureRandom;
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 2048 || n2 % 64 != 0) {
            throw new InvalidParameterException(z[0]);
        }
        this.a = n2;
        this.b = secureRandom;
        this.c = null;
    }

    public void initialize(int n2, boolean bl, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 2048 || n2 % 64 != 0) {
            throw new InvalidParameterException(z[0]);
        }
        if (bl) {
            this.c = null;
        } else {
            this.c();
            if (this.c == null) {
                throw new InvalidParameterException(z[4]);
            }
        }
        this.a = n2;
        this.b = secureRandom;
    }

    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) {
        if (dSAParams == null) {
            throw new InvalidParameterException(z[1]);
        }
        DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
        int n2 = dSAParams.getP().bitLength();
        if (n2 < 512 || n2 > 2048 || n2 % 64 != 0) {
            throw new InvalidParameterException(z[0]);
        }
        this.a = n2;
        this.c = dSAParameterSpec;
        this.b = secureRandom;
    }

    private BigInteger a() {
        int n2 = this.a;
        int n3 = (n2 - 1) / 160;
        int n4 = n2 - 1 - 160 * n3;
        int n5 = 20;
        byte[] byArray = new byte[n5];
        this.b.nextBytes(byArray);
        byte[] byArray2 = new byte[n5];
        this.b.nextBytes(byArray2);
        BigInteger bigInteger = new BigInteger(1, byArray).add(new BigInteger(1, byArray2));
        BigInteger bigInteger2 = bigInteger.mod(d.pow(n4));
        byte[] byArray3 = bigInteger2.toByteArray();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(z[3], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        messageDigest.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = messageDigest.digest();
        return new BigInteger(1, byArray4).mod(this.c.getQ());
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.c.getG();
        return bigInteger2.modPow(bigInteger, this.c.getP());
    }

    public KeyPair generateKeyPair() {
        if (this.c == null) {
            this.c();
        }
        if (this.b == null) {
            try {
                this.b = SecureRandom.getInstance(z[6]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        BigInteger bigInteger = this.a();
        DSAPrivateKey dSAPrivateKey = null;
        try {
            dSAPrivateKey = new DSAPrivateKey(bigInteger, this.c.getP(), this.c.getQ(), this.c.getG());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigInteger bigInteger2 = this.a(bigInteger);
        DSAPublicKey dSAPublicKey = null;
        try {
            dSAPublicKey = new DSAPublicKey(bigInteger2, this.c.getP(), this.c.getQ(), this.c.getG());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new KeyPair(dSAPublicKey, dSAPrivateKey);
    }

    private void c() {
        AlgorithmParameterGenerator algorithmParameterGenerator;
        switch (this.a) {
            case 512: {
                this.c = new DSAParameterSpec(DSAParameterGenerator.d, DSAParameterGenerator.e, DSAParameterGenerator.f);
                return;
            }
            case 768: {
                this.c = new DSAParameterSpec(DSAParameterGenerator.g, DSAParameterGenerator.h, DSAParameterGenerator.i);
                return;
            }
            case 1024: {
                this.c = new DSAParameterSpec(DSAParameterGenerator.j, DSAParameterGenerator.k, DSAParameterGenerator.l);
                return;
            }
            case 2048: {
                this.c = new DSAParameterSpec(DSAParameterGenerator.m, DSAParameterGenerator.n, DSAParameterGenerator.o);
                return;
            }
        }
        try {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(z[5], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        algorithmParameterGenerator.init(this.a, this.b);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        try {
            this.c = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new Error();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block69: {
            int n2;
            int n3;
            block68: {
                char[] cArray2;
                Object var0;
                block67: {
                    int n4;
                    block66: {
                        char[] cArray3;
                        block65: {
                            int n5;
                            block64: {
                                char[] cArray4;
                                block63: {
                                    int n6;
                                    block62: {
                                        char[] cArray5;
                                        block61: {
                                            int n7;
                                            block60: {
                                                char[] cArray6;
                                                block59: {
                                                    int n8;
                                                    block58: {
                                                        char[] cArray7;
                                                        block57: {
                                                            int n9;
                                                            block56: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray8 = "\u0018H.G7 TjA2/Bj_.&Sj@:;@/\u0012='H'\u0012nd\u0015jF4u\u0015z\u0006cuF$V{7BjS{8R&F2%K/\u001243\u0007|\u0006".toCharArray();
                                                                cArray7 = cArray8;
                                                                n9 = cArray8.length;
                                                                n3 = 0;
                                                                if (!true) break block56;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block57;
                                                            }
                                                            do {
                                                                int n10;
                                                                cArray7 = cArray7;
                                                                int n11 = n3;
                                                                char c2 = cArray7[n11];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n10 = 85;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n10 = 39;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n10 = 74;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n10 = 50;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n10 = 91;
                                                                    }
                                                                }
                                                                cArray7[n11] = (char)(c2 ^ n10);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray9 = "\u0005F8S6&\u0007'G(!\u0007$]/uE/\u00125 K&".toCharArray();
                                                        cArray6 = cArray9;
                                                        n8 = cArray9.length;
                                                        n3 = 0;
                                                        if (!true) break block58;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block59;
                                                    }
                                                    do {
                                                        int n12;
                                                        cArray6 = cArray6;
                                                        int n13 = n3;
                                                        char c3 = cArray6[n13];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n12 = 85;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n12 = 39;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n12 = 74;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n12 = 50;
                                                                break;
                                                            }
                                                            default: {
                                                                n12 = 91;
                                                            }
                                                        }
                                                        cArray6[n13] = (char)(c3 ^ n12);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[1] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray10 = "\u001ce\u0007x\u0018\u0010".toCharArray();
                                                cArray5 = cArray10;
                                                n7 = cArray10.length;
                                                n3 = 0;
                                                if (!true) break block60;
                                                n7 = n7;
                                                if (n7 <= n3) break block61;
                                            }
                                            do {
                                                int n14;
                                                cArray5 = cArray5;
                                                int n15 = n3;
                                                char c4 = cArray5[n15];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n14 = 85;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n14 = 39;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n14 = 74;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n14 = 50;
                                                        break;
                                                    }
                                                    default: {
                                                        n14 = 91;
                                                    }
                                                }
                                                cArray5[n15] = (char)(c4 ^ n14);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[2] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray11 = "\u0006o\u000b".toCharArray();
                                        cArray4 = cArray11;
                                        n6 = cArray11.length;
                                        n3 = 0;
                                        if (!true) break block62;
                                        n6 = n6;
                                        if (n6 <= n3) break block63;
                                    }
                                    do {
                                        int n16;
                                        cArray4 = cArray4;
                                        int n17 = n3;
                                        char c5 = cArray4[n17];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n16 = 85;
                                                break;
                                            }
                                            case 1: {
                                                n16 = 39;
                                                break;
                                            }
                                            case 2: {
                                                n16 = 74;
                                                break;
                                            }
                                            case 3: {
                                                n16 = 50;
                                                break;
                                            }
                                            default: {
                                                n16 = 91;
                                            }
                                        }
                                        cArray4[n17] = (char)(c5 ^ n16);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[3] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray12 = "\u001bHjB)0D%_+ S/V{%F8S60S/@(uA%@{'B;G>&S/V{8H.G7 TjA2/BjS-4N&S99B".toCharArray();
                                cArray3 = cArray12;
                                n5 = cArray12.length;
                                n3 = 0;
                                if (!true) break block64;
                                n5 = n5;
                                if (n5 <= n3) break block65;
                            }
                            do {
                                int n18;
                                cArray3 = cArray3;
                                int n19 = n3;
                                char c6 = cArray3[n19];
                                switch (n3 % 5) {
                                    case 0: {
                                        n18 = 85;
                                        break;
                                    }
                                    case 1: {
                                        n18 = 39;
                                        break;
                                    }
                                    case 2: {
                                        n18 = 74;
                                        break;
                                    }
                                    case 3: {
                                        n18 = 50;
                                        break;
                                    }
                                    default: {
                                        n18 = 91;
                                    }
                                }
                                cArray3[n19] = (char)(c6 ^ n18);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[4] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray13 = "\u0011t\u000b".toCharArray();
                        cArray2 = cArray13;
                        n4 = cArray13.length;
                        n3 = 0;
                        if (!true) break block66;
                        n4 = n4;
                        if (n4 <= n3) break block67;
                    }
                    do {
                        int n20;
                        cArray2 = cArray2;
                        int n21 = n3;
                        char c7 = cArray2[n21];
                        switch (n3 % 5) {
                            case 0: {
                                n20 = 85;
                                break;
                            }
                            case 1: {
                                n20 = 39;
                                break;
                            }
                            case 2: {
                                n20 = 74;
                                break;
                            }
                            case 3: {
                                n20 = 50;
                                break;
                            }
                            default: {
                                n20 = 91;
                            }
                        }
                        cArray2[n21] = (char)(c7 ^ n20);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[5] = new String(cArray2).intern();
                var0 = null;
                char[] cArray14 = "\u001ce\u0007a>6R8W\t4I.]6".toCharArray();
                cArray = cArray14;
                n2 = cArray14.length;
                n3 = 0;
                if (!true) break block68;
                n2 = n2;
                if (n2 <= n3) break block69;
            }
            do {
                int n22;
                cArray = cArray;
                int n23 = n3;
                char c8 = cArray[n23];
                switch (n3 % 5) {
                    case 0: {
                        n22 = 85;
                        break;
                    }
                    case 1: {
                        n22 = 39;
                        break;
                    }
                    case 2: {
                        n22 = 74;
                        break;
                    }
                    case 3: {
                        n22 = 50;
                        break;
                    }
                    default: {
                        n22 = 91;
                    }
                }
                cArray[n23] = (char)(c8 ^ n22);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        z = stringArray;
        d = BigInteger.valueOf(2L);
    }
}

