/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static String[] z;

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0]);
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(z[5]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(z[1]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(z[6]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(z[2]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(z[7]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(z[3]);
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[8]);
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(z[4]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return z[9];
    }

    public String getAlgorithm() {
        return z[10];
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[11] + this.y.toString() + "\n" + z[12] + this.p.toString() + "\n" + z[14] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(z[13] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block149: {
            int n2;
            int n3;
            block148: {
                char[] cArray2;
                Object var0;
                block147: {
                    int n4;
                    block146: {
                        char[] cArray3;
                        block145: {
                            int n5;
                            block144: {
                                char[] cArray4;
                                block143: {
                                    int n6;
                                    block142: {
                                        char[] cArray5;
                                        block141: {
                                            int n7;
                                            block140: {
                                                char[] cArray6;
                                                block139: {
                                                    int n8;
                                                    block138: {
                                                        char[] cArray7;
                                                        block137: {
                                                            int n9;
                                                            block136: {
                                                                char[] cArray8;
                                                                block135: {
                                                                    int n10;
                                                                    block134: {
                                                                        char[] cArray9;
                                                                        block133: {
                                                                            int n11;
                                                                            block132: {
                                                                                char[] cArray10;
                                                                                block131: {
                                                                                    int n12;
                                                                                    block130: {
                                                                                        char[] cArray11;
                                                                                        block129: {
                                                                                            int n13;
                                                                                            block128: {
                                                                                                char[] cArray12;
                                                                                                block127: {
                                                                                                    int n14;
                                                                                                    block126: {
                                                                                                        char[] cArray13;
                                                                                                        block125: {
                                                                                                            int n15;
                                                                                                            block124: {
                                                                                                                char[] cArray14;
                                                                                                                block123: {
                                                                                                                    int n16;
                                                                                                                    block122: {
                                                                                                                        char[] cArray15;
                                                                                                                        block121: {
                                                                                                                            int n17;
                                                                                                                            block120: {
                                                                                                                                stringArray = new String[15];
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray16 = "=H\u0002<A\n\t\u001c A\u001a\\\u000f7\u000e?z\"|\u001f^L\u00021A\u001a@\u00025".toCharArray();
                                                                                                                                cArray15 = cArray16;
                                                                                                                                n17 = cArray16.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block120;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block121;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n18;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n19 = n3;
                                                                                                                                char c2 = cArray15[n19];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n18 = 126;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n18 = 41;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n18 = 108;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n18 = 82;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n18 = 46;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n19] = (char)(c2 ^ n18);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[0] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray17 = "?E\u000b\u001bJ^@\u001fr@\u0011]L3\u000e-l=\u0007k0j)".toCharArray();
                                                                                                                        cArray14 = cArray17;
                                                                                                                        n16 = cArray17.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block122;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block123;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n20;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n21 = n3;
                                                                                                                        char c3 = cArray14[n21];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n20 = 126;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n20 = 41;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n20 = 108;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n20 = 82;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n20 = 46;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n21] = (char)(c3 ^ n20);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[1] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray18 = "0\\\u0000>\u000e\u000eH\u001e3C\u001b]\t ]".toCharArray();
                                                                                                                cArray13 = cArray18;
                                                                                                                n15 = cArray18.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block124;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block125;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n22;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n23 = n3;
                                                                                                                char c4 = cArray13[n23];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n22 = 126;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n22 = 41;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n22 = 108;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n22 = 82;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n22 = 46;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n23] = (char)(c4 ^ n22);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[2] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray19 = ";Q\u0018 O^Y\r O\u0013L\u00187\\^M\r&O".toCharArray();
                                                                                                        cArray12 = cArray19;
                                                                                                        n14 = cArray19.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block126;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block127;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n24;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n25 = n3;
                                                                                                        char c5 = cArray12[n25];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n24 = 126;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n24 = 41;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n24 = 108;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n24 = 82;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n24 = 46;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n25] = (char)(c5 ^ n24);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[3] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray20 = ".[\u0005$O\nLA$O\u0012\\\trB\u001bG\u000b&F^]\u0003=\u000e\u001c@\u000b".toCharArray();
                                                                                                cArray11 = cArray20;
                                                                                                n13 = cArray20.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block128;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block129;
                                                                                            }
                                                                                            do {
                                                                                                int n26;
                                                                                                cArray11 = cArray11;
                                                                                                int n27 = n3;
                                                                                                char c6 = cArray11[n27];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n26 = 126;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n26 = 41;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n26 = 108;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n26 = 82;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n26 = 46;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n27] = (char)(c6 ^ n26);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[4] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray21 = "7G\u001a3B\u0017ML9K\u0007\t\n=\\\u0013H\u0018".toCharArray();
                                                                                        cArray10 = cArray21;
                                                                                        n12 = cArray21.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block130;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block131;
                                                                                    }
                                                                                    do {
                                                                                        int n28;
                                                                                        cArray10 = cArray10;
                                                                                        int n29 = n3;
                                                                                        char c7 = cArray10[n29];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n28 = 126;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n28 = 41;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n28 = 108;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n28 = 82;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n28 = 46;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n29] = (char)(c7 ^ n28);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[5] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray22 = ".H\u001e3C\u001b]\t ]^D\u0005!]\u0017G\u000b".toCharArray();
                                                                                cArray9 = cArray22;
                                                                                n11 = cArray22.length;
                                                                                n3 = 0;
                                                                                if (!true) break block132;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block133;
                                                                            }
                                                                            do {
                                                                                int n30;
                                                                                cArray9 = cArray9;
                                                                                int n31 = n3;
                                                                                char c8 = cArray9[n31];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n30 = 126;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n30 = 41;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n30 = 108;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n30 = 82;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n30 = 46;
                                                                                    }
                                                                                }
                                                                                cArray9[n31] = (char)(c8 ^ n30);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[6] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray23 = ".H\u001e3C\u001b]\t ]^G\u0003&\u000e\u001f\t?\u0017\u007f+l\"\u0011k".toCharArray();
                                                                        cArray8 = cArray23;
                                                                        n10 = cArray23.length;
                                                                        n3 = 0;
                                                                        if (!true) break block134;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block135;
                                                                    }
                                                                    do {
                                                                        int n32;
                                                                        cArray8 = cArray8;
                                                                        int n33 = n3;
                                                                        char c9 = cArray8[n33];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n32 = 126;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n32 = 41;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n32 = 108;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n32 = 82;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n32 = 46;
                                                                            }
                                                                        }
                                                                        cArray8[n33] = (char)(c9 ^ n32);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[7] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray24 = ";Q\u000f7]\r\t\u00077W^M\r&O".toCharArray();
                                                                cArray7 = cArray24;
                                                                n9 = cArray24.length;
                                                                n3 = 0;
                                                                if (!true) break block136;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block137;
                                                            }
                                                            do {
                                                                int n34;
                                                                cArray7 = cArray7;
                                                                int n35 = n3;
                                                                char c10 = cArray7[n35];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n34 = 126;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n34 = 41;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n34 = 108;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n34 = 82;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n34 = 46;
                                                                    }
                                                                }
                                                                cArray7[n35] = (char)(c10 ^ n34);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[8] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray25 = "&\u0007Yb\u0017".toCharArray();
                                                        cArray6 = cArray25;
                                                        n8 = cArray25.length;
                                                        n3 = 0;
                                                        if (!true) break block138;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block139;
                                                    }
                                                    do {
                                                        int n36;
                                                        cArray6 = cArray6;
                                                        int n37 = n3;
                                                        char c11 = cArray6[n37];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n36 = 126;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n36 = 41;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n36 = 108;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n36 = 82;
                                                                break;
                                                            }
                                                            default: {
                                                                n36 = 46;
                                                            }
                                                        }
                                                        cArray6[n37] = (char)(c11 ^ n36);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[9] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray26 = ":a".toCharArray();
                                                cArray5 = cArray26;
                                                n7 = cArray26.length;
                                                n3 = 0;
                                                if (!true) break block140;
                                                n7 = n7;
                                                if (n7 <= n3) break block141;
                                            }
                                            do {
                                                int n38;
                                                cArray5 = cArray5;
                                                int n39 = n3;
                                                char c12 = cArray5[n39];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n38 = 126;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n38 = 41;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n38 = 108;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n38 = 82;
                                                        break;
                                                    }
                                                    default: {
                                                        n38 = 46;
                                                    }
                                                }
                                                cArray5[n39] = (char)(c12 ^ n38);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[10] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray27 = "7k!\u0018m;\t(;H\u0018@\t\u007ff\u001bE\u0000?O\u0010\t<'L\u0012@\u000fre\u001bPVXWD#".toCharArray();
                                        cArray4 = cArray27;
                                        n6 = cArray27.length;
                                        n3 = 0;
                                        if (!true) break block142;
                                        n6 = n6;
                                        if (n6 <= n3) break block143;
                                    }
                                    do {
                                        int n40;
                                        cArray4 = cArray4;
                                        int n41 = n3;
                                        char c13 = cArray4[n41];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n40 = 126;
                                                break;
                                            }
                                            case 1: {
                                                n40 = 41;
                                                break;
                                            }
                                            case 2: {
                                                n40 = 108;
                                                break;
                                            }
                                            case 3: {
                                                n40 = 82;
                                                break;
                                            }
                                            default: {
                                                n40 = 46;
                                            }
                                        }
                                        cArray4[n41] = (char)(c13 ^ n40);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[11] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray28 = "\u000e\u0013f".toCharArray();
                                cArray3 = cArray28;
                                n5 = cArray28.length;
                                n3 = 0;
                                if (!true) break block144;
                                n5 = n5;
                                if (n5 <= n3) break block145;
                            }
                            do {
                                int n42;
                                cArray3 = cArray3;
                                int n43 = n3;
                                char c14 = cArray3[n43];
                                switch (n3 % 5) {
                                    case 0: {
                                        n42 = 126;
                                        break;
                                    }
                                    case 1: {
                                        n42 = 41;
                                        break;
                                    }
                                    case 2: {
                                        n42 = 108;
                                        break;
                                    }
                                    case 3: {
                                        n42 = 82;
                                        break;
                                    }
                                    default: {
                                        n42 = 46;
                                    }
                                }
                                cArray3[n43] = (char)(c14 ^ n42);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[12] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray29 = "tEVX\u000e^\tL".toCharArray();
                        cArray2 = cArray29;
                        n4 = cArray29.length;
                        n3 = 0;
                        if (!true) break block146;
                        n4 = n4;
                        if (n4 <= n3) break block147;
                    }
                    do {
                        int n44;
                        cArray2 = cArray2;
                        int n45 = n3;
                        char c15 = cArray2[n45];
                        switch (n3 % 5) {
                            case 0: {
                                n44 = 126;
                                break;
                            }
                            case 1: {
                                n44 = 41;
                                break;
                            }
                            case 2: {
                                n44 = 108;
                                break;
                            }
                            case 3: {
                                n44 = 82;
                                break;
                            }
                            default: {
                                n44 = 46;
                            }
                        }
                        cArray2[n45] = (char)(c15 ^ n44);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[13] = new String(cArray2).intern();
                var0 = null;
                char[] cArray30 = "\u0019\u0013f".toCharArray();
                cArray = cArray30;
                n2 = cArray30.length;
                n3 = 0;
                if (!true) break block148;
                n2 = n2;
                if (n2 <= n3) break block149;
            }
            do {
                int n46;
                cArray = cArray;
                int n47 = n3;
                char c16 = cArray[n47];
                switch (n3 % 5) {
                    case 0: {
                        n46 = 126;
                        break;
                    }
                    case 1: {
                        n46 = 41;
                        break;
                    }
                    case 2: {
                        n46 = 108;
                        break;
                    }
                    case 3: {
                        n46 = 82;
                        break;
                    }
                    default: {
                        n46 = 46;
                    }
                }
                cArray[n47] = (char)(c16 ^ n46);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[14] = new String(cArray).intern();
        z = stringArray;
    }
}

