/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7885790631402109830L;
    private static final BigInteger PKCS8_VERSION;
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private static String[] z;

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[2]);
        }
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(z[5]);
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException(z[10] + PKCS8_VERSION + z[6] + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(z[11]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(z[7]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(z[3]);
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(z[8]);
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(z[4]);
            }
            this.key = derValue.getData().getOctetString();
            this.a();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(z[9]);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return z[0];
    }

    public String getAlgorithm() {
        return z[1];
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[12] + this.x.toString() + "\n" + z[13] + this.p.toString() + "\n" + z[15] + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(z[14] + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PrivateKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block159: {
            int n2;
            int n3;
            block158: {
                char[] cArray2;
                Object var0;
                block157: {
                    int n4;
                    block156: {
                        char[] cArray3;
                        block155: {
                            int n5;
                            block154: {
                                char[] cArray4;
                                block153: {
                                    int n6;
                                    block152: {
                                        char[] cArray5;
                                        block151: {
                                            int n7;
                                            block150: {
                                                char[] cArray6;
                                                block149: {
                                                    int n8;
                                                    block148: {
                                                        char[] cArray7;
                                                        block147: {
                                                            int n9;
                                                            block146: {
                                                                char[] cArray8;
                                                                block145: {
                                                                    int n10;
                                                                    block144: {
                                                                        char[] cArray9;
                                                                        block143: {
                                                                            int n11;
                                                                            block142: {
                                                                                char[] cArray10;
                                                                                block141: {
                                                                                    int n12;
                                                                                    block140: {
                                                                                        char[] cArray11;
                                                                                        block139: {
                                                                                            int n13;
                                                                                            block138: {
                                                                                                char[] cArray12;
                                                                                                block137: {
                                                                                                    int n14;
                                                                                                    block136: {
                                                                                                        char[] cArray13;
                                                                                                        block135: {
                                                                                                            int n15;
                                                                                                            block134: {
                                                                                                                char[] cArray14;
                                                                                                                block133: {
                                                                                                                    int n16;
                                                                                                                    block132: {
                                                                                                                        char[] cArray15;
                                                                                                                        block131: {
                                                                                                                            int n17;
                                                                                                                            block130: {
                                                                                                                                char[] cArray16;
                                                                                                                                block129: {
                                                                                                                                    int n18;
                                                                                                                                    block128: {
                                                                                                                                        stringArray = new String[16];
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray17 = "9G\u001a&\u0015Q".toCharArray();
                                                                                                                                        cArray16 = cArray17;
                                                                                                                                        n18 = cArray17.length;
                                                                                                                                        n3 = 0;
                                                                                                                                        if (!true) break block128;
                                                                                                                                        n18 = n18;
                                                                                                                                        if (n18 <= n3) break block129;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        int n19;
                                                                                                                                        cArray16 = cArray16;
                                                                                                                                        int n20 = n3;
                                                                                                                                        char c2 = cArray16[n20];
                                                                                                                                        switch (n3 % 5) {
                                                                                                                                            case 0: {
                                                                                                                                                n19 = 105;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                n19 = 12;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 2: {
                                                                                                                                                n19 = 89;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 3: {
                                                                                                                                                n19 = 117;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                n19 = 54;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        cArray16[n20] = (char)(c2 ^ n19);
                                                                                                                                        ++n3;
                                                                                                                                        n18 = n18;
                                                                                                                                    } while (n18 > n3);
                                                                                                                                }
                                                                                                                                stringArray[0] = new String(cArray16).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray18 = "-D".toCharArray();
                                                                                                                                cArray15 = cArray18;
                                                                                                                                n17 = cArray18.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block130;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block131;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n21;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n22 = n3;
                                                                                                                                char c3 = cArray15[n22];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n21 = 105;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n21 = 12;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n21 = 89;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n21 = 117;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n21 = 54;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n22] = (char)(c3 ^ n21);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[1] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray19 = "*m7\u001bY\u001d,)\u0007Y\ry:\u0010\u0016(_\u0017[\u0007Ii7\u0016Y\re7\u0012".toCharArray();
                                                                                                                        cArray14 = cArray19;
                                                                                                                        n16 = cArray19.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block132;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block133;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n23;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n24 = n3;
                                                                                                                        char c4 = cArray14[n24];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n23 = 105;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n23 = 12;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n23 = 89;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n23 = 117;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n23 = 54;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n24] = (char)(c4 ^ n23);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[2] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray20 = "'y5\u0019\u0016\u0019m+\u0014[\fx<\u0007E".toCharArray();
                                                                                                                cArray13 = cArray20;
                                                                                                                n15 = cArray20.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block134;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block135;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n25;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n26 = n3;
                                                                                                                char c5 = cArray13[n26];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n25 = 105;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n25 = 12;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n25 = 89;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n25 = 117;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n25 = 54;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n26] = (char)(c5 ^ n25);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[3] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray21 = ",t-\u0007WI|8\u0007W\u0004i-\u0010DIh8\u0001W".toCharArray();
                                                                                                        cArray12 = cArray21;
                                                                                                        n14 = cArray21.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block136;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block137;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n27;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n28 = n3;
                                                                                                        char c6 = cArray12[n28];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n27 = 105;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n27 = 12;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n27 = 89;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n27 = 117;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n27 = 54;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n28] = (char)(c6 ^ n27);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[4] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray22 = "\"i UX\u0006xy\u0014\u0016:I\b s'O\u001c".toCharArray();
                                                                                                cArray11 = cArray22;
                                                                                                n13 = cArray22.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block138;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block139;
                                                                                            }
                                                                                            do {
                                                                                                int n29;
                                                                                                cArray11 = cArray11;
                                                                                                int n30 = n3;
                                                                                                char c7 = cArray11[n30];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n29 = 105;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n29 = 12;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n29 = 89;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n29 = 117;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n29 = 54;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n30] = (char)(c7 ^ n29);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[5] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray23 = "E,)\u0014D\u001ai=O\u0016".toCharArray();
                                                                                        cArray10 = cArray23;
                                                                                        n12 = cArray23.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block140;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block141;
                                                                                    }
                                                                                    do {
                                                                                        int n31;
                                                                                        cArray10 = cArray10;
                                                                                        int n32 = n3;
                                                                                        char c8 = cArray10[n32];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n31 = 105;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n31 = 12;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n31 = 89;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n31 = 117;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n31 = 54;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n32] = (char)(c8 ^ n31);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[6] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray24 = "9m+\u0014[\fx<\u0007EIa0\u0006E\u0000b>".toCharArray();
                                                                                cArray9 = cArray24;
                                                                                n11 = cArray24.length;
                                                                                n3 = 0;
                                                                                if (!true) break block142;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block143;
                                                                            }
                                                                            do {
                                                                                int n33;
                                                                                cArray9 = cArray9;
                                                                                int n34 = n3;
                                                                                char c9 = cArray9[n34];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n33 = 105;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n33 = 12;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n33 = 89;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n33 = 117;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n33 = 54;
                                                                                    }
                                                                                }
                                                                                cArray9[n34] = (char)(c9 ^ n33);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[7] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray25 = "9m+\u0014[\fx<\u0007EIb6\u0001\u0016\b,\n0g<I\u00176s".toCharArray();
                                                                        cArray8 = cArray25;
                                                                        n10 = cArray25.length;
                                                                        n3 = 0;
                                                                        if (!true) break block144;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block145;
                                                                    }
                                                                    do {
                                                                        int n35;
                                                                        cArray8 = cArray8;
                                                                        int n36 = n3;
                                                                        char c10 = cArray8[n36];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n35 = 105;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n35 = 12;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n35 = 89;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n35 = 117;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n35 = 54;
                                                                            }
                                                                        }
                                                                        cArray8[n36] = (char)(c10 ^ n35);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[8] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray26 = "9~0\u0003W\u001dit\u0003W\u0005y<UZ\fb>\u0001^Ix6\u001a\u0016\u000be>".toCharArray();
                                                                cArray7 = cArray26;
                                                                n9 = cArray26.length;
                                                                n3 = 0;
                                                                if (!true) break block146;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block147;
                                                            }
                                                            do {
                                                                int n37;
                                                                cArray7 = cArray7;
                                                                int n38 = n3;
                                                                char c11 = cArray7[n38];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n37 = 105;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n37 = 12;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n37 = 89;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n37 = 117;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n37 = 54;
                                                                    }
                                                                }
                                                                cArray7[n38] = (char)(c11 ^ n37);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[9] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray27 = "\u001fi+\u0006_\u0006by\u0018_\u001aa8\u0001U\u00016y]E\u001c|)\u001aD\u001di=O\u0016".toCharArray();
                                                        cArray6 = cArray27;
                                                        n8 = cArray27.length;
                                                        n3 = 0;
                                                        if (!true) break block148;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block149;
                                                    }
                                                    do {
                                                        int n39;
                                                        cArray6 = cArray6;
                                                        int n40 = n3;
                                                        char c12 = cArray6[n40];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n39 = 105;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n39 = 12;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n39 = 89;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n39 = 117;
                                                                break;
                                                            }
                                                            default: {
                                                                n39 = 54;
                                                            }
                                                        }
                                                        cArray6[n40] = (char)(c12 ^ n39);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[10] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray28 = "(`><RIe*UX\u0006xy\u0014\u0016:I\b s'O\u001c".toCharArray();
                                                cArray5 = cArray28;
                                                n7 = cArray28.length;
                                                n3 = 0;
                                                if (!true) break block150;
                                                n7 = n7;
                                                if (n7 <= n3) break block151;
                                            }
                                            do {
                                                int n41;
                                                cArray5 = cArray5;
                                                int n42 = n3;
                                                char c13 = cArray5[n42];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n41 = 105;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n41 = 12;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n41 = 89;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n41 = 117;
                                                        break;
                                                    }
                                                    default: {
                                                        n41 = 54;
                                                    }
                                                }
                                                cArray5[n42] = (char)(c13 ^ n41);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[11] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray29 = " N\u0014?u,,\u001d\u001cP\u000fe<X~\f`5\u0018W\u0007,\t\u0007_\u001fm-\u0010\u0016\"i O<\u00116S".toCharArray();
                                        cArray4 = cArray29;
                                        n6 = cArray29.length;
                                        n3 = 0;
                                        if (!true) break block152;
                                        n6 = n6;
                                        if (n6 <= n3) break block153;
                                    }
                                    do {
                                        int n43;
                                        cArray4 = cArray4;
                                        int n44 = n3;
                                        char c14 = cArray4[n44];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n43 = 105;
                                                break;
                                            }
                                            case 1: {
                                                n43 = 12;
                                                break;
                                            }
                                            case 2: {
                                                n43 = 89;
                                                break;
                                            }
                                            case 3: {
                                                n43 = 117;
                                                break;
                                            }
                                            default: {
                                                n43 = 54;
                                            }
                                        }
                                        cArray4[n44] = (char)(c14 ^ n43);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[12] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray30 = "\u00196S".toCharArray();
                                cArray3 = cArray30;
                                n5 = cArray30.length;
                                n3 = 0;
                                if (!true) break block154;
                                n5 = n5;
                                if (n5 <= n3) break block155;
                            }
                            do {
                                int n45;
                                cArray3 = cArray3;
                                int n46 = n3;
                                char c15 = cArray3[n46];
                                switch (n3 % 5) {
                                    case 0: {
                                        n45 = 105;
                                        break;
                                    }
                                    case 1: {
                                        n45 = 12;
                                        break;
                                    }
                                    case 2: {
                                        n45 = 89;
                                        break;
                                    }
                                    case 3: {
                                        n45 = 117;
                                        break;
                                    }
                                    default: {
                                        n45 = 54;
                                    }
                                }
                                cArray3[n46] = (char)(c15 ^ n45);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[13] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray31 = "c`c\u007f\u0016I,y".toCharArray();
                        cArray2 = cArray31;
                        n4 = cArray31.length;
                        n3 = 0;
                        if (!true) break block156;
                        n4 = n4;
                        if (n4 <= n3) break block157;
                    }
                    do {
                        int n47;
                        cArray2 = cArray2;
                        int n48 = n3;
                        char c16 = cArray2[n48];
                        switch (n3 % 5) {
                            case 0: {
                                n47 = 105;
                                break;
                            }
                            case 1: {
                                n47 = 12;
                                break;
                            }
                            case 2: {
                                n47 = 89;
                                break;
                            }
                            case 3: {
                                n47 = 117;
                                break;
                            }
                            default: {
                                n47 = 54;
                            }
                        }
                        cArray2[n48] = (char)(c16 ^ n47);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[14] = new String(cArray2).intern();
                var0 = null;
                char[] cArray32 = "\u000e6S".toCharArray();
                cArray = cArray32;
                n2 = cArray32.length;
                n3 = 0;
                if (!true) break block158;
                n2 = n2;
                if (n2 <= n3) break block159;
            }
            do {
                int n49;
                cArray = cArray;
                int n50 = n3;
                char c17 = cArray[n50];
                switch (n3 % 5) {
                    case 0: {
                        n49 = 105;
                        break;
                    }
                    case 1: {
                        n49 = 12;
                        break;
                    }
                    case 2: {
                        n49 = 89;
                        break;
                    }
                    case 3: {
                        n49 = 117;
                        break;
                    }
                    default: {
                        n49 = 54;
                    }
                }
                cArray[n50] = (char)(c17 ^ n49);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[15] = new String(cArray).intern();
        z = stringArray;
        PKCS8_VERSION = BigInteger.valueOf(0L);
    }
}

