/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.JLADataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.TraceFileDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.TraceSubscriberDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.EnvironmentDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.methoddictionary.MethodDictionaryDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterClientConnectedException;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterMBean;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthCenter
implements HealthCenterMBean {
    static final String DEBUG_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.debug";
    public static final int UNLIMITED_MAXSEND = -1;
    public static boolean isDebug = false;
    private int currentSession = -1;
    private static final int MIN_SESSION_NUMBER = 0;
    private final List<DataProvider> dataProviders;
    private final int _processId;
    private static final int DEFAULT_CLIENT_TIMEOUT = 600000;
    private int clientTimeout = 600000;
    private long lastConnectTime = 0L;

    public HealthCenter(int processId, HealthCenterOptionHandler handler) {
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            isDebug = true;
        }
        this._processId = processId;
        this.dataProviders = new ArrayList<DataProvider>();
        this.registerDataProviders(handler);
    }

    @Override
    public byte[] getJMXData(int dataProviderIndex, int session) throws HealthCenterClientConnectedException {
        this.checkValidSession(session);
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            return provider.getJMXData();
        }
        String message = MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex);
        return message.getBytes();
    }

    @Override
    public void resetJMXData(int dataProviderIndex, int session) throws HealthCenterClientConnectedException {
        this.checkValidSession(session);
        if (dataProviderIndex >= 0 && dataProviderIndex < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(dataProviderIndex);
            provider.resetData();
        } else {
            System.out.println(MessageFormat.format(Messages.getString("HealthCenter.no.jmx.source"), dataProviderIndex));
        }
    }

    private void registerDataProviders(HealthCenterOptionHandler handler) {
        TraceSubscriberDataProvider tracesubscriberDataProvider = new TraceSubscriberDataProvider(this._processId, handler);
        boolean subscriberAdded = this.addDataProvider(tracesubscriberDataProvider);
        if (!subscriberAdded) {
            TraceFileDataProvider traceFileDataProvider = new TraceFileDataProvider(this._processId, handler);
            this.addDataProvider(traceFileDataProvider);
        }
        EnvironmentDataProvider environmentDataProvider = new EnvironmentDataProvider(this._processId, handler);
        this.addDataProvider(environmentDataProvider);
        JLADataProvider lockingDataProvider = new JLADataProvider(handler);
        this.addDataProvider(lockingDataProvider);
        MethodDictionaryDataProvider methodDictionaryDataProvider = new MethodDictionaryDataProvider(handler);
        this.addDataProvider(methodDictionaryDataProvider);
    }

    private boolean addDataProvider(DataProvider dataProvider) {
        boolean dataAvailable = dataProvider.isDataSupported();
        if (dataAvailable) {
            this.dataProviders.add(dataProvider);
            if (isDebug) {
                System.out.println(MessageFormat.format("Added value {0} to position {1}  in _sources array", dataProvider, this.dataProviders.size()));
            }
        }
        return dataAvailable;
    }

    @Override
    public List<Map<String, String>> getLiveSourceDetails() {
        ArrayList<Map<String, String>> liveSourceDetails = new ArrayList<Map<String, String>>();
        for (DataProvider dataProvider : this.dataProviders) {
            liveSourceDetails.add(dataProvider.getLiveSourceDetails());
        }
        return liveSourceDetails;
    }

    @Override
    public synchronized int startSession() {
        for (DataProvider dataProvider : this.dataProviders) {
            dataProvider.startSession();
        }
        if (this.currentSession < Integer.MAX_VALUE) {
            ++this.currentSession;
            this.lastConnectTime = System.currentTimeMillis();
        }
        return this.currentSession;
    }

    private void checkValidSession(int session) throws HealthCenterClientConnectedException {
        if (isDebug) {
            String template = Messages.getString("HealthCenter.checking.session");
            System.out.println(MessageFormat.format(template, session, this.currentSession));
        }
        if (session > this.currentSession || session < 0) {
            throw new IllegalArgumentException(Messages.getString("HealthCenter.invalid.session.identifier"));
        }
        if (session != this.currentSession) {
            String message = Messages.getString("HealthCenter.invalid.session.error.message");
            throw new HealthCenterClientConnectedException(message);
        }
        this.lastConnectTime = System.currentTimeMillis();
    }

    @Override
    public boolean isClientsConnected() {
        boolean isConnected = false;
        if (this.currentSession >= 0) {
            long interval = System.currentTimeMillis() - this.lastConnectTime;
            isConnected = interval < (long)this.clientTimeout;
        }
        return isConnected;
    }

    @Override
    public void setClientTimeout(int time) {
        this.clientTimeout = time;
    }

    @Override
    public void modify(int source, int session, String command, String ... params) throws HealthCenterClientConnectedException, ProviderModificationException {
        this.checkValidSession(session);
        if (source >= 0 && source < this.dataProviders.size()) {
            DataProvider provider = this.dataProviders.get(source);
            provider.modify(command, params);
        }
    }
}

