/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.NetworkAddressFinder;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class HCLaunchMBean {
    private static final String START_MBEAN_SERVER_METHOD = "startMBeanServer";
    private static final String MBEAN_OBJECT_NAME = "IBM:type=HCMBeanServer";
    public static final String JMX_URL_TEMPLATE = "service:jmx:rmi://{0}:{1}/jndi/rmi://{2}:{3}/jmxrmi";
    private static final String JMX_REMOTE_X_ACCESS_FILE = "jmx.remote.x.access.file";
    private static final String JMX_REMOTE_X_PASSWORD_FILE = "jmx.remote.x.password.file";
    private final int MAX_PORTS_TO_TRY = 100;
    private final int MILLISECONDS_IN_A_SECOND = 1000;
    private int port = -1;
    private int pid = 0;
    private String className = this.getClass().getName();
    private boolean jmxBuilderSet = false;
    private HealthCenterOptionHandler handler;
    private Logger logger;
    private final NetworkAddressFinder networkAddressFinder;

    public static void main(String[] args) {
        HealthCenterOptionHandler handler = new HealthCenterOptionHandler(args);
        HCLaunchMBean launcher = new HCLaunchMBean(handler);
        launcher.startAgent();
    }

    public HCLaunchMBean(HealthCenterOptionHandler handler) {
        this.handler = handler;
        this.pid = handler.getPid();
        if (this.logger == null) {
            AgentLogFactory.setPid(this.pid);
            this.logger = AgentLogFactory.setUpLogging(this.getClass());
        }
        this.networkAddressFinder = new NetworkAddressFinder();
    }

    public int startAgent() {
        this.logger.fine("Starting Health Center agent initialization.");
        JmxStarterThread startThread = new JmxStarterThread(Messages.getString("HCLaunchMBean.jmx.starter.thread.name"), this.pid);
        this.logger.fine("Starting MBean starter thread.");
        startThread.start();
        while (startThread.isAlive()) {
            try {
                startThread.join();
            }
            catch (Exception e) {
                this.logger.fine("Interrupted joining Agent starter thread");
            }
        }
        this.port = startThread.getPort();
        if (this.port == -1) {
            this.logger.info(Messages.getString("HCLaunchMBean.agent.did.not.start.correctly"));
        } else {
            String formattedMessage = MessageFormat.format(Messages.getString("HCLaunchMBean.agent.started"), Integer.toString(this.port));
            this.logger.info(formattedMessage);
        }
        return this.port;
    }

    public int startMBeanServer(int port, int pid) {
        Registry registry;
        this.logger.entering(this.className, START_MBEAN_SERVER_METHOD);
        this.ensureNetworkAddressIsSensible();
        this.logger.fine(MessageFormat.format("Creating RMI registry on port {0}", Integer.toString(port)));
        try {
            registry = LocateRegistry.createRegistry(port);
        }
        catch (Exception e) {
            String template = Messages.getString("HCLaunchMBean.failed.to.create.rmi.registry");
            String formattedMessage = MessageFormat.format(template, Integer.toString(port), e.toString());
            this.logger.log(Level.WARNING, formattedMessage);
            if (port > this.handler.getStartPort() + 100) {
                return -1;
            }
            return this.startMBeanServer(++port, pid);
        }
        this.logger.fine(MessageFormat.format("RMI registry created on port {0}", Integer.toString(port)));
        boolean isLoadableBuilder = true;
        String originalBuilder = null;
        if (this.handler.isTryOverrideBuilder()) {
            originalBuilder = System.getProperty("javax.management.builder.initial");
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.original.builder"), originalBuilder));
            if (originalBuilder != null) {
                this.jmxBuilderSet = true;
                try {
                    Class.forName(originalBuilder);
                }
                catch (ClassNotFoundException e) {
                    isLoadableBuilder = false;
                    this.logger.fine("Clearing builder");
                    System.clearProperty("javax.management.builder.initial");
                }
                if (isLoadableBuilder) {
                    String template = "Loaded class {0} OK";
                    String message = MessageFormat.format("Loaded class {0} OK", originalBuilder);
                    this.logger.fine(message);
                }
            }
        }
        MBeanServer mbs = null;
        if (this.handler.isUsePlatformMBeanServer()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Getting platform MBean server");
            }
            mbs = ManagementFactory.getPlatformMBeanServer();
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Creating a new MBean server");
            }
            mbs = MBeanServerFactory.createMBeanServer();
        }
        this.logger.fine(MessageFormat.format("MBean server: {0}", mbs));
        if (this.jmxBuilderSet && !isLoadableBuilder) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Restoring builder to {0}", originalBuilder));
            }
            System.setProperty("javax.management.builder.initial", originalBuilder);
        }
        this.logger.fine(MessageFormat.format("Registering our MBean (PID: {0})", Integer.toString(pid)));
        try {
            HealthCenter mbean = new HealthCenter(pid, this.handler);
            ObjectName name = new ObjectName(MBEAN_OBJECT_NAME);
            mbs.registerMBean(mbean, name);
        }
        catch (Throwable e) {
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException e1) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.did.not.start"), e);
            e.printStackTrace();
            return -1;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Initialize the environment map");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        boolean auth = false;
        String autheFile = this.handler.getAutheFile();
        String authoFile = this.handler.getAuthoFile();
        if (autheFile != null && authoFile != null) {
            if (new File(autheFile).exists() && new File(authoFile).exists()) {
                env.put(JMX_REMOTE_X_PASSWORD_FILE, autheFile);
                env.put(JMX_REMOTE_X_ACCESS_FILE, authoFile);
                auth = true;
            } else {
                String template = Messages.getString("HCLaunchMBean.bad.authentication.file");
                String message = MessageFormat.format(template, autheFile, authoFile);
                this.logger.warning(message);
                return -1;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Creating an RMI connector server");
        }
        try {
            String hostname;
            if (this.networkAddressFinder.defaultAddressIsUnreliable()) {
                hostname = this.networkAddressFinder.getLocalAddress();
                if (hostname == null) {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
            } else {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            String portString = Integer.toString(port);
            JMXServiceURL url = new JMXServiceURL(MessageFormat.format(JMX_URL_TEMPLATE, hostname, portString, hostname, portString));
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(MessageFormat.format("Starting the RMI connector server ({0})", url));
            }
            cs.start();
            stopJMXConnectorThread stopJMXConnector = new stopJMXConnectorThread(cs);
            stopJMXConnector.start();
            String authWithWord = auth ? "with" : "without";
            this.logger.fine(MessageFormat.format("RMI connector server started {0} authentication.", authWithWord));
        }
        catch (Throwable e) {
            try {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            catch (NoSuchObjectException e1) {
                // empty catch block
            }
            this.logger.log(Level.SEVERE, Messages.getString("HCLaunchMBean.agent.failed.to.start"), e);
            return -1;
        }
        this.logger.exiting(this.className, START_MBEAN_SERVER_METHOD);
        return port;
    }

    private void ensureNetworkAddressIsSensible() {
        String localAddress;
        if (this.networkAddressFinder.defaultAddressIsUnreliable() && System.getProperty("java.rmi.server.hostname") == null && (localAddress = this.networkAddressFinder.getLocalAddress()) != null) {
            String hostAddress;
            String template = Messages.getString("HCLaunchMBean.overriding.network.address.warning");
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostAddress = Messages.getString("HCLaunchMBean.unknown.host");
            }
            String message = MessageFormat.format(template, localAddress, hostAddress, "java.rmi.server.hostname");
            this.logger.warning(message);
            System.setProperty("java.rmi.server.hostname", localAddress);
        }
    }

    public boolean stopMBeanServer(int port) {
        boolean stopped = false;
        try {
            Registry registry = LocateRegistry.getRegistry(port);
            stopped = UnicastRemoteObject.unexportObject(registry, true);
        }
        catch (Throwable e) {
            String template = Messages.getString("HCLaunchMBean.failed.to.stop.registry");
            String message = MessageFormat.format(template, port, e.toString());
            this.logger.log(Level.WARNING, message);
        }
        return stopped;
    }

    private class JmxStarterThread
    extends Thread {
        protected int port;
        protected int pid;

        public JmxStarterThread(String name, int pid) {
            super(name);
            this.port = -1;
            this.pid = 0;
            this.pid = pid;
        }

        public int getPort() {
            return this.port;
        }

        public void run() {
            int startDelaySeconds = HCLaunchMBean.this.handler.getStartDelaySeconds();
            if (startDelaySeconds > 0) {
                try {
                    Thread.sleep(startDelaySeconds * 1000);
                }
                catch (Exception e) {
                    HCLaunchMBean.this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.thread.interrupted"), this.getName()));
                }
            }
            HCLaunchMBean.this.logger.fine("Calling startMBeanServer");
            this.port = HCLaunchMBean.this.startMBeanServer(HCLaunchMBean.this.handler.getStartPort(), this.pid);
            HCLaunchMBean.this.logger.fine("startMBeanServer returned");
        }
    }

    public class stopJMXConnectorThread
    extends Thread {
        private final JMXConnectorServer cs;

        public stopJMXConnectorThread(JMXConnectorServer cs) {
            super(Messages.getString("HCLaunchMBean.thread.name"));
            this.cs = cs;
            this.setDaemon(true);
        }

        public void run() {
            this.stopJMXConnectorOnceNoThreadsRemain();
        }

        private void stopJMXConnectorOnceNoThreadsRemain() {
            this.blockUntilNoThreadsRemain();
            if (!HCLaunchMBean.this.handler.isKeepAlive()) {
                try {
                    String shutdownMessage = Messages.getString("HCLaunchMBean.stopping.jmx.connector.server");
                    HCLaunchMBean.this.logger.log(Level.FINE, shutdownMessage);
                    this.cs.stop();
                }
                catch (Throwable ex) {
                    String message = Messages.getString("HCLaunchMBean.problem.stopping.server");
                    HCLaunchMBean.this.logger.log(Level.WARNING, message, ex);
                }
            }
        }

        private void blockUntilNoThreadsRemain() {
            boolean threadsRemaining;
            do {
                threadsRemaining = false;
                Thread[] currentThreads = new Thread[Thread.activeCount()];
                Thread.enumerate(currentThreads);
                if (Thread.activeCount() > currentThreads.length) {
                    threadsRemaining = true;
                }
                for (Thread thread : currentThreads) {
                    if (thread == null || !thread.isAlive() || thread.isDaemon() || thread.getName().startsWith("RMI Reaper")) continue;
                    threadsRemaining = true;
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            } while (threadsRemaining);
        }
    }
}

