

// global variable for storing the current language
var language;

// global variable for storing the current language ID
var langID;

// global variable for storing NLS array
var arrayID;

// variables to store language IDs
// if the script finds this string in the URL, it chooses the language associated.
var eng = "?eng";
var por = "?por";
var pol = "?pol";
var ita = "?ita";
var esp = "?esp";
var fra = "?fra";
var ger = "?ger";
var chi = "?chi";
var tch = "?tch";
var jap = "?jap";
var kor = "?kor";
var czn = "?czn";
var tur = "?tur";
var cat = "?cat";
var hun = "?hun";
var rus = "?rus";
var slk = "?slk";
var slv = "?slv";

//the following arrays contain the names of the guides
var arrayGuideName = new Array("SDK and Runtime Environment Guide", "Java Security Guide", "Readmefirst", 
									"RMI-IIOP Guide", "Information for Japanese Users", "License", "Copyright", "Notices");

//the following function chooses the language in which to display the guides, based on the choice the user made in the
//startHere.htm page - the language is selected depending on the URL of the container page (index.en.html?language)
function chooseLanguage() {
    
    loc = parent.location.href; // get URL of the container page, index.en.html
    
    var langPath = new Array;

    //the following if..else block check which language the guides should be displayed in, and sets the variables
    // language, langId, and arrayID to the appropriate values
    if(loc.indexOf(eng) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="en";
        langPath[1]="en";
    }
    else if(loc.indexOf(por) != -1){
        arrayID = arrayGuideName;
        langPath[0]="pt";
        langPath[1]="pt";
    }
    else if(loc.indexOf(ita) != -1){
        arrayID = arrayGuideName;
        langPath[0]="it";
        langPath[1]="it";
    }
    else if(loc.indexOf(esp) != -1){
        arrayID = arrayGuideName;
        langPath[0]="es";
        langPath[1]="es";
    }
    else if(loc.indexOf(fra) != -1){
        arrayID = arrayGuideName;
        langPath[0]="fr";
        langPath[1]="fr";
    }
    else if(loc.indexOf(ger) != -1){
        arrayID = arrayGuideName;
        langPath[0]="de";
        langPath[1]="de";
    }
    else if(loc.indexOf(chi) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="zh_Hans";
        langPath[1]="zh_Hans";
    }
    else if(loc.indexOf(tch) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="zh_Hant";
        langPath[1]="zh_Hant";
    }
    else if(loc.indexOf(jap) != -1) {
        arrayID = arrayGuideName;
        langPath[0]="ja";
        langPath[1]="ja";
    }
    else if(loc.indexOf(kor) != -1){
        arrayID = arrayGuideName;
        langPath[0]="ko";
        langPath[1]="ko";
    }
    else if(loc.indexOf(czn) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; // normal guides not translated
        langPath[1]="cs";
    }
    else if(loc.indexOf(tur) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="tr";
    }
    else if(loc.indexOf(pol) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="pl";
    }
    else if(loc.indexOf(cat) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="ca";
    }
    else if(loc.indexOf(hun) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="hu";
    }
    else if(loc.indexOf(rus) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="ru";
    }
    else if(loc.indexOf(slk) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="sk";
    }
    else if(loc.indexOf(slv) != -1){
        arrayID = arrayGuideName;
        langPath[0]="en"; //normal guides not translated
        langPath[1]="sl";
    }
    
return langPath;

}
    
function createAssocArray(guidesArray) {
    chooseLanguage();
    var twoDimArray = new Array;
    for(i=0; i<guidesArray.length; i++) {
        
        if(guidesArray[i].indexOf("sdkandruntime") != -1) {
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[0];
        }                  
        else if (guidesArray[i].indexOf("securityguide") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[1];
        }
        else if (guidesArray[i].indexOf("readmefirst") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[2];
        }
        else if (guidesArray[i].indexOf("rmi") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[3];
        }
        else if (guidesArray[i].indexOf("japanese") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[4];
        }   
        else if (guidesArray[i].indexOf("license") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[5];
        }   
        else if (guidesArray[i].indexOf("COPYRIGHT") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[6];
        }   
        else if (guidesArray[i].indexOf("otices") != -1){
            twoDimArray[i] = new Array(2);
            twoDimArray[i][0] = guidesArray[i];
            twoDimArray[i][1] = arrayID[7];
        }   
    }
    //alert("The chosen language is: " + language + "\nLanguage ID: " + langId + "\narrayId: " + arrayID);
    return twoDimArray;
}

//the following function writes the TOC in the toc.htm file
//first it calls the function createAssocArray() on an array that has a list of the
//file paths to the various user guides. this results in a 2-dimensional array that has the
//path of the user guide and the name to display in the browser. 
//after writing the opening <UL> tag, this function iterates through the 2-dimensional array to
//create the links to the various user guides
function writeToc(arrayGuidePaths) {
    var twoDim = createAssocArray(arrayGuidePaths); // create 2-dimensional array from array containing user guide paths
    document.write("<UL>"); // write opening <UL> tag
    
    //iterate through 2-dim array and write links in toc.htm file  
    for (i=0; i<twoDim.length; i++){
        document.write("<LI><A href='" + twoDim[i][0] + "' target='Content'>" + twoDim[i][1] + "</A></LI>");
    }
    
    document.write("</UL>"); // write closing </UL> tag

}
        

