/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.DynamicStub;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.org.omg.CORBA.AttributeDescription;
import com.ibm.org.omg.CORBA.Initializer;
import com.ibm.org.omg.CORBA.OperationDescription;
import com.ibm.org.omg.CORBA.ValueDefPackage.FullValueDescription;
import com.ibm.org.omg.CORBA._IDLTypeStub;
import com.ibm.rmi.ORB;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.rmi.CORBA.ClassDesc;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;

public class ValueUtility {
    private static final String thisClassName = "com.ibm.rmi.io.ValueUtility";
    public static final short PRIVATE_MEMBER = 0;
    public static final short PUBLIC_MEMBER = 1;
    private static final String[] primitiveConstants = new String[]{null, null, "S", "I", "S", "I", "F", "D", "Z", "C", "B", null, null, null, null, null, null, null, null, null, null, null, null, "J", "J", "D", "C", null, null, null, null, null, null};
    private static final Class[] primitiveTypes = new Class[]{null, null, Short.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, java.lang.Object.class, null, null, java.lang.Object.class, null, null, null, null, null, null, java.lang.Object.class, null, Long.TYPE, Long.TYPE, Double.TYPE, Character.TYPE, null, null, java.lang.Object.class, java.lang.Object.class, null, java.lang.Object.class};
    private static org.omg.CORBA.ORB orb = null;
    private static final Class[] kNoParamTypes = new Class[0];
    private static final java.lang.Object[] kNoArgs = new java.lang.Object[0];

    public static String getSignature(ValueMember valueMember) throws ClassNotFoundException {
        int n = valueMember.type.kind().value();
        switch (n) {
            case 11: 
            case 14: 
            case 21: 
            case 29: 
            case 30: 
            case 32: {
                Class clazz = RepositoryId.get(valueMember.id).getClassFromType();
                return ObjectStreamClass.getSignature(clazz);
            }
        }
        return primitiveConstants[n];
    }

    public static Class getType(ValueMember valueMember) {
        return primitiveTypes[valueMember.type.kind().value()];
    }

    public static FullValueDescription translate(ObjectStreamClass objectStreamClass, PartnerVersion partnerVersion) {
        int n;
        if (orb == null) {
            orb = org.omg.CORBA.ORB.init();
        }
        FullValueDescription fullValueDescription = new FullValueDescription();
        fullValueDescription.id = RepositoryId.createForJavaType(objectStreamClass.forClass(), false, partnerVersion);
        RepositoryId repositoryId = RepositoryId.get(fullValueDescription.id);
        fullValueDescription.name = repositoryId.getUnqualifiedName();
        fullValueDescription.is_abstract = objectStreamClass.isAbstractInterface(partnerVersion);
        fullValueDescription.is_custom = objectStreamClass.isCustomMarshaled();
        fullValueDescription.defined_in = repositoryId.getDefinedInId();
        fullValueDescription.version = repositoryId.getSerialVersionUID();
        if (fullValueDescription.version == null) {
            fullValueDescription.version = repositoryId.getVersionString().substring(1);
        }
        fullValueDescription.operations = new OperationDescription[0];
        fullValueDescription.attributes = new AttributeDescription[0];
        fullValueDescription.members = ValueUtility.getMembers(orb, objectStreamClass, false, partnerVersion);
        fullValueDescription.initializers = new Initializer[0];
        Class<?>[] classArray = objectStreamClass.forClass().getInterfaces();
        int n2 = 0;
        fullValueDescription.supported_interfaces = new String[classArray.length];
        for (n = 0; n < classArray.length; ++n) {
            fullValueDescription.supported_interfaces[n] = RepositoryId.createForAnyType(classArray[n]);
            if (Remote.class.isAssignableFrom(classArray[n]) && Modifier.isPublic(classArray[n].getModifiers())) continue;
            ++n2;
        }
        fullValueDescription.abstract_base_values = new String[n2];
        n2 = 0;
        for (n = 0; n < classArray.length; ++n) {
            if (Remote.class.isAssignableFrom(classArray[n]) && Modifier.isPublic(classArray[n].getModifiers())) continue;
            fullValueDescription.abstract_base_values[n2++] = RepositoryId.createForAnyType(classArray[n]);
        }
        fullValueDescription.is_truncatable = false;
        Class clazz = objectStreamClass.forClass().getSuperclass();
        fullValueDescription.base_value = clazz != null && Serializable.class.isAssignableFrom(clazz) ? RepositoryId.createForJavaType(clazz, false, partnerVersion) : "";
        fullValueDescription.type = ValueUtility.getTypeCode(orb, objectStreamClass.forClass(), partnerVersion);
        return fullValueDescription;
    }

    private static ValueMember[] getMembers(org.omg.CORBA.ORB oRB, ObjectStreamClass objectStreamClass, boolean bl, PartnerVersion partnerVersion) {
        ObjectStreamField[] objectStreamFieldArray = null;
        objectStreamFieldArray = bl ? objectStreamClass.getLocalFields() : objectStreamClass.getFields();
        int n = objectStreamFieldArray.length;
        ValueMember[] valueMemberArray = new ValueMember[n];
        block10: for (int i = 0; i < n; ++i) {
            int n2;
            valueMemberArray[i] = new ValueMember();
            valueMemberArray[i].id = RepositoryId.createForJavaType(objectStreamFieldArray[i].getClazz(), false, partnerVersion);
            RepositoryId repositoryId = RepositoryId.get(valueMemberArray[i].id);
            valueMemberArray[i].name = objectStreamFieldArray[i].getName();
            valueMemberArray[i].defined_in = repositoryId.getDefinedInId();
            valueMemberArray[i].version = "1.0";
            valueMemberArray[i].type_def = new _IDLTypeStub();
            valueMemberArray[i].access = objectStreamFieldArray[i].getField() == null ? (short)0 : (Modifier.isPublic(n2 = objectStreamFieldArray[i].getField().getModifiers()) ? (short)1 : 0);
            switch (objectStreamFieldArray[i].getTypeCode()) {
                case 'B': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_octet);
                    continue block10;
                }
                case 'C': {
                    if (PartnerVersionUtil.useWChar(partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor())) {
                        valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_char);
                        continue block10;
                    }
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_wchar);
                    continue block10;
                }
                case 'F': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_float);
                    continue block10;
                }
                case 'D': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_double);
                    continue block10;
                }
                case 'I': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_long);
                    continue block10;
                }
                case 'J': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_longlong);
                    continue block10;
                }
                case 'S': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_short);
                    continue block10;
                }
                case 'Z': {
                    valueMemberArray[i].type = oRB.get_primitive_tc(TCKind.tk_boolean);
                    continue block10;
                }
                default: {
                    valueMemberArray[i].type = ValueUtility.getTypeCode(oRB, objectStreamFieldArray[i].getClazz(), partnerVersion);
                    valueMemberArray[i].id = RepositoryId.createForAnyType(objectStreamFieldArray[i].getType(), false, partnerVersion);
                }
            }
        }
        return valueMemberArray;
    }

    public static TypeCode getTypeCode(org.omg.CORBA.ORB oRB, java.lang.Object object) {
        return ValueUtility.getTypeCode(oRB, object, PartnerVersion.UNKNOWN);
    }

    public static TypeCode getTypeCode(org.omg.CORBA.ORB oRB, java.lang.Object object, PartnerVersion partnerVersion) {
        Class<?> clazz = object.getClass();
        Map map = ClassToTypecodeCache.getCache(oRB, partnerVersion);
        TypeCode typeCode = (TypeCode)map.get(clazz);
        if (typeCode != null) {
            return typeCode;
        }
        if (object instanceof Object) {
            String[] stringArray = object instanceof DynamicStub ? ((DynamicStub)object).getStub()._ids() : ((ObjectImpl)object)._ids();
            typeCode = oRB.create_interface_tc(stringArray[0], "");
            map.put(clazz, typeCode);
            return typeCode;
        }
        if (object instanceof Serializable) {
            return ValueUtility.createTypeCodeForClass(oRB, clazz, map, partnerVersion);
        }
        Utility.throwNotSerializableForCorba(clazz.getName());
        throw new INTERNAL("reached unreachable path!", 1229125047, CompletionStatus.COMPLETED_MAYBE);
    }

    public static TypeCode getTypeCode(org.omg.CORBA.ORB oRB, Class clazz) {
        return ValueUtility.getTypeCode(oRB, clazz, PartnerVersion.UNKNOWN);
    }

    public static TypeCode getTypeCode(org.omg.CORBA.ORB oRB, Class clazz, PartnerVersion partnerVersion) {
        Map map = ClassToTypecodeCache.getCache(oRB, partnerVersion);
        TypeCode typeCode = (TypeCode)map.get(clazz);
        if (typeCode != null) {
            return typeCode;
        }
        if (Object.class.isAssignableFrom(clazz)) {
            String string = RepositoryId.createForAnyType(clazz, false, partnerVersion);
            typeCode = oRB.create_interface_tc(string, "");
            map.put(clazz, typeCode);
            return typeCode;
        }
        return ValueUtility.createTypeCodeForClass(oRB, clazz, map, partnerVersion);
    }

    private static TypeCode createTypeCodeForClass(org.omg.CORBA.ORB oRB, Class clazz, Map map, PartnerVersion partnerVersion) {
        TypeCode typeCode = null;
        short s = partnerVersion.getPartnerMajor();
        short s2 = partnerVersion.getPartnerMinor();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, s, s2);
        String string = RepositoryId.createForJavaType(clazz, false, partnerVersion);
        if (objectStreamClass.isRemoteInterface()) {
            typeCode = oRB.create_interface_tc(string, "");
        } else if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            TypeCode typeCode2 = clazz2.isPrimitive() ? ValueUtility.getPrimitiveTypeCodeForClass(oRB, clazz2) : ValueUtility.getTypeCode(oRB, clazz2, partnerVersion);
            TypeCode typeCode3 = oRB.create_sequence_tc(0, typeCode2);
            typeCode = oRB.create_value_box_tc(string, "", typeCode3);
        } else if (clazz == String.class) {
            TypeCode typeCode4 = oRB.create_wstring_tc(0);
            typeCode = oRB.create_value_box_tc(string, "", typeCode4);
        } else if (objectStreamClass.isAny()) {
            typeCode = oRB.create_alias_tc(string, "", oRB.get_primitive_tc(TCKind.tk_any));
        } else if (IDLEntity.class.isAssignableFrom(clazz)) {
            typeCode = ValueUtility.getTypeFromHelper(oRB, clazz, partnerVersion);
        } else if (objectStreamClass.isAbstractInterface(partnerVersion)) {
            typeCode = oRB.create_abstract_interface_tc(string, "");
        } else {
            typeCode = ValueUtilityLock.createValueTC(oRB, clazz, string, objectStreamClass, map, partnerVersion);
            return typeCode;
        }
        map.put(clazz, typeCode);
        return typeCode;
    }

    private static TypeCode getPrimitiveTypeCodeForClass(org.omg.CORBA.ORB oRB, Class clazz) {
        if (clazz == Integer.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_long);
        }
        if (clazz == Byte.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_octet);
        }
        if (clazz == Long.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_longlong);
        }
        if (clazz == Float.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_float);
        }
        if (clazz == Double.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_double);
        }
        if (clazz == Short.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_short);
        }
        if (clazz == Character.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_wchar);
        }
        if (clazz == Boolean.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_boolean);
        }
        throw new INTERNAL("Class is not primitive type", 1229125020, CompletionStatus.COMPLETED_NO);
    }

    private static TypeCode getTypeFromHelper(org.omg.CORBA.ORB oRB, Class clazz, PartnerVersion partnerVersion) {
        try {
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(), clazz, clazz.getClassLoader());
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod("type", kNoParamTypes);
                }
            });
            short s = partnerVersion.getPartnerMajor();
            short s2 = partnerVersion.getPartnerMinor();
            TypeCode typeCode = (TypeCode)method.invoke(null, kNoArgs);
            String string = RepositoryId.createForJavaType(clazz, false, partnerVersion);
            return oRB.create_value_box_tc(string, "", typeCode);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getTypeCodeFromHelper:603", (Exception)classNotFoundException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getTypeCodeFromHelper:607", privilegedActionException.getException());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getTypeCodeFromHelper:615", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, thisClassName, "getTypeCodeFromHelper:619", throwable.getMessage(), (java.lang.Object)throwable);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "getTypeCodeFromHelper:623", (Exception)illegalAccessException);
        }
        return oRB.create_value_tc("IDL:omg.org/CORBA/ValueBase:1.0", "", (short)0, oRB.get_primitive_tc(TCKind.tk_null), new ValueMember[0]);
    }

    private static class ValueUtilityLock {
        private static Map inProgress = new HashMap(16);
        private boolean recursive = false;
        private int count = 0;

        private ValueUtilityLock() {
        }

        private static synchronized ValueUtilityLock getLock(Class clazz) {
            ValueUtilityLock valueUtilityLock = (ValueUtilityLock)inProgress.get(clazz);
            if (valueUtilityLock == null) {
                valueUtilityLock = new ValueUtilityLock();
                inProgress.put(clazz, valueUtilityLock);
            }
            ++valueUtilityLock.count;
            return valueUtilityLock;
        }

        private static synchronized void releaseLock(Class clazz, ValueUtilityLock valueUtilityLock) {
            if (--valueUtilityLock.count == 0) {
                inProgress.remove(clazz);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TypeCode createValueTC(org.omg.CORBA.ORB oRB, Class clazz, String string, ObjectStreamClass objectStreamClass, Map map, PartnerVersion partnerVersion) {
            ValueUtilityLock valueUtilityLock = ValueUtilityLock.getLock(clazz);
            try {
                TypeCode typeCode = valueUtilityLock.createTC(oRB, clazz, string, objectStreamClass, map, partnerVersion);
                return typeCode;
            }
            finally {
                ValueUtilityLock.releaseLock(clazz, valueUtilityLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized TypeCode createTC(org.omg.CORBA.ORB oRB, Class clazz, String string, ObjectStreamClass objectStreamClass, Map map, PartnerVersion partnerVersion) {
            TypeCode typeCode = (TypeCode)map.get(clazz);
            if (typeCode != null) {
                return typeCode;
            }
            if (this.recursive) {
                return oRB.create_recursive_tc(string);
            }
            this.recursive = true;
            try {
                Class clazz2;
                if (clazz == Class.class) {
                    clazz2 = ClassDesc.class;
                    objectStreamClass = ObjectStreamClass.lookup(clazz2, partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor());
                } else {
                    clazz2 = clazz;
                }
                short s = Serializable.class.isAssignableFrom(clazz2) ? (objectStreamClass.isCustomMarshaled() ? (short)1 : 0) : (short)2;
                Class clazz3 = clazz2.getSuperclass();
                TypeCode typeCode2 = clazz3 == java.lang.Object.class || clazz3 == null ? oRB.get_primitive_tc(TCKind.tk_null) : ValueUtility.getTypeCode(oRB, clazz3, partnerVersion);
                ValueMember[] valueMemberArray = ValueUtility.getMembers(oRB, objectStreamClass, true, partnerVersion);
                typeCode = oRB.create_value_tc(string, "", s, typeCode2, valueMemberArray);
                map.put(clazz, typeCode);
                TypeCode typeCode3 = typeCode;
                return typeCode3;
            }
            finally {
                this.recursive = false;
            }
        }
    }

    static class ClassToTypecodeCache {
        private static Map ABSTRACT_COMPLIANT = Collections.synchronizedMap(new WeakHashMap(16));
        private static Map ABSTRACT_NONCOMPLIANT = Collections.synchronizedMap(new WeakHashMap(16));
        private static HashMap orbCache = new HashMap(4);

        ClassToTypecodeCache() {
        }

        static Map getCache(org.omg.CORBA.ORB oRB, PartnerVersion partnerVersion) {
            if (oRB instanceof ORB) {
                if (PartnerVersionUtil.useInheritedMethods(partnerVersion.getPartnerMajor(), partnerVersion.getPartnerMinor())) {
                    return ABSTRACT_COMPLIANT;
                }
                return ABSTRACT_NONCOMPLIANT;
            }
            return ClassToTypecodeCache.getCacheForNonIBMORB(oRB);
        }

        private static synchronized Hashtable getCacheForNonIBMORB(org.omg.CORBA.ORB oRB) {
            Hashtable hashtable = (Hashtable)orbCache.get(oRB);
            if (hashtable == null) {
                hashtable = new Hashtable(16);
                orbCache.put(oRB, hashtable);
            }
            return hashtable;
        }
    }
}

