/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.WorkQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class WorkerThread
implements Runnable {
    private final WorkQueue workQueue;
    private final long inactivityTimeout;
    private final boolean isCached;
    private final String threadName;

    public WorkerThread(long l, boolean bl, WorkQueue workQueue, String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:144");
        }
        this.inactivityTimeout = l;
        this.isCached = bl;
        this.workQueue = workQueue;
        this.threadName = string;
        final WorkerThread workerThread = this;
        Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup threadGroup2 = threadGroup.getParent();
                while (threadGroup2 != null) {
                    threadGroup = threadGroup2;
                    threadGroup2 = threadGroup.getParent();
                }
                Thread thread = new Thread(threadGroup, workerThread, WorkerThread.this.threadName);
                thread.setDaemon(true);
                return thread;
            }
        });
        thread.start();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:183");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block12: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, this, "run:192");
            }
            if (this.isCached) {
                try {
                    while (true) {
                        WorkUnit workUnit;
                        if ((workUnit = this.getWork()) == null) {
                            break block12;
                        }
                        workUnit.doWork();
                    }
                }
                catch (Throwable throwable) {
                    ORBRas.orbTrcLogger.trace(4104L, (Object)this, "run:207", "WorkerThread " + this.threadName + " terminated prematurely. Exception text: " + throwable.getMessage(), (Object)throwable);
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    break block12;
                }
                finally {
                    this.workQueue.removeThread(this);
                }
            }
            WorkUnit workUnit = this.getWork();
            if (workUnit != null) {
                workUnit.doWork();
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "run:227");
        }
    }

    String getName() {
        return this.threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkUnit getWork() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            this.workQueue.incrementWorkerCount();
            WorkUnit workUnit = this.workQueue.getWorkToDo();
            long l = this.inactivityTimeout <= 0L ? 0L : System.currentTimeMillis();
            long l2 = this.inactivityTimeout;
            while (workUnit == null && !this.workQueue.isShutdownPending() && l2 >= 0L) {
                try {
                    this.workQueue.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = this.inactivityTimeout - (System.currentTimeMillis() - l);
                workUnit = this.workQueue.getWorkToDo();
            }
            this.workQueue.decrementWorkerCount();
            return workUnit;
        }
    }
}

