/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionInfo;
import com.ibm.CORBA.iiop.DynamicStub;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.IOR;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.DisconnectedDelegate;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.ConnectionInfoImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.io.ValueHandlerPool;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.Interop;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.rmi.util.buffer.SequentialByteBuffer;
import com.ibm.rmi.util.buffer.SimpleByteBuffer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueOutputStream;
import sun.util.calendar.ZoneInfo;

public class CDROutputStream
extends com.ibm.CORBA.iiop.CDROutputStream
implements DataOutputStream,
ValueOutputStream,
PartnerVersion {
    private static final String CLASS = CDROutputStream.class.getName();
    private static final byte PAD_BYTE = -67;
    public final Interop interop;
    protected boolean littleEndian;
    protected int offset;
    protected ByteBuffer byteBuf;
    protected org.omg.CORBA.ORB orb;
    private ByteBuffer.Position blockSizePosition = null;
    protected boolean startNewChunk;
    protected boolean writingChunkMarker;
    private boolean paddingPending = false;
    protected int tcsChar = 0;
    protected int tcsWChar = 0;
    protected CharToTcsConverter tcsCConverter = null;
    protected CharToTcsConverter tcsWConverter = null;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private Hashtable codebaseCache = null;
    private IdentityHashtable valueCache = null;
    private Hashtable repositoryIdCache = null;
    private int end_flag = 0;
    private boolean mustChunk = false;
    private boolean inBlock = false;
    private ByteBuffer.Position endFlagPosition = null;
    private ValueHandlerImpl valueHandler = null;
    private int firstNullTc = -1;
    private int firstStringTc = -1;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = (byte)2;
    private boolean preGIOP12_CDR = false;
    private boolean fragmentable = false;
    protected int fragSize = 0;
    private int requestedBufLen = 0;
    private int addIndirectionBytes = 0;
    private short partnerMajor = (short)-1;
    private short partnerMinor = (short)-1;
    private short partnerExtended = (short)-1;
    private byte streamFormatVersion = 1;
    private boolean checkedOptimisedTCVersion = false;
    private boolean optimisedTCVersion;
    private boolean checkedOldNullTC = false;
    private boolean oldNullTC;
    private int oldSUID = -1;
    private boolean prevMustChunk = false;
    private java.lang.Object currentObject = null;
    public static final java.lang.Object PENDING_WRITE = new java.lang.Object();
    private static final int cfwFragSizeOffset = 16;
    private boolean useCFW;
    private GIOPConnectionInfo connInfo = ConnectionInfoImpl.unconnected;
    private Hashtable typeMap = null;
    private byte[] tempData = new byte[8];
    private static final int[] SWAPBYTE_SHIFTS = new int[]{0, 8, 16, 24, 32, 40, 48, 56};
    private static final int[][] NOSWAPBYTES_SHIFTS = new int[][]{{8, 0}, {24, 16, 8, 0}, {56, 48, 40, 32, 24, 16, 8, 0}};
    public static TypeCodeImpl boxStringTC = new TypeCodeImpl(null, 30, RepositoryId.createForJavaType(String.class), "", TypeCodeImpl.get_primitive_tc(27));
    public static TypeCodeImpl abstractBaseTC = TypeCodeImpl.get_primitive_tc(32);
    private static String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static String[] _ids = new String[]{_id};
    protected boolean haveCheckedOldNestingDepths;
    protected boolean useOldNestingDepths;
    private static final long serialVersionUID = 0L;

    public CDROutputStream(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, byte by, byte by2) {
        this(oRB, false);
        this.setGIOPVersion(by, by2, false);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 0);
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = (com.ibm.rmi.ORB)oRB;
        this.littleEndian = bl;
        this.requestedBufLen = n;
        this.offset = 0;
        if (oRB instanceof com.ibm.rmi.ORB) {
            this.interop = ((com.ibm.rmi.ORB)oRB).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
            this.useCFW = ((com.ibm.rmi.ORB)oRB).useChannelFramework();
        } else {
            this.interop = Interop.NO_IBM_ORB;
            this.useCFW = false;
        }
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, int n, int n2) {
        this(oRB, false);
        this.setCodeSets(n, n2);
    }

    public CDROutputStream() {
        this.interop = Interop.NO_IBM_ORB;
    }

    public CDROutputStream(CDROutputStream cDROutputStream) {
        this(cDROutputStream.orb, cDROutputStream.littleEndian);
        this.typeMap = cDROutputStream.getTypeMap();
        cDROutputStream.alignAndReserve(4, 4);
        this.offset = cDROutputStream.get_offset(true) + 4;
        this.setGIOPVersion(cDROutputStream.GIOPMajor, cDROutputStream.GIOPMinor, false);
    }

    void setConnectionInfo(GIOPConnectionInfo gIOPConnectionInfo) {
        this.connInfo = gIOPConnectionInfo;
    }

    public void setGIOPVersions(byte by, byte by2, short s, short s2, short s3, byte by3) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
        this.partnerExtended = s3;
        this.setGIOPVersion(by, by2, false);
        if (by3 > 0 && by3 <= 2) {
            this.setStreamFormatVersion(by3);
        }
    }

    public void setGIOPVersion(byte by, byte by2) {
        this.setGIOPVersion(by, by2, false);
    }

    public void setGIOPVersion(byte by, byte by2, boolean bl) {
        if (by != 1 || by2 > 2) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("Invalid GIOP level: " + by + "." + by2);
            ORBRas.orbTrcLogger.exception(4104L, this, "setGIOPVersion:390", (Exception)((java.lang.Object)bAD_PARAM));
            throw bAD_PARAM;
        }
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        if (by == 1 && by2 <= 1) {
            this.preGIOP12_CDR = true;
            this.fragmentable = false;
            this.fragSize = 0;
        } else {
            this.preGIOP12_CDR = false;
            this.fragmentable = bl;
        }
        if (by == 1 && by2 <= 2) {
            short s;
            short s2 = this.getPartnerMajor();
            if (PartnerVersionUtil.useStreamFormat2(s2, s = this.getPartnerMinor())) {
                this.setStreamFormatVersion((byte)2);
            } else {
                this.setStreamFormatVersion((byte)1);
            }
        } else {
            this.setStreamFormatVersion((byte)2);
        }
    }

    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    public void setStreamFormatVersion(byte by) {
        this.streamFormatVersion = by;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "setStreamFormatVersion:441", "custom stream format=" + this.streamFormatVersion);
        }
    }

    public short getPartnerMajor() {
        if (this.partnerMajor == -1) {
            this.partnerMajor = this.connInfo.getPartnerMajor();
        }
        return this.partnerMajor;
    }

    public short getPartnerMinor() {
        if (this.partnerMinor == -1) {
            this.partnerMinor = this.connInfo.getPartnerMinor();
        }
        return this.partnerMinor;
    }

    public short getPartnerExtended() {
        if (this.partnerExtended == -1) {
            this.partnerExtended = this.connInfo.getPartnerExtended();
        }
        return this.partnerExtended;
    }

    public void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
        this.tcsCConverter = null;
        this.tcsWConverter = null;
    }

    public void setPartnerVersion(int n) {
        this.partnerMajor = PartnerVersionUtil.unpackMajor(n);
        this.partnerMinor = PartnerVersionUtil.unpackMinor(n);
    }

    public final byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    public int getCharCodeSet() {
        return this.tcsChar;
    }

    public int getWCharCodeSet() {
        return this.tcsWChar;
    }

    public void addTypePosition(TypeCodeImpl typeCodeImpl, int n) {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        this.typeMap.put(typeCodeImpl, new Integer(n));
    }

    public int getTypePosition(TypeCodeImpl typeCodeImpl) {
        if (this.typeMap == null) {
            return -1;
        }
        java.lang.Object v = this.typeMap.get((java.lang.Object)typeCodeImpl);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public void enableLargeDataBufferPool() {
    }

    public void disableLargeDataBufferPool() {
    }

    public void releaseBuffer() {
        if (this.byteBuf != null) {
            this.byteBuf.reset();
        }
    }

    private Hashtable getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        return this.typeMap;
    }

    public byte[] toByteArray() {
        byte[] byArray = this.byteBuf == null ? ByteBuffer.ZERO_BYTE_ARRAY : this.byteBuf.toByteArray();
        return byArray;
    }

    void setPaddingPending() {
        this.paddingPending = true;
    }

    void clearPaddingPending() {
        this.paddingPending = false;
    }

    boolean isPaddingPending() {
        return this.paddingPending;
    }

    void checkPadding() {
        if (this.paddingPending) {
            this.paddingPending = false;
            this.align(8);
            this.recordBodyPosition();
        }
    }

    protected void recordBodyPosition() {
    }

    private void pad(int n) {
        for (int i = 0; i < n; ++i) {
            this.byteBuf.write((byte)-67);
        }
    }

    final void align(int n) {
        if (n > 1) {
            if (this.byteBuf == null) {
                this.allocateBuffer();
            } else {
                int n2 = this.byteBuf.getWriteOffset() & n - 1;
                if (n2 != 0) {
                    n2 = n - n2;
                    this.pad(n2);
                }
            }
        }
    }

    private final int alignAndReserve(int n, int n2) {
        int n3 = 0;
        if (this.byteBuf != null) {
            this.align(n);
        } else {
            this.allocateBuffer();
        }
        n3 = this.byteBuf.getAvailableSpace();
        if (n > n3) {
            this.completeFragment(n2);
            n3 = this.byteBuf.getAvailableSpace();
        }
        n3 = Math.min(n2, n3);
        return n3 / n;
    }

    private final void completeFragment(int n) {
        if (this.inBlock && !this.startNewChunk && !this.writingChunkMarker) {
            this.end_block(n, true);
            this.sendFragment();
            this.startNewChunk = true;
        } else {
            this.sendFragment();
            if (this.writingChunkMarker) {
                this.align(4);
                this.blockSizePosition = this.byteBuf.getWritePosition();
            }
        }
        this.endFlagPosition = null;
    }

    private final void allocateBuffer() {
        this.fragSize = 0;
        if (this.fragmentable && this.orb != null) {
            this.fragSize = ((ORB)this.orb).getFragmentSize();
            if (this.fragSize < 0) {
                this.fragSize = 0;
            }
        }
        if (this.fragSize > 0) {
            this.byteBuf = new SimpleByteBuffer(this.useCFW ? this.fragSize - 16 : this.fragSize);
        } else {
            int n = this.requestedBufLen > 0 ? this.requestedBufLen : 1024;
            this.byteBuf = new SequentialByteBuffer(this.useCFW ? n - 16 : n);
        }
    }

    protected void sendFragment() {
        throw new MARSHAL("OutputStream fragmentation error", 1229125818, CompletionStatus.COMPLETED_NO);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    public InputStream create_input_stream() {
        byte[] byArray = this.toByteArray();
        return new CDRInputStream(this, byArray, byArray.length);
    }

    public void write_longdouble(double d) {
        throw new NO_IMPLEMENT("Long Double Not Implemented (3)", 1229124492, CompletionStatus.COMPLETED_MAYBE);
    }

    private void checkChunkStart() {
        if (this.startNewChunk) {
            this.writingChunkMarker = true;
            this.startNewChunk = false;
            this.blockSizePosition = this.write_long(0, false, true);
            this.writingChunkMarker = false;
            this.inBlock = true;
        }
    }

    public void write_octet(byte by) {
        this.write_octet(by, false);
    }

    ByteBuffer.Position write_octet(byte by, boolean bl) {
        ByteBuffer.Position position = null;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        if (bl) {
            position = this.byteBuf.getWritePosition();
        }
        this.byteBuf.write(by);
        return position;
    }

    void write_octet(byte by, ByteBuffer.Position position) {
        this.checkPadding();
        this.byteBuf.write(by, position, 0);
    }

    public void write_boolean(boolean bl) {
        this.write_boolean(bl, false);
    }

    public ByteBuffer.Position write_boolean(boolean bl, boolean bl2) {
        return this.write_octet(bl ? (byte)1 : 0, bl2);
    }

    public void write_boolean(boolean bl, ByteBuffer.Position position) {
        this.write_octet(bl ? (byte)1 : 0, position);
    }

    public void write_char(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(new char[]{c});
        if (byArray.length > 1) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (char) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.write_octet(byArray[0]);
    }

    private final void writeNumber(long l, int n, int n2, ByteBuffer.Position position) {
        int n3;
        int n4;
        if (n2 == 1) {
            n4 = 0;
            n3 = n;
        } else {
            n4 = n - 1;
            n3 = -1;
        }
        while (n4 != n3) {
            this.tempData[n4] = (byte)(l & 0xFFL);
            l >>>= 8;
            n4 += n2;
        }
        this.byteBuf.write(this.tempData, 0, n, position, 0);
    }

    private final void writeShort(int n, boolean bl) {
        this.checkPadding();
        this.writeNumber(n & 0xFFFF, 2, bl ? 1 : -1, null);
    }

    private final void writeLong(int n, boolean bl) {
        this.checkPadding();
        this.writeLong(n, this.littleEndian, null);
    }

    private final void writeLong(int n, boolean bl, ByteBuffer.Position position) {
        this.writeNumber(n & 0xFFFFFFFF, 4, this.littleEndian ? 1 : -1, position);
    }

    private final void writeLongLong(long l, boolean bl) {
        this.checkPadding();
        this.writeNumber(l, 8, bl ? 1 : -1, null);
    }

    public void write_wchar(char c) {
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(new char[]{c}, this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n = cArray.length;
        int n2 = n * 2;
        int n3 = 0;
        boolean bl2 = false;
        this.checkPadding();
        this.checkChunkStart();
        if (this.preGIOP12_CDR) {
            if (n > 1) {
                throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - (wchar) single IDL char > 1 byte when encoded in TCS", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            n3 = this.alignAndReserve(2, n2);
        } else {
            n3 = this.alignAndReserve(1, n2 + 1);
            this.byteBuf.write((byte)n2);
            bl2 = --n3 == 0;
        }
        int[] nArray = CDROutputStream.getByteShifts(2, bl);
        int n4 = 0;
        do {
            if (bl2) {
                n3 += this.alignAndReserve(1, n2 - n4);
            }
            do {
                this.byteBuf.write((byte)(cArray[n4 / 2] >>> nArray[n4 % 2] & 0xFF));
            } while (++n4 < n3);
            bl2 = true;
        } while (n4 < n2);
    }

    private static int[] getByteShifts(int n, boolean bl) {
        return bl ? SWAPBYTE_SHIFTS : NOSWAPBYTES_SHIFTS[n / 4];
    }

    public void write_short(short s) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        this.writeShort(s, this.littleEndian);
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.write_long(n, true);
    }

    public void write_long(int n, boolean bl) {
        this.write_long(n, bl, false);
    }

    void write_long(int n, ByteBuffer.Position position) {
        this.writeLong(n, this.littleEndian, position);
    }

    ByteBuffer.Position write_long(int n, boolean bl, boolean bl2) {
        ByteBuffer.Position position = null;
        this.checkPadding();
        if (bl) {
            this.checkChunkStart();
        }
        this.alignAndReserve(4, 4);
        if (bl2) {
            position = this.byteBuf.getWritePosition();
        }
        this.writeLong(n, this.littleEndian, null);
        return position;
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        this.writeLongLong(l, this.littleEndian);
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM("Null Param (2) - string", 1229124098, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        byte[] byArray = charToTcsConverter.convertToByte(string.toCharArray());
        int n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n + 1);
        this.writeLong(n + 1, this.littleEndian);
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.alignAndReserve(1, n - i + 1);
            if (n2 + i == n + 1) {
                --n2;
            }
            this.byteBuf.write(byArray, i, n2);
        }
        this.alignAndReserve(1, 1);
        this.byteBuf.write((byte)0);
    }

    public void write_wstring(String string) {
        int n;
        if (null == string) {
            throw new BAD_PARAM("Null Param (3) - wstring", 1229124099, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
        char[] cArray = charToTcsConverter.convertToChar(string.toCharArray(), this.littleEndian);
        boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
        int n2 = cArray.length;
        if (this.preGIOP12_CDR) {
            this.write_long(n2 + 1);
        } else {
            n = n2 * 2;
            this.checkPadding();
            this.checkChunkStart();
            this.alignAndReserve(4, 4 + n);
            this.writeLong(n, this.littleEndian);
        }
        n = 0;
        int n3 = 0;
        byte[] byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        for (int i = 0; i < n2; i += n) {
            int n4;
            n = this.alignAndReserve(2, (n2 - i) * 2);
            n3 = n * 2;
            if (byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                char c = cArray[i + n4];
                byArray[n5] = (byte)(c >>> 8 & 0xFF);
                byArray[++n5] = (byte)(c & 0xFF);
                ++n5;
            }
            if (bl) {
                for (n5 = 0; n5 < n3; n5 += 2) {
                    int n6 = n5 + 1;
                    n4 = byArray[n5];
                    byArray[n5] = byArray[n6];
                    byArray[n6] = n4;
                }
            }
            this.byteBuf.write(byArray, 0, n3);
        }
        if (this.preGIOP12_CDR) {
            this.write_short((short)0);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2, true);
    }

    public void write_octet_array(byte[] byArray, int n, int n2, boolean bl) {
        this.writeOctetArrayPiece(byArray, n, n2, true, n2);
    }

    public void writeOctetArrayPiece(byte[] byArray, int n, int n2, boolean bl, int n3) {
        if (byArray == null) {
            throw new BAD_PARAM("Null Param (4) - octet array", 1229124100, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            int n4;
            this.checkPadding();
            if (bl) {
                this.checkChunkStart();
            }
            for (int i = 0; i < n2; i += n4) {
                n4 = this.alignAndReserve(1, n3 - i);
                n4 = Math.min(n4, n2 - i);
                this.byteBuf.write(byArray, n + i, n4);
            }
        }
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null Param (5) - any", 1229124101, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("Null Param (6) - TypeCode", 1229124102, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    public void writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return;
        }
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this);
            }
        } else {
            typeCodeImpl.write_value(this);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            this.write_value((Serializable)object2);
        } else if (n == 30) {
            this.write_value((Serializable)object2);
        } else if (n == 14) {
            this.write_Object((Object)object2);
        } else if (n == 32) {
            this.write_abstract_interface(object2);
        } else {
            throw new BAD_PARAM("Unexpected type for any", 1229125805, CompletionStatus.COMPLETED_NO);
        }
    }

    public java.lang.Object fast_writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return object;
        }
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return object;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this);
            }
        } else {
            typeCodeImpl.write_value(this);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            return this.fast_write_value((Serializable)object2);
        }
        if (n == 30) {
            return this.fast_write_value((Serializable)object2);
        }
        if (n == 14) {
            this.write_Object((Object)object2);
            return object2;
        }
        if (n == 32) {
            return this.fast_write_abstract_interface(object2);
        }
        throw new BAD_PARAM("Unexpected type for any", 1229125811, CompletionStatus.COMPLETED_NO);
    }

    private void writeStringAnyOpt(String string, boolean bl) {
        if (this.firstStringTc == -1 || !bl) {
            this.firstStringTc = boxStringTC.writeValueOpt(this);
        } else {
            this.writeIndirection(this.firstStringTc);
        }
        this.write_value((Serializable)((java.lang.Object)string));
    }

    private void writeNullAnyOpt(boolean bl) {
        if (this.firstNullTc == -1 || !bl) {
            if (this.useOldNullTC()) {
                this.firstNullTc = TypeCodeImpl.get_primitive_tc(TCKind.tk_value).writeValueOpt(this);
                this.write_value(null);
            } else {
                this.firstNullTc = abstractBaseTC.writeValueOpt(this);
                this.write_abstract_interface(null);
            }
        } else {
            this.writeIndirection(this.firstNullTc);
            this.write_abstract_interface(null);
        }
    }

    public void writeIndirection(int n) {
        this.checkPadding();
        this.checkChunkStart();
        this.addIndirectionBytes = 4;
        this.alignAndReserve(4, 4);
        this.writeLong(-1, this.littleEndian);
        this.addIndirectionBytes = 0;
        this.alignAndReserve(4, 4);
        this.writeLong(n - this.get_offset(), this.littleEndian);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL(object.getClass() + " is a LocalObject and " + "cannot be marshalled", 1330446340, CompletionStatus.COMPLETED_MAYBE);
        }
        if (object instanceof DynamicStub) {
            object = ((DynamicStub)object).getStub();
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        com.ibm.CORBA.iiop.IOR iOR = null;
        try {
            Delegate delegate = objectImpl._get_delegate();
            if (delegate instanceof ClientSubcontract) {
                clientSubcontract = (ClientSubcontract)delegate;
                iOR = clientSubcontract.marshal();
            } else if (ORBRas.isTrcLogging && !(delegate instanceof DisconnectedDelegate)) {
                ORBRas.orbTrcLogger.trace(8208L, this, "write_Object:1391", "Received a non-IBM delegate of type: " + (delegate == null ? "null" : delegate.getClass().getName()));
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "write_Object:1401", exception);
        }
        if (clientSubcontract == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect(this.orb);
                }
                catch (RemoteException remoteException) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "write_Object:1414", (Exception)remoteException);
                    MARSHAL mARSHAL = new MARSHAL(object.getClass() + " is a CORBA Stub, no IOR: servant was not " + "connected to ORB", 1229125797, CompletionStatus.COMPLETED_MAYBE);
                    mARSHAL.initCause((Throwable)remoteException);
                    throw mARSHAL;
                }
            } else {
                ((com.ibm.rmi.corba.ORB)this.orb).internalConnect(object);
            }
            clientSubcontract = (ClientSubcontract)objectImpl._get_delegate();
        }
        if (iOR == null) {
            iOR = clientSubcontract.isClientCallback() ? clientSubcontract.getCallbackIOR(this.connInfo.getLocalHost(), this.connInfo.getLocalPort()) : clientSubcontract.marshal();
        }
        iOR.write(this);
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (this.fast_write_abstract_interface_as_Object(object)) {
            return;
        }
        try {
            this.write_value((Serializable)object);
        }
        catch (ClassCastException classCastException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "write_abstract_interface:1458", (Exception)classCastException);
            if (object instanceof Serializable) {
                throw classCastException;
            }
            Utility.throwNotSerializableForCorba(object.getClass().getName());
        }
    }

    private boolean fast_write_abstract_interface_as_Object(java.lang.Object object) {
        if (object != null && object instanceof Object) {
            if (object instanceof DynamicStub) {
                object = ((DynamicStub)object).getStub();
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            try {
                Delegate delegate = objectImpl._get_delegate();
                if (!(delegate instanceof DisconnectedDelegate)) {
                    this.write_boolean(true);
                    this.write_Object((Object)objectImpl);
                    return true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
        this.write_boolean(false);
        return false;
    }

    public java.lang.Object fast_write_abstract_interface(java.lang.Object object) {
        if (this.fast_write_abstract_interface_as_Object(object)) {
            return object;
        }
        return this.fast_write_value((Serializable)object);
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        boolean bl = false;
        java.lang.Object object = this.fast_write_value(serializable, string);
        if (object != PENDING_WRITE) {
            return;
        }
        try {
            if (this.valueHandler == null) {
                bl = true;
                this.valueHandler = ValueHandlerPool.getValueHandler();
            }
            boolean bl2 = this.prevMustChunk;
            this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, (Serializable)this.currentObject, this.streamFormatVersion);
            this.post_fast_write_value(bl2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "write_value:1540", outOfMemoryError.toString(), (java.lang.Object)outOfMemoryError);
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126020, CompletionStatus.COMPLETED_NO);
        }
        finally {
            if (bl) {
                ValueHandlerPool.returnValueHandler(this.valueHandler);
                this.valueHandler = null;
            }
        }
    }

    public void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    public void post_fast_write_value(boolean bl) {
        if (this.mustChunk) {
            this.end_block();
            this.writeEndTag(true);
        } else {
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public java.lang.Object fast_write_value(Serializable serializable) {
        return this.fast_write_value(serializable, null);
    }

    private java.lang.Object fast_write_value_internal(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return serializable;
        }
        Integer n = null;
        if (this.valueCache != null && (n = (Integer)this.valueCache.get(serializable)) != null) {
            int n2 = n;
            this.writeIndirection(n2);
            return serializable;
        }
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (serializable instanceof String) {
            this.writeString((String)((java.lang.Object)serializable));
        } else if (serializable instanceof Class) {
            if (string == null) {
                this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
            } else {
                this.writeClass(string, (Class)serializable);
            }
        } else if (serializable instanceof ValueBase) {
            Class<?> clazz = serializable.getClass();
            this.writeValueBase((ValueBase)serializable, clazz);
        } else if (serializable instanceof IDLEntity) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else {
            return PENDING_WRITE;
        }
        this.post_fast_write_value(bl);
        return serializable;
    }

    public java.lang.Object fast_write_value(Serializable object, String string) {
        java.lang.Object object2;
        java.lang.Object object3;
        if (object != null && object instanceof ZoneInfo && PartnerVersionUtil.needOldTimeZone(this.getPartnerMajor())) {
            object3 = ((ZoneInfo)object).getLastRuleInstance();
            if (object3 == null) {
                object3 = new SimpleTimeZone(((ZoneInfo)object).getRawOffset(), ((ZoneInfo)object).getID());
            }
            object = object3;
        }
        if ((object3 = this.fast_write_value_internal((Serializable)object, string)) != PENDING_WRITE) {
            return object3;
        }
        this.prevMustChunk = this.mustChunk;
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            String string2 = RepositoryId.createSequenceRepID(clazz, this.getOldSUID(), this);
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, clazz);
                this.updateIndirectionTable(n, object, object);
                this.writeRepositoryId(string2);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, clazz);
                this.updateIndirectionTable(n, object, object);
                this.writeRepositoryId(string2);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            this.currentObject = object;
            return PENDING_WRITE;
        }
        java.lang.Object object4 = object;
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
        object = objectStreamClass.writeReplace((Serializable)object4);
        if (object != object4) {
            if (object == null) {
                this.write_long(0);
                return object;
            }
            object2 = clazz;
            clazz = object.getClass();
            if (clazz != object2) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(8208L, (java.lang.Object)this, "fast_write_value:1715", ((Class)object2).getName(), (java.lang.Object)clazz.getName());
                }
                objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
            }
            if ((object3 = this.fast_write_value_internal((Serializable)object, string)) != PENDING_WRITE) {
                return object3;
            }
        }
        if (objectStreamClass.isCustomIDL()) {
            this.mustChunk = true;
        }
        object2 = RepositoryId.createForJavaType(clazz, this.getOldSUID(), this);
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, clazz);
            this.updateIndirectionTable(n, object, object4);
            this.writeRepositoryId((String)object2);
            --this.end_flag;
            this.start_block();
        } else {
            int n = this.writeValueTag(false, false, clazz);
            this.updateIndirectionTable(n, object, object4);
            this.writeRepositoryId((String)object2);
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
        }
        this.currentObject = object;
        return PENDING_WRITE;
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        try {
            if (serializable == null) {
                this.write_long(0);
                return;
            }
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                int n = (Integer)this.valueCache.get(serializable);
                this.writeIndirection(n);
                return;
            }
            boolean bl = this.mustChunk;
            if (this.mustChunk) {
                if (this.inBlock) {
                    this.end_block();
                }
                int n = this.writeValueTag(true, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this, serializable);
            this.post_fast_write_value(bl);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "write_value (Serializable, org.omg.CORBA.portable.BoxedValueHelper):1808", outOfMemoryError.toString(), (java.lang.Object)outOfMemoryError);
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126021, CompletionStatus.COMPLETED_NO);
        }
    }

    public int get_offset() {
        return this.get_offset(false);
    }

    public int get_offset(boolean bl) {
        int n = this.offset;
        if (this.byteBuf != null) {
            if (bl) {
                this.checkChunkStart();
            }
            n += this.byteBuf.getWriteOffset();
        }
        return n;
    }

    public void start_block() {
        this.checkPadding();
        this.align(4);
        this.blockSizePosition = this.byteBuf.getWritePosition();
        this.startNewChunk = true;
        this.inBlock = true;
    }

    public void end_block() {
        this.end_block(0, false);
    }

    public void end_block(int n, boolean bl) {
        if (!this.inBlock) {
            return;
        }
        if (!bl) {
            this.inBlock = false;
            if (this.startNewChunk) {
                this.blockSizePosition = null;
                this.startNewChunk = false;
                return;
            }
        }
        this.startNewChunk = false;
        int n2 = n + this.byteBuf.getWriteOffset() - (this.blockSizePosition.getOffset() + 4) + this.addIndirectionBytes;
        this.write_long(n2, this.blockSizePosition);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "end_block (int, boolean):1883", "start block index_hex " + Integer.toHexString(this.blockSizePosition.getOffset() + this.offset) + " blockLength_hex " + Integer.toHexString(n2));
        }
        this.blockSizePosition = null;
    }

    public void start_value(String string) {
        this.end_block();
        this.mustChunk = true;
        this.writeValueTag(true, false, null);
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
    }

    public void end_value() {
        this.end_block();
        this.writeEndTag(true);
        this.start_block();
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    private int getTcsC() {
        if (this.tcsChar == 0) {
            this.tcsChar = this.connInfo.getCharCodeSet();
        }
        return this.tcsChar;
    }

    private int getTcsW() {
        if (this.tcsWChar == 0) {
            this.tcsWChar = this.connInfo.getWCharCodeSet();
            if (this.tcsWChar == 0 && this.orb instanceof ORB) {
                this.tcsWChar = ((ORB)this.orb).getWCharDefault();
            }
            if (this.tcsWChar == 0) {
                this.tcsWChar = 65792;
            }
        }
        return this.tcsWChar;
    }

    private CharToTcsConverter getTcsCConverter() {
        if (this.tcsCConverter == null) {
            int n = this.getTcsC();
            if (n == 0) {
                n = 65537;
            }
            this.tcsCConverter = CharToTcsConverter.getConverter(n);
            if (!this.tcsCConverter.isByteOriented()) {
                throw new INTERNAL("non-byte-oriented char code set specified", 1229125042, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsCConverter;
    }

    private CharToTcsConverter getTcsWConverter() {
        if (this.tcsWConverter == null) {
            int n = this.getTcsW();
            if (n == 0) {
                throw new INV_OBJREF("wchar code set support not specified", 1330446338, CompletionStatus.COMPLETED_NO);
            }
            this.tcsWConverter = CharToTcsConverter.getConverter(n);
            if (this.tcsWConverter.isByteOriented()) {
                throw new INTERNAL("byte-oriented wchar code set specified", 1229125044, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.tcsWConverter;
    }

    public boolean isOptimisedTCVersion() {
        if (!this.checkedOptimisedTCVersion) {
            if (this.orb instanceof ORB && ((ORB)this.orb).getAlwaysUseOMG4796()) {
                this.optimisedTCVersion = true;
            } else {
                short s = this.getPartnerMajor();
                short s2 = this.getPartnerMinor();
                this.optimisedTCVersion = PartnerVersionUtil.isOptimisedTCVersion(s, s2);
            }
            this.checkedOptimisedTCVersion = true;
        }
        return this.optimisedTCVersion;
    }

    protected boolean useOldNullTC() {
        if (!this.checkedOldNullTC) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.oldNullTC = PartnerVersionUtil.useOldNullTC(s, s2);
            this.checkedOldNullTC = true;
        }
        return this.oldNullTC;
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM("Null Param (7) - boolean array", 1229124103, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(1, n2 - n3);
                for (int i = 0; i < n4; ++i) {
                    this.write_boolean(blArray[n + n3], null);
                    ++n3;
                }
            }
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        byte[] byArray;
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (8) - char array", 1229124104, CompletionStatus.COMPLETED_MAYBE);
        }
        CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
        if (n == 0 && n2 == cArray.length) {
            byArray = charToTcsConverter.convertToByte(cArray);
        } else {
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            byArray = charToTcsConverter.convertToByte(cArray2);
        }
        if (byArray.length > n2) {
            throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        if (n2 > 0) {
            int n3;
            this.checkPadding();
            this.checkChunkStart();
            for (int i = 0; i < n2; i += n3) {
                n3 = this.alignAndReserve(1, n2 - i);
                this.byteBuf.write(byArray, i, n3);
            }
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM("Null Param (9) - wchar array", 1229124105, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            CharToTcsConverter charToTcsConverter = this.getTcsWConverter();
            boolean bl = charToTcsConverter.needToSwap(this.littleEndian);
            if (this.preGIOP12_CDR) {
                java.lang.Object[] objectArray;
                char[] cArray2;
                if (n == 0 && cArray.length == n2) {
                    cArray2 = charToTcsConverter.convertToChar(cArray, this.littleEndian);
                } else {
                    objectArray = new char[n2];
                    System.arraycopy(cArray, n, objectArray, 0, n2);
                    cArray2 = charToTcsConverter.convertToChar((char[])objectArray, this.littleEndian);
                }
                if (cArray2.length > n2) {
                    throw new DATA_CONVERSION("Character doesn't map to negotiated transmission char set - wchar array", 1330446337, CompletionStatus.COMPLETED_NO);
                }
                objectArray = CDROutputStream.getByteShifts(2, bl);
                int n3 = n2;
                int n4 = 0;
                int n5 = 0;
                do {
                    n5 += this.alignAndReserve(2, (n3 - n4) * 2);
                    do {
                        this.byteBuf.write((byte)(cArray2[n4] >>> objectArray[0] & 0xFF));
                        this.byteBuf.write((byte)(cArray2[n4] >>> objectArray[1] & 0xFF));
                    } while (++n4 < n5);
                } while (n4 < n3);
            } else {
                int[] nArray = CDROutputStream.getByteShifts(2, bl);
                byte[] byArray = new byte[n2 * 3];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    char[] cArray3 = charToTcsConverter.convertToChar(new char[]{cArray[n + i]}, this.littleEndian);
                    if (n6 + (cArray3.length * 2 + 1) > byArray.length) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[byArray2.length * 2];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    }
                    byArray[n6++] = (byte)(cArray3.length * 2);
                    for (int j = 0; j < cArray3.length; ++j) {
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[0] & 0xFF);
                        byArray[n6++] = (byte)(cArray3[j] >>> nArray[1] & 0xFF);
                    }
                }
                this.write_octet_array(byArray, 0, n6);
            }
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM("Null Param (10) - short_array", 1229124106, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(2, (n2 - n3) * 2);
                for (int i = 0; i < n4; ++i) {
                    this.writeShort(sArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM("Null Param (11) - ushort_array", 1229124107, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    this.writeLong(nArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM("Null Param (12) - ulong_array", 1229124108, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    this.writeLongLong(lArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM("Null Param (13) - ulonglong_array", 1229124109, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    int n5 = Float.floatToIntBits(fArray[n + n3]);
                    this.writeLong(n5, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM("Null Param (14) - double_array", 1229124110, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    long l = Double.doubleToLongBits(dArray[n + n3]);
                    this.writeLongLong(l, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM("Null Param (15) - string_array", 1229124111, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_string(stringArray[i + n]);
        }
    }

    public void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[i + n]);
        }
    }

    public final void reset() {
        if (this.byteBuf != null) {
            this.offset += this.byteBuf.getWriteOffset();
            this.byteBuf.reset();
            this.end_flag = 0;
            this.endFlagPosition = null;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.byteBuf != null) {
            this.byteBuf.flushTo(outputStream);
        }
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.byteBuf != null) {
            this.byteBuf.flushTo(outputStream);
        }
    }

    public int getSize() {
        int n = this.byteBuf == null ? 0 : this.byteBuf.getSize();
        return n;
    }

    public boolean getPrevMustChunk() {
        return this.prevMustChunk;
    }

    public Serializable getCurrentObject() {
        return (Serializable)this.currentObject;
    }

    public boolean getOldSUID() {
        if (this.oldSUID == -1) {
            short s;
            short s2 = this.getPartnerMajor();
            this.oldSUID = PartnerVersionUtil.useOldSUID(s2, s = this.getPartnerMinor()) ? 1 : 0;
        }
        return this.oldSUID == 1;
    }

    protected byte[] getBuffer() {
        return this.toByteArray();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    public static int getDefaultBufferSize() {
        return 1024;
    }

    private final void updateValueCache(int n, java.lang.Object object) {
        if (!(object instanceof StackTraceElement[]) && !(object instanceof StackTraceElement) || !PartnerVersionUtil.needOldThrowable(this.getPartnerMajor(), this.getPartnerMinor())) {
            this.valueCache.put(object, new Integer(n));
        }
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new IdentityHashtable();
        }
        this.updateValueCache(n, object);
        if (object2 != object) {
            this.updateValueCache(n, object2);
        }
    }

    private final void writeRepositoryId(String string) {
        int n;
        boolean bl = this.interop.useAlternativeRepIDEncoding.inUse();
        if (bl) {
            string = RepositoryId.unescape(string);
        }
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            int n2 = (Integer)this.repositoryIdCache.get(string);
            this.writeIndirection(n2);
            return;
        }
        byte[] byArray = null;
        if (!bl) {
            byArray = RepositoryId.getByteArray(string);
            if (byArray == null) {
                n = string.length() + 1;
                byArray = new byte[n];
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] > '\u00ff') {
                        throw new INTERNAL("Tried to marshal a Repository ID containing characters that are not part of the ISO Latin-1 character set. Repository ID=" + string, 1229125061, CompletionStatus.COMPLETED_NO);
                    }
                    byArray[i] = (byte)cArray[i];
                }
                byArray[n - 1] = 0;
                RepositoryId.setByteArray(string, byArray);
            }
        } else {
            CharToTcsConverter charToTcsConverter = this.getTcsCConverter();
            byte[] byArray2 = charToTcsConverter.convertToByte(string.toCharArray());
            byArray = new byte[byArray2.length + 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray[byArray.length - 1] = 0;
        }
        n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n);
        this.writeLong(n, this.littleEndian);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new Hashtable();
        }
        this.repositoryIdCache.put(string, new Integer(this.get_offset() - 4));
        this.write_octet_array(byArray, 0, n, false);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            int n2 = (Integer)this.codebaseCache.get(string);
            this.writeIndirection(n2);
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new Hashtable();
            }
            this.codebaseCache.put(string, new Integer(n));
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, Class clazz) {
        int n = 0;
        int n2 = 0;
        String string = null;
        if (clazz != null && (!(this.orb instanceof ORB) || ((ORB)this.orb).getCodebaseURLEnabled())) {
            string = Util.getCodebase((Class)clazz);
        }
        if (bl && bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            n2 = RepositoryId.kPreComputed_StandardRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
        } else {
            n2 = RepositoryId.kPreComputed_CodeBaseRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
            this.write_codebase(string, this.get_offset());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "writeValueTag:2560", "write value tag " + Integer.toHexString(n2) + " index_hex " + Integer.toHexString(n));
        }
        return n;
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        Class<?> clazz = iDLEntity.getClass();
        String string = RepositoryId.createForJavaType(clazz, false, this);
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.writeRepositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod(CDROutputStream.kWriteMethod, classArray);
                }
            });
            java.lang.Object[] objectArray = new java.lang.Object[]{this, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2613", (Exception)classNotFoundException);
            MARSHAL mARSHAL = new MARSHAL("ClassNotFoundException :" + classNotFoundException.getMessage(), 1229125798, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)classNotFoundException);
            throw mARSHAL;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2630", exception);
            MARSHAL mARSHAL = new MARSHAL("PrivilegedActionException :" + exception.getMessage(), 1229125799, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)exception);
            throw mARSHAL;
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2646", (Exception)illegalAccessException);
            MARSHAL mARSHAL = new MARSHAL("IllegalAccessException :" + illegalAccessException.getMessage(), 1229125800, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)illegalAccessException);
            throw mARSHAL;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "writeIDLEntity:2667", (Exception)throwable);
            }
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "writeIDLEntity:2673", throwable.getMessage(), (java.lang.Object)throwable);
            MARSHAL mARSHAL = new MARSHAL("InvocationTargetException:" + throwable.getMessage(), 1229125801, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause(throwable);
            throw mARSHAL;
        }
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write((org.omg.CORBA.portable.OutputStream)this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal((DataOutputStream)this);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this, serializable);
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.endFlagPosition != null && this.endFlagPosition.getOffset() == this.byteBuf.getWriteOffset() - 4) {
                this.write_long(this.end_flag, this.endFlagPosition);
            } else {
                this.endFlagPosition = this.write_long(this.end_flag, true, true);
            }
            if (!this.useOldNestingDepths()) {
                ++this.end_flag;
            }
        }
        if (this.useOldNestingDepths()) {
            ++this.end_flag;
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            Utility.writeClassValue(this, clazz);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            Utility.writeClassValue(this, clazz);
        }
    }

    private void writeString(String string) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            this.start_block();
            --this.end_flag;
            this.write_wstring(string);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            this.write_wstring(string);
        }
    }

    private void writeValueBase(ValueBase valueBase, Class clazz) {
        this.mustChunk = true;
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, valueBase, valueBase);
        String string = valueBase._truncatable_ids()[0];
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
        this.writeIDLValue((Serializable)valueBase, string);
    }

    public void writeSystemException(SystemException systemException) {
        Utility.writeSystemException(systemException, (org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public String[] _truncatable_ids() {
        return _ids;
    }

    public void printBuffer() {
        if (this.byteBuf != null) {
            System.out.println(this.byteBuf.toString());
        }
    }

    protected boolean useOldNestingDepths() {
        if (!this.haveCheckedOldNestingDepths) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.useOldNestingDepths = PartnerVersionUtil.useOldNestingDepths(s, s2);
            this.haveCheckedOldNestingDepths = true;
        }
        return this.useOldNestingDepths;
    }

    public boolean isFragmentable() {
        return this.fragmentable;
    }

    public void close() throws IOException {
        this.typeMap = null;
        this.currentObject = null;
        if (this.valueCache != null) {
            this.valueCache.clear();
            this.valueCache = null;
        }
        if (this.valueHandler != null) {
            this.valueHandler.reset();
            this.valueHandler = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:2887");
        throw notSerializableException;
    }
}

