/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.giop.GIOPOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBWorkQueueUsePolicy;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ConnectionKeyGeneratorImpl;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolAlreadyKnownException;
import com.ibm.wsspi.runtime.ThreadPoolRepository;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import java.util.Map;

public class IIOPChannelPluginImpl
implements IIOPChannelPlugin {
    private static final String CLASS = IIOPChannelPluginImpl.class.getName();
    private ORB orb;
    private int connectTimeout;
    private static ChannelFramework channelFramework = null;
    private String chainGroupName = null;
    private String outTCPChainName = null;
    private String inChainTPInUse = null;
    private String outChainTPInUse = null;
    private int tpMinSize = 0;
    private int tpMaxSize = 50;
    private int tpQueueSize = 1024;
    private long tpKeepAliveTime = 5000L;

    public void init(ORB oRB) {
        if (Trc.enabled()) {
            Trc.begin(CLASS, "init:112");
        }
        this.orb = oRB;
        if (channelFramework == null) {
            channelFramework = ChannelFrameworkFactory.getChannelFramework();
        }
        this.connectTimeout = oRB.getConnectTimeout();
        if (Trc.enabled()) {
            Trc.complete(CLASS, "init:128");
        }
    }

    public synchronized void initTCPOutChain() {
        if (Trc.enabled()) {
            Trc.begin(CLASS, "initTCPOutChain:136");
        }
        if (this.outTCPChainName != null) {
            if (Trc.enabled()) {
                Trc.complete(this.outTCPChainName + " already initialized", CLASS, "initTCPOutChain:143");
            }
            return;
        }
        String string = this.orb.getORBId();
        String string2 = "tcpOut-" + string;
        String string3 = "giopOut-" + string;
        String string4 = "orbOut-" + string;
        String string5 = "ORB-GIOP-TCP(Out)-" + string;
        try {
            channelFramework.addChannel(string2, TCPChannelFactory.class, null);
            channelFramework.addChannel(string3, GIOPOutboundChannelFactory.class, null);
            channelFramework.addChannel(string4, ORBOutboundChannelFactory.class, null);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPOutChain:160");
            return;
        }
        ChannelData channelData = channelFramework.getChannel(string2);
        Map map = channelData.getPropertyBag();
        String string6 = "TP-Out-" + string;
        ThreadPool threadPool = this.createThreadPool(string6);
        if (threadPool == null) {
            if (Trc.enabled()) {
                Trc.info("Default ThreadPool used", CLASS, "initTCPOutChain:175");
            }
        } else {
            map.put("threadPoolName", string6);
            this.outChainTPInUse = string6;
        }
        try {
            channelFramework.addChain(string5, FlowType.OUTBOUND, new String[]{string4, string3, string2});
            this.outTCPChainName = string5;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPOutChain:214");
            return;
        }
        if (Trc.enabled()) {
            Trc.complete(channelFramework.getChain(this.outTCPChainName).getName(), CLASS, "initTCPOutChain:219");
        }
    }

    public ConnectionKeyGenerator getConnectionKeyGenerator(IOR iOR, ClientDelegate clientDelegate, String string) {
        if (this.outTCPChainName == null) {
            this.initTCPOutChain();
        }
        ConnectionKeyGeneratorImpl connectionKeyGeneratorImpl = new ConnectionKeyGeneratorImpl(iOR, clientDelegate, string, this.outTCPChainName, this.connectTimeout);
        return connectionKeyGeneratorImpl;
    }

    public ChannelFramework getChannelFramework() {
        return channelFramework;
    }

    public String getChainGroupName() {
        return this.chainGroupName;
    }

    public ThreadPool createThreadPool(String string) {
        ThreadPoolRepository threadPoolRepository = ThreadPoolRepositoryManager.getThreadPoolRepository();
        ThreadPool threadPool = null;
        try {
            threadPool = threadPoolRepository.createThreadPool(string, this.tpMinSize, this.tpMaxSize, this.tpKeepAliveTime, this.tpQueueSize);
        }
        catch (ThreadPoolAlreadyKnownException threadPoolAlreadyKnownException) {
            Trc.ffdc("Unexpected exception creating ThreadPool '" + string + "': " + (Object)((Object)threadPoolAlreadyKnownException), CLASS, "initTCPChainGroup:297");
            threadPool = threadPoolRepository.getThreadPool(string);
        }
        return threadPool;
    }

    public void initTCPChainGroup(String string, int n) {
        if (Trc.enabled()) {
            Trc.begin2(string, Trc.str(n), CLASS, "initTCPChainGroup:319");
        }
        String string2 = new Integer(n).toString();
        String string3 = this.orb.getORBId();
        String string4 = "tcpIn-" + string3;
        String string5 = "giopIn-" + string3;
        String string6 = "orbIn-" + string3;
        String string7 = "ORB-GIOP-TCP(In)-" + string3;
        this.chainGroupName = "ORBInbound-" + string3;
        try {
            channelFramework.addChannel(string4, TCPChannelFactory.class, null);
            channelFramework.addChannel(string5, GIOPInboundChannelFactory.class, null);
            channelFramework.addChannel(string6, ORBInboundChannelFactory.class, null);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPChainGroup:337 " + this.chainGroupName);
            return;
        }
        ChannelData channelData = channelFramework.getChannel(string4);
        Map map = channelData.getPropertyBag();
        String string8 = "TP-In-" + string3;
        ThreadPool threadPool = this.createThreadPool(string8);
        if (threadPool == null) {
            if (Trc.enabled()) {
                Trc.info("Default ThreadPool used", CLASS, "initTCPChainGroup:356");
            }
        } else {
            map.put("threadPoolName", string8);
            this.inChainTPInUse = string8;
        }
        map.put("newConnectionBufferSize", new Integer(32).toString());
        map.put("receiveBufferSize", new Integer(this.orb.getReceiveBufferSize()).toString());
        if (this.orb.getSocketQueueDepth() != 0) {
            map.put("listenBacklog", new Integer(this.orb.getSocketQueueDepth()).toString());
        }
        map.put("port", string2);
        try {
            channelFramework.addChain(string7, FlowType.INBOUND, new String[]{string4, string5, string6});
            channelFramework.addChainGroup(this.chainGroupName, new String[]{string7});
            channelFramework.initChainGroup(this.chainGroupName);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "initTCPChainGroup:417");
            return;
        }
        if (Trc.enabled()) {
            Trc.complete(channelFramework.getChainGroup(this.chainGroupName).getName(), CLASS, "initTCPChainGroup:422");
        }
    }

    public void shutdown() {
        if (Trc.enabled()) {
            Trc.begin1(this.chainGroupName, CLASS, "shutdown:432 ");
        }
        try {
            ThreadPool threadPool;
            if (this.chainGroupName != null) {
                channelFramework.stopChainGroup(this.chainGroupName, 0L);
                channelFramework.destroyChainGroup(this.chainGroupName);
                if (Trc.enabled()) {
                    Trc.info("stopped & destroyed ", this.chainGroupName, CLASS, "shutdown:441");
                }
            }
            ChainData[] chainDataArray = channelFramework.getRunningChains(GIOPInboundChannelFactory.class);
            ChainData[] chainDataArray2 = channelFramework.getRunningChains(GIOPOutboundChannelFactory.class);
            if (chainDataArray.length == 0 && chainDataArray2.length == 0) {
                channelFramework.destroy();
                if (Trc.enabled()) {
                    Trc.info("Destroyed CFW", CLASS, "shutdown:456");
                }
            }
            if (this.inChainTPInUse != null) {
                threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.inChainTPInUse);
                threadPool.shutdown();
                if (Trc.enabled()) {
                    Trc.info("Shutdown In-Chain ThreadPool ", this.inChainTPInUse, CLASS, "shutdown:469");
                }
            }
            if (this.outChainTPInUse != null) {
                threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.outChainTPInUse);
                threadPool.shutdown();
                if (Trc.enabled()) {
                    Trc.info("Shutdown Out-Chain ThreadPool ", this.outChainTPInUse, CLASS, "shutdown:478");
                }
            }
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "shutdown:483");
            return;
        }
        if (Trc.enabled()) {
            Trc.complete(CLASS, "shutdown:487");
        }
    }

    public Object getServerConnectionData(GIOPConnectionContext gIOPConnectionContext) {
        return null;
    }

    public ORBWorkQueueUsePolicy getOrbWorkQueueUsePolicy() {
        return ORBWorkQueueUsePolicy.ALWAYS;
    }

    public int nextRequestId(GIOPConnectionContext gIOPConnectionContext) {
        return 0;
    }
}

