/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.BackgroundLookupListener;
import sun.print.BackgroundServiceLookup;
import sun.print.UnixPrintService;
import sun.security.action.GetPropertyAction;

public class UnixPrintServiceLookup
extends PrintServiceLookup
implements BackgroundServiceLookup,
Runnable {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private PrintService[] printServices;
    private Vector lookupListeners = null;
    private static String debugPrefix = "UnixPrintServiceLookup>> ";
    static String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    static final int UNINITIALIZED = -1;
    static final int BSD_LPD = 0;
    static final int BSD_LPD_NG = 1;
    static int cmdIndex = -1;
    String[] lpcFirstCom = new String[]{"/bin/sh -c \"if [ -x /usr/bin/lpstat ]; then /usr/bin/lpstat -d | /usr/bin/awk '/destination:/ { print \\$4 }'; else /usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'; fi\"", "/usr/sbin/lpc status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcAllCom = new String[]{"/usr/sbin/lpc status | grep : | sed -e 's/://'", "/usr/sbin/lpc -a status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcNameCom = new String[]{"| grep : | sed -ne 's/://p'", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};

    static boolean isSysV() {
        return osname.equals("SunOS");
    }

    static boolean isBSD() {
        return osname.equals("Linux");
    }

    static boolean isZOS() {
        return osname.equals("z/OS");
    }

    static boolean isAIX() {
        return osname.equals("AIX");
    }

    static int getBSDCommandIndex() {
        String string = "/usr/sbin/lpc status";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray == null || stringArray.length == 0) {
            return 1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(58) != -1) {
                return 0;
            }
            if (stringArray[i].indexOf(64) == -1) continue;
            return 1;
        }
        return 0;
    }

    public synchronized PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
            int n = -1;
            this.getDefaultPrintService();
            String[] stringArray = UnixPrintServiceLookup.isSysV() ? this.getAllPrinterNamesSysV() : (UnixPrintServiceLookup.isZOS() ? this.getAllPrinterNamesZOS() : (UnixPrintServiceLookup.isAIX() ? this.getAllPrinterNamesAIX() : this.getAllPrinterNamesBSD()));
            if (stringArray == null || stringArray.length == 0) {
                if (this.defaultPrintService == null) {
                    this.printServices = new PrintService[0];
                } else {
                    this.printServices = new PrintService[1];
                    this.printServices[0] = this.defaultPrintService;
                }
                return this.printServices;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (this.defaultPrintService != null && stringArray[i].equals(this.defaultPrintService.getName())) {
                    arrayList.add(this.defaultPrintService);
                    n = arrayList.size() - 1;
                    continue;
                }
                arrayList.add(new UnixPrintService(stringArray[i]));
            }
            if (n == -1 && this.defaultPrintService != null) {
                arrayList.add(this.defaultPrintService);
                n = arrayList.size() - 1;
            }
            this.printServices = arrayList.toArray(new PrintService[0]);
            if (n > 0) {
                PrintService printService = this.printServices[0];
                this.printServices[0] = this.printServices[n];
                this.printServices[n] = printService;
            }
        }
        return this.printServices;
    }

    private boolean matchesAttributes(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = printService.getAttribute(attributeArray[i].getCategory());
            if (attribute != null && attribute.equals(attributeArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkPrinterName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '/') continue;
            return false;
        }
        return true;
    }

    private PrintService getServiceByName(PrinterName printerName) {
        String string = printerName.getValue();
        PrintService printService = null;
        if (string == null || string.equals("") || !this.checkPrinterName(string)) {
            return null;
        }
        printService = UnixPrintServiceLookup.isSysV() ? this.getNamedPrinterNameSysV(string) : (UnixPrintServiceLookup.isZOS() ? this.getNamedPrinterNameZOS(string) : (UnixPrintServiceLookup.isAIX() ? this.getNamedPrinterNameAIX(string) : this.getNamedPrinterNameBSD(string)));
        return printService;
    }

    private PrintService[] getPrintServices(PrintServiceAttributeSet printServiceAttributeSet) {
        int n;
        if (printServiceAttributeSet == null || printServiceAttributeSet.isEmpty()) {
            return this.getPrintServices();
        }
        PrinterName printerName = (PrinterName)printServiceAttributeSet.get(PrinterName.class);
        if (printerName != null) {
            PrintService printService = this.getDefaultPrintService();
            PrinterName printerName2 = printService.getAttribute(PrinterName.class);
            if (printerName2 != null && printerName.equals(printerName2)) {
                if (this.matchesAttributes(printService, printServiceAttributeSet)) {
                    PrintService[] printServiceArray = new PrintService[]{printService};
                    return printServiceArray;
                }
                return new PrintService[0];
            }
            PrintService printService2 = this.getServiceByName(printerName);
            if (printService2 != null && this.matchesAttributes(printService2, printServiceAttributeSet)) {
                PrintService[] printServiceArray = new PrintService[]{printService2};
                return printServiceArray;
            }
            return new PrintService[0];
        }
        Vector<PrintService> vector = new Vector<PrintService>();
        PrintService[] printServiceArray = this.getPrintServices();
        for (n = 0; n < printServiceArray.length; ++n) {
            if (!this.matchesAttributes(printServiceArray[n], printServiceAttributeSet)) continue;
            vector.add(printServiceArray[n]);
        }
        printServiceArray = new PrintService[vector.size()];
        for (n = 0; n < printServiceArray.length; ++n) {
            printServiceArray[n] = (PrintService)vector.elementAt(n);
        }
        return printServiceArray;
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        Attribute[] attributeArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
            attributeArray = attributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add(attributeArray[i]);
                    continue;
                }
                if (!(attributeArray[i] instanceof PrintServiceAttribute)) continue;
                hashPrintServiceAttributeSet.add(attributeArray[i]);
            }
        }
        attributeArray = this.getDefaultPrintService();
        if ((docFlavor == null || attributeArray.isDocFlavorSupported(docFlavor)) && attributeArray.getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) == null) {
            return this.getPrintServices(hashPrintServiceAttributeSet);
        }
        return new PrintService[0];
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    public synchronized PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.defaultPrintService == null) {
            this.defaultPrinter = UnixPrintServiceLookup.isSysV() ? this.getDefaultPrinterNameSysV() : (UnixPrintServiceLookup.isZOS() ? this.getDefaultPrinterNameZOS() : (UnixPrintServiceLookup.isAIX() ? this.getDefaultPrinterNameAIX() : this.getDefaultPrinterNameBSD()));
            if (this.defaultPrinter != null) {
                this.defaultPrintService = new UnixPrintService(this.defaultPrinter);
            }
        }
        return this.defaultPrintService;
    }

    public synchronized void getServicesInbackground(BackgroundLookupListener backgroundLookupListener) {
        if (this.printServices != null) {
            backgroundLookupListener.notifyServices(this.printServices);
        } else if (this.lookupListeners == null) {
            this.lookupListeners = new Vector();
            this.lookupListeners.add(backgroundLookupListener);
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.lookupListeners.add(backgroundLookupListener);
        }
    }

    private PrintService[] copyOf(PrintService[] printServiceArray) {
        if (printServiceArray == null || printServiceArray.length == 0) {
            return printServiceArray;
        }
        PrintService[] printServiceArray2 = new PrintService[printServiceArray.length];
        System.arraycopy(printServiceArray, 0, printServiceArray2, 0, printServiceArray.length);
        return printServiceArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PrintService[] printServiceArray = this.getPrintServices();
        UnixPrintServiceLookup unixPrintServiceLookup = this;
        synchronized (unixPrintServiceLookup) {
            for (int i = 0; i < this.lookupListeners.size(); ++i) {
                BackgroundLookupListener backgroundLookupListener = (BackgroundLookupListener)this.lookupListeners.elementAt(i);
                backgroundLookupListener.notifyServices(this.copyOf(printServiceArray));
            }
            this.lookupListeners = null;
        }
    }

    private String getDefaultPrinterNameBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcFirstCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        if (cmdIndex == 1 && stringArray[0].startsWith("missingprinter")) {
            return null;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameBSD(String string) {
        String string2;
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(string2 = "/usr/sbin/lpc status " + string + this.lpcNameCom[cmdIndex])) == null || !stringArray[0].equals(string)) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcAllCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private String getDefaultPrinterNameSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -d|/usr/bin/expand|/usr/bin/cut -f4 -d' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        return stringArray[0];
    }

    private String getDefaultPrinterNameZOS() {
        String string = "lp";
        String string2 = "/usr/lpp/Printsrv/bin/lpstat -d|/bin/expand|/bin/egrep -v \"(Description|---------)\"| /bin/cut -f1 -d ' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        return stringArray[0];
    }

    private String getDefaultPrinterNameAIX() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -d -W | /usr/bin/sed -n '3p' | /usr/bin/cut -f1 -d' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameSysV(String string) {
        String string2 = "/usr/bin/lpstat -v " + string;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("unknown printer") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private PrintService getNamedPrinterNameZOS(String string) {
        String string2 = "/usr/lpp/Printsrv/bin/lpstat -a " + string;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("not defined") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private PrintService getNamedPrinterNameAIX(String string) {
        String string2 = "/usr/bin/lpstat -v" + string;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("Invalid printer") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' ' |/usr/bin/cut -f1 -d':'";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("_default") || stringArray[i].equals(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getAllPrinterNamesZOS() {
        String string = "lp";
        String string2 = "/usr/lpp/Printsrv/bin/lpstat -a|/bin/expand|/bin/egrep -v \"(Description|---------)\"| /bin/cut -f1 -d ' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("_default") || stringArray[i].equals(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getAllPrinterNamesAIX() {
        String string = "lp";
        String string2 = "/usr/bin/lsallq|/usr/bin/expand|/usr/bin/cut -f1 -d' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("_default") || stringArray[i].equals(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String[] execCmd(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            final String[] stringArray = new String[3];
            if (UnixPrintServiceLookup.isSysV()) {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "env LC_ALL=C " + string;
            } else {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "env LC_ALL=C " + string;
            }
            BufferedReader bufferedReader = (BufferedReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = File.createTempFile("prn", "xc");
                    stringArray[2] = stringArray[2] + ">" + file.getAbsolutePath();
                    Process process = Runtime.getRuntime().exec(stringArray);
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (process.exitValue() == 0) {
                        FileReader fileReader = new FileReader(file);
                        file.delete();
                        return new BufferedReader(fileReader);
                    }
                    return null;
                }
            });
            if (bufferedReader != null) {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

