/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.CustomMediaTray;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;
import sun.print.UnixPrintService;
import sun.print.UnixPrintServiceLookup;

public class UnixPrintJob
implements CancelablePrintJob {
    private static String debugPrefix = "UnixPrintJob>> ";
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private PrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSizeName mediaName = MediaSizeName.NA_LETTER;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private CustomMediaTray customTray = null;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;
    private NumberUp nUp = null;
    private Sides sides = null;
    private static int DESTPRINTER = 1;
    private static int DESTFILE = 2;
    private int mDestType = DESTPRINTER;
    private File spoolFile;
    private String mDestination;
    private String mOptions = "";
    private boolean mNoJobSheet = false;

    UnixPrintJob(PrintService printService) {
        this.service = printService;
        this.mDestination = printService.getName();
        this.mDestType = DESTPRINTER;
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet hashPrintJobAttributeSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(hashPrintJobAttributeSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(printJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener printJobListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobListener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(printJobListener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object object = null;
        try {
            object = this.doc.getPrintData();
        }
        catch (IOException iOException) {
            return;
        }
        if (this.instream != null) {
            try {
                this.instream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.instream = null;
            }
        } else if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader = null;
            }
        } else if (object instanceof InputStream) {
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        } else if (object instanceof Reader) {
            try {
                ((Reader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int n) {
        switch (n) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent printJobEvent = new PrintJobEvent(this, n);
                block12: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener printJobListener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (n) {
                        case 101: {
                            printJobListener.printJobCanceled(printJobEvent);
                            continue block12;
                        }
                        case 103: {
                            printJobListener.printJobFailed(printJobEvent);
                            continue block12;
                        }
                        case 106: {
                            printJobListener.printDataTransferCompleted(printJobEvent);
                            continue block12;
                        }
                        case 105: {
                            printJobListener.printJobNoMoreEvents(printJobEvent);
                            continue block12;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(printJobAttributeListener);
            if (printJobAttributeSet == null) {
                printJobAttributeSet = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(printJobAttributeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (printJobAttributeListener == null || this.attrListeners == null) {
                return;
            }
            int n = this.attrListeners.indexOf(printJobAttributeListener);
            if (n == -1) {
                return;
            }
            this.attrListeners.remove(n);
            this.listenedAttributeSets.remove(n);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        Object object;
        Object object2;
        String string;
        Object object3;
        block60: {
            Object object4;
            object3 = this;
            synchronized (object3) {
                if (this.printing) {
                    throw new PrintException("already printing");
                }
                this.printing = true;
            }
            if (this.service.getAttribute(PrinterIsAcceptingJobs.class) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                throw new PrintException("Printer is not accepting job.");
            }
            this.doc = doc;
            object3 = doc.getDocFlavor();
            try {
                object4 = doc.getPrintData();
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException("can't get print data: " + iOException.toString());
            }
            if (object3 == null || !this.service.isDocFlavorSupported((DocFlavor)object3)) {
                this.notifyEvent(103);
                throw new PrintJobFlavorException("invalid flavor", (DocFlavor)object3);
            }
            this.initializeAttributeSets(doc, printRequestAttributeSet);
            this.getAttributeValues((DocFlavor)object3);
            String string2 = ((DocFlavor)object3).getRepresentationClassName();
            String string3 = ((DocFlavor)object3).getParameter("charset");
            string = "us-ascii";
            if (string3 != null && !string3.equals("")) {
                string = string3;
            }
            if (((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.GIF) || ((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.JPEG) || ((DocFlavor)object3).equals(DocFlavor.INPUT_STREAM.PNG) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.GIF) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.JPEG) || ((DocFlavor)object3).equals(DocFlavor.BYTE_ARRAY.PNG)) {
                try {
                    this.instream = doc.getStreamForBytes();
                    if (this.instream == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No stream for data");
                    }
                    break block60;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException);
                }
            }
            if (((DocFlavor)object3).equals(DocFlavor.URL.GIF) || ((DocFlavor)object3).equals(DocFlavor.URL.JPEG) || ((DocFlavor)object3).equals(DocFlavor.URL.PNG)) {
                try {
                    URL uRL = (URL)object4;
                    this.printableJob(new ImagePrinter(uRL));
                    ((UnixPrintService)this.service).wakeNotifier();
                    return;
                }
                catch (ClassCastException classCastException) {
                    this.notifyEvent(103);
                    throw new PrintException(classCastException);
                }
            }
            if (((DocFlavor)object3).equals(DocFlavor.CHAR_ARRAY.TEXT_PLAIN) || ((DocFlavor)object3).equals(DocFlavor.READER.TEXT_PLAIN) || ((DocFlavor)object3).equals(DocFlavor.STRING.TEXT_PLAIN)) {
                try {
                    this.reader = doc.getReaderForText();
                    if (this.reader == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No reader for data");
                    }
                    break block60;
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException.toString());
                }
            }
            if (string2.equals("[B") || string2.equals("java.io.InputStream")) {
                try {
                    this.instream = doc.getStreamForBytes();
                    if (this.instream == null) {
                        this.notifyEvent(103);
                        throw new PrintException("No stream for data");
                    }
                    break block60;
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException.toString());
                }
            }
            if (string2.equals("java.net.URL")) {
                object2 = (URL)object4;
                try {
                    this.instream = ((URL)object2).openStream();
                }
                catch (IOException iOException) {
                    this.notifyEvent(103);
                    throw new PrintException(iOException.toString());
                }
            } else {
                if (string2.equals("java.awt.print.Pageable")) {
                    try {
                        this.pageableJob((Pageable)doc.getPrintData());
                        ((UnixPrintService)this.service).wakeNotifier();
                        return;
                    }
                    catch (ClassCastException classCastException) {
                        this.notifyEvent(103);
                        throw new PrintException(classCastException);
                    }
                    catch (IOException iOException) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException);
                    }
                }
                if (string2.equals("java.awt.print.Printable")) {
                    try {
                        this.printableJob((Printable)doc.getPrintData());
                        ((UnixPrintService)this.service).wakeNotifier();
                        return;
                    }
                    catch (ClassCastException classCastException) {
                        this.notifyEvent(103);
                        throw new PrintException(classCastException);
                    }
                    catch (IOException iOException) {
                        this.notifyEvent(103);
                        throw new PrintException(iOException);
                    }
                }
                this.notifyEvent(103);
                throw new PrintException("unrecognized class: " + string2);
            }
        }
        object2 = new PrinterOpener();
        AccessController.doPrivileged(object2);
        if (((PrinterOpener)object2).pex != null) {
            throw ((PrinterOpener)object2).pex;
        }
        OutputStream outputStream = ((PrinterOpener)object2).result;
        BufferedWriter bufferedWriter = null;
        if (this.instream == null && this.reader != null) {
            object = new BufferedReader(this.reader);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            char[] cArray = new char[1024];
            try {
                int n;
                while ((n = ((BufferedReader)object).read(cArray, 0, cArray.length)) >= 0) {
                    bufferedWriter.write(cArray, 0, n);
                }
                ((BufferedReader)object).close();
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
        }
        if (this.instream != null && ((DocFlavor)object3).getMediaType().equalsIgnoreCase("text")) {
            try {
                int n;
                object = new InputStreamReader(this.instream, string);
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                char[] cArray = new char[1024];
                while ((n = bufferedReader.read(cArray, 0, cArray.length)) >= 0) {
                    bufferedWriter.write(cArray, 0, n);
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.instream != null) {
            object = new BufferedInputStream(this.instream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                while ((n = ((FilterInputStream)object).read(byArray)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                ((BufferedInputStream)object).close();
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                this.notifyEvent(103);
                throw new PrintException(iOException);
            }
        }
        this.notifyEvent(106);
        if (this.mDestType == DESTPRINTER) {
            object = new PrinterSpooler();
            AccessController.doPrivileged(object);
            if (((PrinterSpooler)object).pex != null) {
                throw ((PrinterSpooler)object).pex;
            }
        }
        this.notifyEvent(105);
        ((UnixPrintService)this.service).wakeNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            Object object = this;
            synchronized (object) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            object = new PageFormat();
            if (this.mediaSize != null) {
                Paper paper = new Paper();
                paper.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
                ((PageFormat)object).setPaper(paper);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                ((PageFormat)object).setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                ((PageFormat)object).setOrientation(0);
            }
            this.job.setPrintable(printable, (PageFormat)object);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException printerException) {
            this.notifyEvent(103);
            throw new PrintException(printerException);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            UnixPrintJob unixPrintJob = this;
            synchronized (unixPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setCopies(this.copies);
            this.job.setJobName(this.jobName);
            this.job.setPageable(pageable);
            this.job.print(this.reqAttrSet);
            this.notifyEvent(106);
            return;
        }
        catch (PrinterException printerException) {
            this.notifyEvent(103);
            throw new PrintException(printerException);
        }
        finally {
            this.printReturned = true;
            this.notifyEvent(105);
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) {
        TextSyntax textSyntax;
        DocAttributeSet docAttributeSet;
        Attribute[] attributeArray;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (printRequestAttributeSet != null) {
            this.reqAttrSet.addAll(printRequestAttributeSet);
            attributeArray = printRequestAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!(attributeArray[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i]);
            }
        }
        if ((docAttributeSet = doc.getAttributes()) != null) {
            attributeArray = docAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attributeArray[i]);
                }
                if (!(attributeArray[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attributeArray[i]);
            }
        }
        String string = "";
        try {
            string = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            textSyntax = (RequestingUserName)printRequestAttributeSet.get(RequestingUserName.class);
            if (textSyntax != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(textSyntax.getValue(), textSyntax.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(string, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            if (docAttributeSet != null && docAttributeSet.get(DocumentName.class) != null) {
                DocumentName documentName = (DocumentName)docAttributeSet.get(DocumentName.class);
                textSyntax = new JobName(documentName.getValue(), documentName.getLocale());
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            } else {
                String string2 = "JPS Job:" + doc;
                try {
                    Object object = doc.getPrintData();
                    if (object instanceof URL) {
                        string2 = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                textSyntax = new JobName(string2, null);
                this.jobAttrSet.add((Attribute)((Object)textSyntax));
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor docFlavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(Fidelity.class) == Fidelity.FIDELITY_TRUE;
        Attribute[] attributeArray = this.reqAttrSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            Attribute attribute = attributeArray[i];
            Class<? extends Attribute> clazz = attribute.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(clazz)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + clazz, clazz, null);
                }
                if (!this.service.isAttributeValueSupported(attribute, docFlavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attribute, null, attribute);
                }
            }
            if (clazz == Destination.class) {
                URI uRI = ((Destination)attribute).getURI();
                if (!"file".equals(uRI.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestType = DESTFILE;
                    this.mDestination = new File(uRI).getPath();
                }
                catch (Exception exception) {
                    throw new PrintException(exception);
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) continue;
                try {
                    securityManager.checkWrite(this.mDestination);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.notifyEvent(103);
                    throw new PrintException(securityException);
                }
            }
            if (clazz == JobSheets.class) {
                if ((JobSheets)attribute != JobSheets.NONE) continue;
                this.mNoJobSheet = true;
                continue;
            }
            if (clazz == JobName.class) {
                this.jobName = ((JobName)attribute).getValue();
                continue;
            }
            if (clazz == Copies.class) {
                this.copies = ((Copies)attribute).getValue();
                continue;
            }
            if (clazz == Media.class) {
                if (attribute instanceof MediaSizeName) {
                    this.mediaName = (MediaSizeName)attribute;
                    if (this.service.isAttributeValueSupported(attribute, null, null)) continue;
                    this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                    continue;
                }
                if (!(attribute instanceof CustomMediaTray)) continue;
                this.customTray = (CustomMediaTray)attribute;
                continue;
            }
            if (clazz == OrientationRequested.class) {
                this.orient = (OrientationRequested)attribute;
                continue;
            }
            if (clazz == NumberUp.class) {
                this.nUp = (NumberUp)attribute;
                continue;
            }
            if (clazz != Sides.class) continue;
            this.sides = (Sides)attribute;
        }
    }

    private String[] printExecCmd(String string, String string2, boolean bl, String string3, int n, String string4) {
        String[] stringArray;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        int n6 = 16;
        int n7 = 0;
        int n8 = 2;
        int n9 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n7 |= n2;
            ++n8;
        }
        if (string2 != null && !string2.equals("")) {
            n7 |= n3;
            ++n8;
        }
        if (string3 != null && !string3.equals("")) {
            n7 |= n4;
            ++n8;
        }
        if (n > 1) {
            n7 |= n5;
            ++n8;
        }
        if (bl) {
            n7 |= n6;
            ++n8;
        }
        if (UnixPrintServiceLookup.osname.equals("z/OS")) {
            stringArray = new String[++n8];
            stringArray[n9++] = "/usr/lpp/Printsrv/bin/lp";
            stringArray[n9++] = "-c";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-d" + string);
            }
            if ((n7 & n4) != 0) {
                String string5 = "\"";
                stringArray[n9++] = new String("-t " + string5 + string3 + string5);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-n " + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-o nobanner");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String("-o " + string2);
            }
        } else {
            stringArray = new String[n8];
            stringArray[n9++] = System.getProperty("os.name").equals("z/OS") ? "/usr/lpp/Printsrv/bin/lp" : "/usr/bin/lpr";
            if ((n7 & n2) != 0) {
                stringArray[n9++] = new String("-P" + string);
            }
            if ((n7 & n4) != 0) {
                stringArray[n9++] = new String("-J " + string3);
            }
            if ((n7 & n5) != 0) {
                stringArray[n9++] = new String("-#" + new Integer(n).toString());
            }
            if ((n7 & n6) != 0) {
                stringArray[n9++] = new String("-h");
            }
            if ((n7 & n3) != 0) {
                stringArray[n9++] = new String("-o" + string2);
            }
        }
        stringArray[n9++] = string4;
        return stringArray;
    }

    public void cancel() throws PrintException {
        UnixPrintJob unixPrintJob = this;
        synchronized (unixPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrintException pex;

        private PrinterSpooler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() {
            try {
                if (UnixPrintJob.this.spoolFile == null || !UnixPrintJob.this.spoolFile.exists()) {
                    this.pex = new PrintException("No spool file");
                    UnixPrintJob.this.notifyEvent(103);
                    Object var1_1 = null;
                    return var1_1;
                }
                String string = UnixPrintJob.this.spoolFile.getAbsolutePath();
                String[] stringArray = UnixPrintJob.this.printExecCmd(UnixPrintJob.this.mDestination, UnixPrintJob.this.mOptions, UnixPrintJob.this.mNoJobSheet, UnixPrintJob.this.jobName, UnixPrintJob.this.copies, string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                UnixPrintJob.this.spoolFile.delete();
                UnixPrintJob.this.notifyEvent(106);
            }
            catch (IOException iOException) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(iOException);
            }
            catch (InterruptedException interruptedException) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(interruptedException);
            }
            finally {
                UnixPrintJob.this.notifyEvent(105);
            }
            return null;
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrintException pex;
        OutputStream result;

        private PrinterOpener() {
        }

        public Object run() {
            try {
                if (UnixPrintJob.this.mDestType == DESTFILE) {
                    UnixPrintJob.this.spoolFile = new File(UnixPrintJob.this.mDestination);
                } else {
                    UnixPrintJob.this.spoolFile = File.createTempFile("javaprint", ".ps", null);
                    UnixPrintJob.this.spoolFile.deleteOnExit();
                }
                this.result = new FileOutputStream(UnixPrintJob.this.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                UnixPrintJob.this.notifyEvent(103);
                this.pex = new PrintException(iOException);
                return null;
            }
        }
    }
}

