/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Logger;
import sun.awt.FontConfiguration;
import sun.awt.X11GraphicsEnvironment;
import sun.font.FontManager;
import sun.io.CharToByteConverter;
import sun.io.CharToByteISO8859_1;
import sun.java2d.SunGraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFontConfiguration
extends FontConfiguration {
    private static FontConfiguration fontConfig = null;
    private static Logger logger;
    private static final String fontsDirPrefix = "$JRE_LIB_FONTS";
    private String[][] motifFontSets = new String[5][4];
    private static HashMap encodingMap;

    public MFontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment) {
        super(sunGraphicsEnvironment);
        if (SunGraphicsEnvironment.debugFonts) {
            logger = Logger.getLogger("sun.awt.FontConfiguration");
        }
        this.initTables();
    }

    public MFontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment, boolean bl, boolean bl2) {
        super(sunGraphicsEnvironment, bl, bl2);
        if (SunGraphicsEnvironment.debugFonts) {
            logger = Logger.getLogger("sun.awt.FontConfiguration");
        }
        this.initTables();
    }

    @Override
    protected void initReorderMap() {
        this.reorderMap = new HashMap();
        if (osName == null) {
            this.initReorderMapForSolaris();
        } else {
            this.initReorderMapForLinux();
        }
    }

    private void initReorderMapForSolaris() {
        this.reorderMap.put("UTF-8.hi", "devanagari");
        this.reorderMap.put("UTF-8.ja", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("UTF-8.ko", "korean-johab");
        this.reorderMap.put("UTF-8.th", "thai");
        this.reorderMap.put("UTF-8.zh.TW", "chinese-big5");
        this.reorderMap.put("UTF-8.zh.HK", this.split("chinese-big5,chinese-hkscs"));
        if (FontManager.isSolaris8) {
            this.reorderMap.put("UTF-8.zh.CN", this.split("chinese-gb2312,chinese-big5"));
        } else {
            this.reorderMap.put("UTF-8.zh.CN", this.split("chinese-gb18030-0,chinese-gb18030-1"));
        }
        this.reorderMap.put("UTF-8.zh", this.split("chinese-big5,chinese-hkscs,chinese-gb18030-0,chinese-gb18030-1"));
        this.reorderMap.put("Big5", "chinese-big5");
        this.reorderMap.put("Big5-HKSCS", this.split("chinese-big5,chinese-hkscs"));
        this.reorderMap.put("GB2312", "chinese-gb2312");
        this.reorderMap.put("x-EUC-TW", this.split("chinese-cns11643-1,chinese-cns11643-2,chinese-cns11643-3"));
        this.reorderMap.put("GBK", "chinese-gbk");
        this.reorderMap.put("GB18030", this.split("chinese-gb18030-0,chinese-gb18030-1"));
        this.reorderMap.put("TIS-620", "thai");
        this.reorderMap.put("x-PCK", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("x-eucJP-Open", this.split("japanese-x0201,japanese-x0208,japanese-x0212"));
        this.reorderMap.put("EUC-KR", "korean");
        this.reorderMap.put("ISO-8859-2", "latin-2");
        this.reorderMap.put("ISO-8859-5", "cyrillic-iso8859-5");
        this.reorderMap.put("windows-1251", "cyrillic-cp1251");
        this.reorderMap.put("KOI8-R", "cyrillic-koi8-r");
        this.reorderMap.put("ISO-8859-6", "arabic");
        this.reorderMap.put("ISO-8859-7", "greek");
        this.reorderMap.put("ISO-8859-8", "hebrew");
        this.reorderMap.put("ISO-8859-9", "latin-5");
        this.reorderMap.put("ISO-8859-13", "latin-7");
        this.reorderMap.put("ISO-8859-15", "latin-9");
    }

    private void initReorderMapForLinux() {
        this.reorderMap.put("x-euc-jp-linux", this.split("japanese-x0201,japanese-x0208"));
        this.reorderMap.put("GB2312", "chinese-gb18030");
        this.reorderMap.put("Big5", "chinese-big5");
        this.reorderMap.put("EUC-KR", "korean");
        this.reorderMap.put("GB18030", "chinese-gb18030");
    }

    @Override
    protected void setOsNameAndVersion() {
        super.setOsNameAndVersion();
        if (osName.equals("SunOS")) {
            osName = null;
        } else if (osName.equals("Linux")) {
            try {
                File file = new File("/etc/sun-release");
                if (file.canRead()) {
                    osName = "Sun";
                    osVersion = this.getVersionString(file);
                } else {
                    file = new File("/etc/redhat-release");
                    if (file.canRead()) {
                        osName = "RedHat";
                        osVersion = this.getVersionString(file);
                    } else {
                        file = new File("/etc/turbolinux-release");
                        if (file.canRead()) {
                            osName = "Turbo";
                            osVersion = this.getVersionString(file);
                        } else {
                            file = new File("/etc/SuSE-release");
                            if (file.canRead()) {
                                osName = "SuSE";
                                osVersion = this.getVersionString(file);
                            } else {
                                file = new File("/etc/lsb-release");
                                if (file.canRead()) {
                                    this.getDistribString(file);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getDistribString(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("DISTRIB_ID=") == 0) {
                    string2 = string.substring("DISTRIB_ID=".length());
                    continue;
                }
                if (string.indexOf("DISTRIB_RELEASE=") != 0) continue;
                string3 = string.substring("DISTRIB_RELEASE=".length());
            }
            bufferedReader.close();
            if (string2 != null && string3 != null) {
                osName = string2;
                osVersion = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getVersionString(File file) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getPath())));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            if (string == null) {
                return null;
            }
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            for (n = 0; n < n2 && !Character.isDigit(cArray[n]); ++n) {
            }
            if (n < n2) {
                for (n3 = n; n3 < n2 && (cArray[n3] == '.' || Character.isDigit(cArray[n3])); ++n3) {
                }
                return new String(cArray, n, n3 - n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected String mapFileName(String string) {
        if (string != null && string.startsWith(fontsDirPrefix)) {
            return SunGraphicsEnvironment.jreFontDirName + string.substring(fontsDirPrefix.length());
        }
        return string;
    }

    @Override
    public String getFallbackFamilyName(String string, String string2) {
        String string3 = this.getCompatibilityFamilyName(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    @Override
    protected String getEncoding(String string, String string2) {
        String string3;
        int n = 0;
        int n2 = 13;
        while (n2-- > 0 && n >= 0) {
            n = string.indexOf("-", n) + 1;
        }
        if (n == -1) {
            return "default";
        }
        String string4 = string.substring(n);
        if (string4.indexOf("fontspecific") > 0) {
            if (string.indexOf("dingbats") > 0) {
                return "sun.awt.motif.CharToByteX11Dingbats";
            }
            if (string.indexOf("symbol") > 0) {
                return "sun.awt.CharToByteSymbol";
            }
        }
        if ((string3 = (String)encodingMap.get(string4)) == null) {
            string3 = "default";
        }
        return string3;
    }

    @Override
    protected CharToByteConverter getDefaultFontCharset(String string) {
        return new CharToByteISO8859_1();
    }

    public String getMotifFontSet(String string, int n) {
        assert (MFontConfiguration.isLogicalFontFamilyName(string));
        string = string.toLowerCase(Locale.ENGLISH);
        int n2 = MFontConfiguration.getFontIndex(string);
        int n3 = MFontConfiguration.getStyleIndex(n);
        return this.getMotifFontSet(n2, n3);
    }

    private String getMotifFontSet(int n, int n2) {
        String string = this.motifFontSets[n][n2];
        if (string == null) {
            this.motifFontSets[n][n2] = string = this.buildMotifFontSet(n, n2);
        }
        return string;
    }

    private String buildMotifFontSet(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        short[] sArray = this.getCoreScripts(n);
        for (int i = 0; i < sArray.length; ++i) {
            String string;
            short s = MFontConfiguration.getComponentFontIDMotif(sArray[i], n, n2);
            if (s == 0) {
                s = MFontConfiguration.getComponentFontID(sArray[i], n, n2);
            }
            if ((string = MFontConfiguration.getComponentFontName(s)) == null || string.endsWith("fontspecific")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getFaceNameFromComponentFontName(String string) {
        return null;
    }

    @Override
    protected String getFileNameFromComponentFontName(String string) {
        String string2 = this.getFileNameFromPlatformName(string);
        if (string2 != null && string2.charAt(0) == '/' && !this.needToSearchForFile(string2)) {
            return string2;
        }
        return ((X11GraphicsEnvironment)this.environment).getFileNameFromXLFD(string);
    }

    private static String getDefaultMotifFontSet() {
        String string = ((MFontConfiguration)MFontConfiguration.getFontConfiguration()).getMotifFontSet("sansserif", 0);
        if (string != null) {
            int n;
            while ((n = string.indexOf("%d")) >= 0) {
                string = string.substring(0, n) + "140" + string.substring(n + 2);
            }
        }
        return string;
    }

    @Override
    public HashSet<String> getAWTFontPathSet() {
        HashSet<String> hashSet = new HashSet<String>();
        short[] sArray = this.getCoreScripts(0);
        for (int i = 0; i < sArray.length; ++i) {
            String string = MFontConfiguration.getString(table_awtfontpaths[sArray[i]]);
            if (string == null) continue;
            int n = 0;
            int n2 = string.indexOf(58);
            while (n2 >= 0) {
                hashSet.add(string.substring(n, n2));
                n = n2 + 1;
                n2 = string.indexOf(58, n);
            }
            hashSet.add(n == 0 ? string : string.substring(n));
        }
        return hashSet;
    }

    private void initTables() {
        encodingMap.put("iso8859-1", "sun.io.CharToByteISO8859_1");
        encodingMap.put("iso8859-2", "sun.io.CharToByteISO8859_2");
        encodingMap.put("iso8859-4", "sun.io.CharToByteISO8859_4");
        encodingMap.put("iso8859-5", "sun.io.CharToByteISO8859_5");
        encodingMap.put("iso8859-6", "sun.io.CharToByteISO8859_6");
        encodingMap.put("iso8859-7", "sun.io.CharToByteISO8859_7");
        encodingMap.put("iso8859-8", "sun.io.CharToByteISO8859_8");
        encodingMap.put("iso8859-9", "sun.io.CharToByteISO8859_9");
        encodingMap.put("iso8859-13", "sun.io.CharToByteISO8859_13");
        encodingMap.put("iso8859-15", "sun.io.CharToByteISO8859_15");
        encodingMap.put("gb2312.1980-0", "sun.awt.motif.CharToByteX11GB2312");
        if (osName == null) {
            encodingMap.put("gbk-0", "sun.io.CharToByteGBK");
        } else {
            encodingMap.put("gbk-0", "sun.awt.motif.CharToByteX11GBK");
        }
        encodingMap.put("gb18030.2000-0", "sun.awt.motif.CharToByteX11GB18030_0");
        encodingMap.put("gb18030.2000-1", "sun.awt.motif.CharToByteX11GB18030_1");
        encodingMap.put("cns11643-1", "sun.awt.motif.CharToByteX11CNS11643P1");
        encodingMap.put("cns11643-2", "sun.awt.motif.CharToByteX11CNS11643P2");
        encodingMap.put("cns11643-3", "sun.awt.motif.CharToByteX11CNS11643P3");
        encodingMap.put("big5-1", "sun.io.CharToByteBig5");
        encodingMap.put("big5-0", "sun.io.CharToByteBig5");
        encodingMap.put("hkscs-1", "sun.io.CharToByteBig5_HKSCS");
        encodingMap.put("ansi-1251", "sun.io.CharToByteCp1251");
        encodingMap.put("koi8-r", "sun.io.CharToByteKOI8_R");
        encodingMap.put("jisx0201.1976-0", "sun.awt.motif.CharToByteX11JIS0201");
        encodingMap.put("jisx0208.1983-0", "sun.awt.motif.CharToByteX11JIS0208");
        encodingMap.put("jisx0212.1990-0", "sun.awt.motif.CharToByteX11JIS0212");
        if (SunGraphicsEnvironment.isLinux) {
            encodingMap.put("ksc5601.1987-0", "sun.awt.motif.CharToByteX11KSC5601");
        } else {
            encodingMap.put("ksc5601.1987-0", "sun.io.CharToByteCp971");
        }
        encodingMap.put("ksc5601.1992-3", "sun.awt.motif.CharToByteX11Johab");
        encodingMap.put("tis620.2533-0", "sun.io.CharToByteTIS620");
        encodingMap.put("iso10646-1", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ibm-udcjp", "sun.awt.motif.CharToByteIBM_udcJP");
        encodingMap.put("ucs-2", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.cjk-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.cjk_japan-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.cjk_china-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.cjk_korea-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.cjk_taiwan-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.thai-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.base-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ucs2.i18n-0", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("iso10646-2", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("unicode-2", "sun.io.CharToByteUnicodeBigUnmarked");
        encodingMap.put("ibm-1046", "sun.io.CharToByteCp1046");
    }

    static {
        encodingMap = new HashMap();
    }
}

